/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl;

import com.mrshiehx.cmcl.bean.RunningMinecraft;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.constants.languages.LanguageEnum;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.functions.Functions;
import com.mrshiehx.cmcl.functions.root.RootFunction;
import com.mrshiehx.cmcl.functions.root.VersionStarter;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.console.CommandUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.system.JavaUtils;
import com.mrshiehx.cmcl.utils.system.OperatingSystem;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;

public class CMCL {
    public static File gameDir;
    public static File assetsDir;
    public static File resourcePacksDir;
    public static File versionsDir;
    public static File librariesDir;
    public static File launcherProfiles;
    public static RunningMinecraft runningMc;
    private static JSONObject configJSONObject;
    public static String javaPath;
    private static LanguageEnum languageEnum;
    private static Locale locale;
    public static boolean isImmersiveMode;

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (runningMc != null && CMCL.runningMc.exitWithMinecraft && CMCL.runningMc.process.isAlive()) {
                CMCL.runningMc.process.destroy();
            }
        }));
        CMCL.main(args, true);
    }

    private static void main(String[] args, boolean judgeSimplifiedCommand) {
        if (args.length == 0) {
            JSONObject jsonObject = Utils.getConfig();
            String version = jsonObject.optString("selectedVersion");
            if (!version.isEmpty()) {
                VersionStarter.start(version, jsonObject);
            } else {
                RootFunction.printHelp();
            }
        } else {
            String first = args[0];
            Function function = Functions.get(first);
            Arguments arguments = new Arguments(args, true);
            if (function != null) {
                Argument second = arguments.optArgument(1);
                if (second == null) {
                    System.out.println(CMCL.getHelpDocumentation(function.getUsageName()));
                    return;
                }
                if ("h".equals(second.key) || "help".equals(second.key)) {
                    if (second instanceof SingleArgument) {
                        String name = function.getUsageName();
                        if (!CMCL.isEmpty(name)) {
                            System.out.println(CMCL.getHelpDocumentation(name));
                        } else {
                            RootFunction.printHelp();
                        }
                    } else {
                        System.out.println(CMCL.getString("CONSOLE_HELP_WRONG_WRITE", second.originString));
                    }
                } else {
                    function.execute(arguments);
                }
            } else {
                function = new RootFunction();
                if (judgeSimplifiedCommand) {
                    String originCommand = Utils.getConfig().optJSONObject("simplifyCommands", new JSONObject()).optString(first);
                    if (!CMCL.isEmpty(originCommand)) {
                        CMCL.main(CommandUtils.splitCommand(CommandUtils.clearRedundantSpaces(originCommand)).toArray(new String[0]), false);
                    } else {
                        function.execute(arguments);
                    }
                } else {
                    function.execute(arguments);
                }
            }
        }
    }

    public static String getHelpDocumentation(String name) {
        if (CMCL.isEmpty(name)) {
            return null;
        }
        String helpDocumentation = CMCL.getLanguage().getHelpMap().get(name);
        return !CMCL.isEmpty(helpDocumentation) ? helpDocumentation : "";
    }

    public static JSONObject initConfig() {
        File configFile = CMCL.getConfigFile();
        if (configFile.exists()) {
            String configFileContent;
            String EXCEPTION_READ_CONFIG_FILE = LanguageEnum.overriddenValueOf(Locale.getDefault().getLanguage()).getTextMap().get("EXCEPTION_READ_CONFIG_FILE");
            try {
                configFileContent = FileUtils.readFileContent(configFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(String.format(EXCEPTION_READ_CONFIG_FILE, e));
                System.exit(1);
                return configJSONObject;
            }
            if (CMCL.isEmpty(configFileContent)) {
                configJSONObject = new JSONObject();
            } else {
                try {
                    configJSONObject = new JSONObject(configFileContent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(String.format(EXCEPTION_READ_CONFIG_FILE, e));
                    System.exit(1);
                    return configJSONObject;
                }
            }
            JSONArray accounts = configJSONObject.optJSONArray("accounts");
            if (accounts != null && accounts.length() > 0) {
                boolean alreadyHave = false;
                for (Object o : accounts) {
                    JSONObject account;
                    if (!(o instanceof JSONObject) || !(account = (JSONObject)o).optBoolean("selected")) continue;
                    if (alreadyHave) {
                        account.put("selected", false);
                        continue;
                    }
                    alreadyHave = true;
                }
                for (int i = accounts.length() - 1; i >= 0; --i) {
                    if (AccountUtils.isValidAccount(accounts.opt(i))) continue;
                    accounts.remove(i);
                }
                Utils.saveConfig(configJSONObject);
            }
            javaPath = configJSONObject.optString("javaPath", JavaUtils.getDefaultJavaPath());
            gameDir = new File(!CMCL.isEmpty(configJSONObject.optString("gameDir")) ? configJSONObject.optString("gameDir") : ".minecraft");
            assetsDir = !CMCL.isEmpty(configJSONObject.optString("assetsDir")) ? new File(configJSONObject.optString("assetsDir")) : new File(gameDir, "assets");
            resourcePacksDir = !CMCL.isEmpty(configJSONObject.optString("resourcesDir")) ? new File(configJSONObject.optString("resourcesDir")) : new File(gameDir, "resourcepacks");
        } else {
            CMCL.initDefaultDirs();
            configJSONObject = new JSONObject();
            configJSONObject.put("language", Locale.getDefault().getLanguage());
            javaPath = JavaUtils.getDefaultJavaPath();
            configJSONObject.put("javaPath", javaPath);
            configJSONObject.put("maxMemory", SystemUtils.getDefaultMemory());
            configJSONObject.put("windowSizeWidth", 854);
            configJSONObject.put("windowSizeHeight", 480);
            try {
                FileUtils.createFile(configFile, false);
                FileWriter writer = new FileWriter(configFile, false);
                writer.write(configJSONObject.toString(2));
                writer.close();
            }
            catch (IOException e) {
                if (Constants.isDebug()) {
                    e.printStackTrace();
                }
                e.printStackTrace();
            }
        }
        CMCL.initChangelessDirs();
        CMCL.initProxyIfEnabled(configJSONObject);
        return configJSONObject;
    }

    private static void initChangelessDirs() {
        versionsDir = new File(gameDir, "versions");
        librariesDir = new File(gameDir, "libraries");
        launcherProfiles = new File(gameDir, "launcher_profiles.json");
    }

    private static void initDefaultDirs() {
        gameDir = new File(".minecraft");
        assetsDir = new File(gameDir, "assets");
        resourcePacksDir = new File(gameDir, "resourcepacks");
    }

    private static void initProxyIfEnabled(JSONObject configContent) {
        boolean proxyEnabled = configContent.optBoolean("proxyEnabled");
        String proxyHost = configContent.optString("proxyHost");
        String proxyPort = configContent.optString("proxyPort");
        if (!proxyEnabled || CMCL.isEmpty(proxyHost) || CMCL.isEmpty(proxyPort)) {
            return;
        }
        NetworkUtils.setProxy(proxyHost, proxyPort, configContent.optString("proxyUsername"), configContent.optString("proxyPassword"));
    }

    public static boolean isEmpty(String s) {
        return null == s || s.length() == 0;
    }

    public static boolean isEmpty(JSONObject s) {
        return null == s || s.length() == 0;
    }

    public static String getString(String name, Object ... objects) {
        return String.format(CMCL.getString(name), objects);
    }

    public static String getString(String name) {
        String text = CMCL.getLanguage().getTextMap().get(name);
        if (!Utils.isEmpty(text)) {
            return text;
        }
        String inEnglish = LanguageEnum.ENGLISH.getTextMap().get(name);
        if (!Utils.isEmpty(inEnglish)) {
            return inEnglish;
        }
        return name;
    }

    public static LanguageEnum getLanguage() {
        if (languageEnum == null) {
            String languageString = Utils.getConfig().optString("language");
            if (CMCL.isEmpty(languageString)) {
                languageEnum = LanguageEnum.overriddenValueOf(Locale.getDefault().getLanguage());
                Utils.saveConfig(Utils.getConfig().put("language", CMCL.languageEnum.codes.stream().findAny().orElse("en")));
            } else {
                languageEnum = LanguageEnum.overriddenValueOf(languageString);
            }
        }
        return languageEnum;
    }

    public static List<String> listVersions(File versionsDir) {
        ArrayList<String> versionsStrings = new ArrayList<String>();
        if (versionsDir == null) {
            return versionsStrings;
        }
        File[] files = versionsDir.listFiles(pathname -> {
            if (!pathname.isDirectory()) {
                return false;
            }
            File[] files1 = pathname.listFiles();
            if (files1 == null || files1.length < 1) {
                return false;
            }
            return new File(pathname, pathname.getName() + ".json").exists();
        });
        if (files != null) {
            for (File file : files) {
                versionsStrings.add(file.getName());
            }
        }
        return versionsStrings;
    }

    public static void createLauncherProfiles() {
        if (launcherProfiles.exists()) {
            return;
        }
        try {
            launcherProfiles.createNewFile();
            FileUtils.writeFile(launcherProfiles, "{\"selectedProfile\": \"(Default)\",\"profiles\": {\"(Default)\": {\"name\": \"(Default)\"}},\"clientToken\": \"88888888-8888-8888-8888-888888888888\"}", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Locale getLocale() {
        if (locale == null) {
            locale = CMCL.getLanguage().locale;
        }
        return locale;
    }

    public static File getConfigFile() {
        if (Constants.isDebug()) {
            return Constants.DEFAULT_CONFIG_FILE;
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
            File inConfigDir = new File(System.getProperty("user.home"), ".config/cmcl/cmcl.json");
            if (inConfigDir.exists()) {
                return inConfigDir;
            }
            if (Constants.DEFAULT_CONFIG_FILE.exists()) {
                return Constants.DEFAULT_CONFIG_FILE;
            }
            return inConfigDir;
        }
        if (Constants.DEFAULT_CONFIG_FILE.exists() && Constants.DEFAULT_CONFIG_FILE.canWrite()) {
            return Constants.DEFAULT_CONFIG_FILE;
        }
        String executableFilePath = Utils.getExecutableFilePath();
        File executableFile = new File(!Utils.isEmpty(executableFilePath) ? executableFilePath : ".");
        return new File(executableFile.isDirectory() ? executableFile : Optional.ofNullable(executableFile.getParentFile()).orElse(new File(".")), "cmcl.json");
    }

    public static void saveConfig(JSONObject jsonObject) {
        configJSONObject = jsonObject;
        File configFile = CMCL.getConfigFile();
        try {
            if (!configFile.exists()) {
                FileUtils.createFile(configFile, false);
            }
            FileWriter writer = new FileWriter(configFile, false);
            writer.write(jsonObject.toString(2));
            writer.close();
        }
        catch (IOException e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(CMCL.getString("EXCEPTION_SAVE_CONFIG", e));
        }
    }

    public static JSONObject getConfig() {
        if (configJSONObject != null) {
            return configJSONObject;
        }
        return CMCL.initConfig();
    }

    public static File getCMCLWorkingDirectory() {
        if (Constants.isDebug()) {
            return new File(".cmcl");
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX || OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
            return new File(System.getProperty("user.home"), ".cmcl");
        }
        String executableFilePath = Utils.getExecutableFilePath();
        File executableFile = new File(!Utils.isEmpty(executableFilePath) ? executableFilePath : ".");
        return new File(executableFile.isDirectory() ? executableFile : Optional.ofNullable(executableFile.getParentFile()).orElse(new File(".")), ".cmcl");
    }

    static {
        CMCL.initConfig();
    }
}

