/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.bean;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.utils.Utils;
import java.io.File;

public class SplitLibraryName {
    public final String first;
    public final String second;
    public final String version;
    public final String classifier;
    public final String extension;

    public SplitLibraryName(String first, String second, String version) {
        this(first, second, version, null);
    }

    public SplitLibraryName(String first, String second, String version, String classifier) {
        this(first, second, version, classifier, ".jar");
    }

    public SplitLibraryName(String first, String second, String version, String classifier, String extension) {
        this.first = first;
        this.second = second;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
    }

    public static SplitLibraryName valueOf(String libraryName) {
        String[] nameSplit;
        if (Utils.isEmpty(libraryName)) {
            return null;
        }
        String extension = ".jar";
        if (libraryName.contains("@")) {
            extension = "." + libraryName.substring(libraryName.indexOf("@") + 1);
            libraryName = libraryName.substring(0, libraryName.indexOf("@"));
        }
        if ((nameSplit = libraryName.split(":")).length < 3) {
            return null;
        }
        return new SplitLibraryName(nameSplit[0], nameSplit[1], nameSplit[2], nameSplit.length >= 4 ? nameSplit[3] : null, extension);
    }

    public String getFileName() {
        return this.second + "-" + this.version + (!Utils.isEmpty(this.classifier) ? "-" + this.classifier : "") + this.extension;
    }

    public File getPhysicalFile() {
        String libraryFileName = this.getFileName();
        String libraryFileAndDirectoryName = Utils.getPathFromLibraryName(this);
        return new File(new File(CMCL.librariesDir, libraryFileAndDirectoryName), libraryFileName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.first).append(':').append(this.second).append(':').append(this.version);
        if (!Utils.isEmpty(this.classifier)) {
            sb.append(':').append(this.classifier);
        }
        if (!".jar".equals(this.extension)) {
            sb.append('@').append(this.extension.substring(1));
        }
        return sb.toString();
    }
}

