/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.bean.arguments;

import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.ArgumentRequirement;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.TextArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.CommandUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class Arguments {
    private final List<Argument> arguments = new LinkedList<Argument>();
    private int size;

    public Arguments(String args, boolean removeDuplicate) {
        this(CommandUtils.splitCommand(CommandUtils.clearRedundantSpaces(args)).toArray(new String[0]), removeDuplicate);
    }

    public Arguments(String[] args, boolean removeDuplicate) {
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            String item = args[i];
            if (item.startsWith("--") && item.length() > 2) {
                String rear = item.substring(2);
                int index = rear.indexOf(61);
                if (index == -1) {
                    String next;
                    String value = null;
                    if (i + 1 != length && !(next = args[i + 1]).startsWith("-")) {
                        value = next;
                        ++i;
                    }
                    this.arguments.add(value != null ? new ValueArgument(item + " " + value, new String[]{item, value}, rear, value) : new SingleArgument(item, new String[]{item}, rear));
                    continue;
                }
                String key = rear.substring(0, index);
                String value = rear.substring(index + 1);
                this.arguments.add(new ValueArgument(item, new String[]{item}, key, value));
                continue;
            }
            if (item.startsWith("-") && item.length() > 1) {
                if (item.length() == 2) {
                    String next;
                    String key = item.substring(1);
                    String value = null;
                    if (i + 1 != length && !(next = args[i + 1]).startsWith("-")) {
                        value = next;
                        ++i;
                    }
                    this.arguments.add(value != null ? new ValueArgument(item + " " + value, new String[]{item, value}, key, value) : new SingleArgument(item, new String[]{item}, key));
                    continue;
                }
                this.arguments.add(new ValueArgument(item, new String[]{item}, item.substring(1, 2), item.substring(2)));
                continue;
            }
            this.arguments.add(new TextArgument(item));
        }
        if (removeDuplicate) {
            Utils.removeDuplicate(this.arguments);
        }
        this.size = this.arguments.size();
    }

    public int getSize() {
        return this.size;
    }

    public Arguments removeDuplicate() {
        Utils.removeDuplicate(this.arguments);
        this.size = this.arguments.size();
        return this;
    }

    public boolean equals(int number, String target) {
        if (number >= 0 && number < this.size) {
            Argument s = this.optArgument(number);
            return s.equals(target);
        }
        return false;
    }

    public Argument optArgument(String name) {
        for (Argument argument : this.arguments) {
            if (!argument.equals(name)) continue;
            return argument;
        }
        return null;
    }

    public List<Argument> optArguments(String name) {
        LinkedList<Argument> list = new LinkedList<Argument>();
        for (Argument argument : this.arguments) {
            if (!argument.equals(name)) continue;
            list.add(argument);
        }
        return list;
    }

    public String opt(String name) {
        return this.opt(name, "");
    }

    public String opt(String name, String def) {
        Argument argument = this.optArgument(name);
        return argument instanceof ValueArgument ? ((ValueArgument)argument).value : def;
    }

    public int optInt(String name) {
        return this.optInt(name, 0);
    }

    public int optInt(String name, int defaultValue) {
        String s = this.opt(name, null);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean optBoolean(String name) {
        return this.optBoolean(name, false);
    }

    public boolean optBoolean(String name, boolean defaultValue) {
        String s = this.opt(name, null);
        if (s != null) {
            try {
                return Boolean.parseBoolean(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public double optDouble(String name) {
        return this.optDouble(name, 0.0);
    }

    public double optDouble(String name, double defaultValue) {
        String s = this.opt(name, null);
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean contains(String target) {
        for (Argument argument : this.arguments) {
            if (!argument.equals(target)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Argument target) {
        for (Argument argument : this.arguments) {
            if (!argument.equals(target)) continue;
            return true;
        }
        return false;
    }

    public Argument optArgument(int i) {
        if (i >= 0 && i < this.size) {
            return this.arguments.get(i);
        }
        return null;
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String toString() {
        return this.toString("--");
    }

    public String toString(String argKeyStart) {
        if (Utils.isEmpty(argKeyStart)) {
            argKeyStart = "-";
        }
        StringBuilder sb = new StringBuilder();
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            Argument argument = this.arguments.get(i);
            if (argument instanceof TextArgument) {
                sb.append(argument.key);
            } else if (argument instanceof SingleArgument) {
                sb.append(argKeyStart).append(argument.key);
            } else if (argument instanceof ValueArgument) {
                String value = ((ValueArgument)argument).value;
                if (value.contains(" ")) {
                    value = "\"" + value + "\"";
                }
                sb.append(argKeyStart).append(argument.key).append(' ').append(value);
            }
            if (i + 1 >= size) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static Arguments valueOf(List<String> strings, boolean isForCMCL) {
        return new Arguments(strings.toArray(new String[0]), isForCMCL);
    }

    public Arguments merge(Arguments arguments) {
        if (arguments == null || arguments.arguments.size() == 0) {
            return this;
        }
        for (Argument argument : arguments.arguments) {
            if (this.arguments.contains(argument)) continue;
            this.arguments.add(argument);
        }
        this.size = this.arguments.size();
        return this;
    }

    public List<Argument> exclude(ArgumentRequirement[] arguments, int offsetForOrigin) {
        if (arguments == null || arguments.length == 0) {
            return Collections.unmodifiableList(this.arguments);
        }
        if (this.size == 0) {
            return Collections.emptyList();
        }
        HashMap map = new HashMap();
        for (ArgumentRequirement argReq : arguments) {
            if (map.get(argReq.key) != null) {
                ((List)map.get(argReq.key)).add(argReq.clazz);
                continue;
            }
            LinkedList<Class<? extends Argument>> list = new LinkedList<Class<? extends Argument>>();
            list.add(argReq.clazz);
            map.put(argReq.key, list);
        }
        return this.arguments.subList(offsetForOrigin, this.arguments.size()).stream().filter(argument -> !(argument instanceof TextArgument) && (map.get(argument.key) == null || !((List)map.get(argument.key)).contains(argument.getClass()))).collect(Collectors.toList());
    }
}

