/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.constants.languages;

import com.mrshiehx.cmcl.constants.languages.English;
import com.mrshiehx.cmcl.constants.languages.Language;
import com.mrshiehx.cmcl.constants.languages.chinese.Cantonese;
import com.mrshiehx.cmcl.constants.languages.chinese.SimplifiedChinese;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum LanguageEnum {
    SIMPLIFIED_CHINESE(Collections.singleton("zh"), new SimplifiedChinese(), Locale.SIMPLIFIED_CHINESE),
    ENGLISH(Collections.singleton("en"), new English(), Locale.ENGLISH),
    CANTONESE(Collections.singleton("cantonese"), new Cantonese(), Locale.CHINA);

    public final Set<String> codes;
    public final Locale locale;
    public final Language language;
    private Map<String, String> textMap;
    private Map<String, String> helpMap;

    private LanguageEnum(Set<String> code, Language language, Locale locale) {
        this.codes = code;
        this.language = language;
        this.locale = locale;
    }

    public Map<String, String> getTextMap() {
        if (this.textMap == null) {
            this.textMap = this.language.getTextMap();
        }
        return this.textMap;
    }

    public Map<String, String> getHelpMap() {
        if (this.helpMap == null) {
            this.helpMap = this.language.getHelpMap();
        }
        return this.helpMap;
    }

    public static LanguageEnum overriddenValueOf(String code) {
        for (LanguageEnum languageEnum : LanguageEnum.values()) {
            if (!languageEnum.codes.contains(code)) continue;
            return languageEnum;
        }
        return ENGLISH;
    }
}

