/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.ArgumentRequirement;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.exceptions.NotSelectedException;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.interfaces.filters.JSONObjectFilter;
import com.mrshiehx.cmcl.modules.account.authentication.AccountRefresher;
import com.mrshiehx.cmcl.modules.account.authentication.microsoft.MicrosoftAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.YggdrasilAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorApiProvider;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.nide8auth.Nide8AuthAuthentication;
import com.mrshiehx.cmcl.modules.account.skin.SkinDownloader;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class AccountFunction
implements Function {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Arguments arguments) {
        if (!Function.checkArgs(arguments, 2, 1, ArgumentRequirement.ofSingle("l"), ArgumentRequirement.ofSingle("list"), ArgumentRequirement.ofSingle("r"), ArgumentRequirement.ofSingle("refresh"), ArgumentRequirement.ofSingle("cape"), ArgumentRequirement.ofSingle("skin"), ArgumentRequirement.ofSingle("s"), ArgumentRequirement.ofSingle("select"), ArgumentRequirement.ofValue("s"), ArgumentRequirement.ofValue("select"), ArgumentRequirement.ofValue("n"), ArgumentRequirement.ofValue("name"), ArgumentRequirement.ofValue("address"), ArgumentRequirement.ofValue("serverId"), ArgumentRequirement.ofValue("d"), ArgumentRequirement.ofValue("delete"), ArgumentRequirement.ofValue("cape"), ArgumentRequirement.ofValue("download-skin"), ArgumentRequirement.ofValue("skin"), ArgumentRequirement.ofValue("login"))) {
            return;
        }
        JSONObject config = Utils.getConfig();
        JSONArray accounts = config.optJSONArray("accounts");
        if (accounts == null) {
            accounts = new JSONArray();
            config.put("accounts", accounts);
        }
        if (arguments.optArgument(1) instanceof SingleArgument) {
            SingleArgument argument = (SingleArgument)arguments.optArgument(1);
            switch (argument.key) {
                case "l": 
                case "list": {
                    AtomicInteger i = new AtomicInteger();
                    PrintingUtils.printTable(new String[]{CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_SELECTED"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_ORDER"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_NAME"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_TYPE"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_OTHER_INFORMATION")}, new int[]{8, 6, 20, 24, 50}, false, (String[][])AccountFunction.getAllAccounts(accounts).stream().map(account -> AccountFunction.accountInfoToTableItem(account, i.getAndIncrement(), true)).collect(Collectors.toList()).toArray((T[])new String[0][0]));
                    return;
                }
                case "r": 
                case "refresh": {
                    JSONObject account2 = null;
                    try {
                        account2 = AccountUtils.getSelectedAccount(config, true);
                    }
                    catch (NotSelectedException notSelectedException) {
                        // empty catch block
                    }
                    if (account2 == null) {
                        return;
                    }
                    try {
                        if (!AccountRefresher.execute(account2, accounts)) return;
                        Utils.saveConfig(config);
                        return;
                    }
                    catch (ExceptionWithDescription e) {
                        e.print();
                    }
                    return;
                }
                case "cape": {
                    JSONObject account3;
                    try {
                        account3 = AccountUtils.getSelectedAccount(config, true);
                    }
                    catch (NotSelectedException e) {
                        return;
                    }
                    int loginMethod = account3.optInt("loginMethod");
                    if (loginMethod != 0) {
                        System.out.println(CMCL.getString("ONLY_OFFLINE"));
                        return;
                    }
                    account3.remove("cape");
                    Utils.saveConfig(config);
                    return;
                }
                case "skin": {
                    JSONObject account4;
                    try {
                        account4 = AccountUtils.getSelectedAccount(config, true);
                    }
                    catch (NotSelectedException e) {
                        return;
                    }
                    if (account4.optInt("loginMethod") == 0) {
                        account4.remove("providedSkin");
                        account4.remove("offlineSkin");
                        account4.remove("slim");
                        Utils.saveConfig(config);
                        return;
                    }
                    System.out.println(CMCL.getString("SKIN_CANCEL_ONLY_FOR_OFFLINE"));
                    return;
                }
                default: {
                    System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", argument.originArray[0]));
                }
            }
            return;
        }
        if (arguments.optArgument(1) instanceof ValueArgument) {
            Argument arg = arguments.optArgument(1);
            String value = ((ValueArgument)arg).value;
            switch (arg.key) {
                case "cape": {
                    JSONObject account5;
                    try {
                        account5 = AccountUtils.getSelectedAccount(config, true);
                    }
                    catch (NotSelectedException e) {
                        return;
                    }
                    int loginMethod = account5.optInt("loginMethod");
                    if (loginMethod != 0) {
                        System.out.println(CMCL.getString("ONLY_OFFLINE"));
                        return;
                    }
                    File file = new File(value);
                    if (!file.exists() || file.isDirectory()) {
                        System.out.println(CMCL.getString("FILE_NOT_FOUND_OR_IS_A_DIRECTORY"));
                        return;
                    }
                    account5.put("cape", file.getAbsolutePath());
                    Utils.saveConfig(config);
                    return;
                }
                case "skin": {
                    JSONObject account6;
                    try {
                        account6 = AccountUtils.getSelectedAccount(config, true);
                    }
                    catch (NotSelectedException e) {
                        return;
                    }
                    int loginMethod = account6.optInt("loginMethod");
                    if (!"steve".equals(value) && !"alex".equals(value)) {
                        if (loginMethod == 1) {
                            File file = new File(value);
                            if (!file.exists() || file.isDirectory()) {
                                System.out.println(CMCL.getString("FILE_NOT_FOUND_OR_IS_A_DIRECTORY"));
                                return;
                            }
                            String suffix = "";
                            int var2 = file.getName().lastIndexOf("\\.");
                            if (var2 != -1) {
                                suffix = "/" + file.getName().substring(var2 + 1);
                            }
                            boolean slim = InteractionUtils.yesOrNo(CMCL.getString("SKIN_TYPE_DEFAULT_OR_SLIM"));
                            try {
                                YggdrasilAuthentication.uploadSkin(new AuthlibInjectorApiProvider(account6.optString("url")), account6.optString("uuid"), account6.optString("accessToken"), file.getName(), suffix, FileUtils.getBytes(file), slim);
                                return;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.out.println(CMCL.getString("UNABLE_SET_SKIN"));
                            }
                            return;
                        }
                        if (loginMethod == 0) {
                            File file = new File(value);
                            if (!file.exists() || file.isDirectory()) {
                                System.out.println(CMCL.getString("FILE_NOT_FOUND_OR_IS_A_DIRECTORY"));
                                return;
                            }
                            if (InteractionUtils.yesOrNo(CMCL.getString("SKIN_TYPE_DEFAULT_OR_SLIM"))) {
                                account6.put("slim", true);
                            } else {
                                account6.remove("slim");
                            }
                            account6.remove("providedSkin");
                            account6.put("offlineSkin", file.getAbsolutePath());
                            Utils.saveConfig(config);
                            return;
                        }
                        System.out.println(CMCL.getString("UPLOAD_SKIN_ONLY_OAS_OR_OFFLINE"));
                        return;
                    }
                    boolean steve = "steve".equals(value);
                    if (loginMethod == 0) {
                        account6.remove("offlineSkin");
                        account6.remove("slim");
                        account6.put("providedSkin", steve ? "steve" : "alex");
                        Utils.saveConfig(config);
                        return;
                    }
                    if (loginMethod == 1) {
                        byte[] skin;
                        String name;
                        boolean slim = false;
                        try {
                            InputStream is;
                            if (steve) {
                                name = "steve.png";
                                is = AccountFunction.class.getResourceAsStream("/skin/steve.png");
                                if (is == null) {
                                    System.out.println(CMCL.getString("SKIN_STEVE_NOT_FOUND"));
                                    return;
                                }
                                skin = FileUtils.inputStream2ByteArray(is);
                            } else {
                                name = "alex.png";
                                is = AccountFunction.class.getResourceAsStream("/skin/alex.png");
                                if (is == null) {
                                    System.out.println(CMCL.getString("SKIN_ALEX_NOT_FOUND"));
                                    return;
                                }
                                skin = FileUtils.inputStream2ByteArray(is);
                                slim = true;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(CMCL.getString(steve ? "SKIN_STEVE_UNABLE_READ" : "SKIN_ALEX_UNABLE_READ"));
                            return;
                        }
                        try {
                            YggdrasilAuthentication.uploadSkin(new AuthlibInjectorApiProvider(account6.optString("url")), account6.optString("uuid"), account6.optString("accessToken"), name, "png", skin, slim);
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(CMCL.getString("UNABLE_SET_SKIN"));
                        }
                        return;
                    }
                    System.out.println(CMCL.getString("UPLOAD_SKIN_ONLY_OAS_OR_OFFLINE"));
                    return;
                }
                case "s": 
                case "select": {
                    int order;
                    try {
                        order = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Utils.printfln(CMCL.getString("CONSOLE_UNSUPPORTED_VALUE"), value);
                        return;
                    }
                    if (order < 0) {
                        Utils.printfln(CMCL.getString("ACCOUNT_NOT_EXISTS"), order);
                        return;
                    }
                    JSONObject account7 = accounts.optJSONObject(order);
                    if (account7 == null) {
                        Utils.printfln(CMCL.getString("ACCOUNT_NOT_EXISTS"), order);
                        return;
                    }
                    if (!AccountUtils.isValidAccount(account7)) {
                        Utils.printfln(CMCL.getString("ACCOUNT_INVALID"), order);
                        return;
                    }
                    account7.put("selected", true);
                    for (int i = 0; i < accounts.length(); ++i) {
                        JSONObject acc;
                        if (i == order || (acc = accounts.optJSONObject(i)) == null) continue;
                        acc.put("selected", false);
                    }
                    config.put("accounts", accounts);
                    Utils.saveConfig(config);
                    return;
                }
                case "d": 
                case "delete": {
                    try {
                        int order = Integer.parseInt(value);
                        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                        int accountCount = 0;
                        for (int i = 0; i < accounts.length(); ++i) {
                            Object object = accounts.get(i);
                            if (!AccountUtils.isValidAccount(object)) continue;
                            map.put(accountCount++, i);
                        }
                        Integer integer = (Integer)map.get(order);
                        if (integer == null) return;
                        accounts.remove(integer);
                        Utils.saveConfig(config);
                        return;
                    }
                    catch (NumberFormatException e) {
                        Utils.printfln(CMCL.getString("CONSOLE_UNSUPPORTED_VALUE"), value);
                        return;
                    }
                }
                case "download-skin": {
                    JSONObject account8;
                    try {
                        account8 = AccountUtils.getSelectedAccount(config, true);
                    }
                    catch (NotSelectedException e) {
                        return;
                    }
                    int loginMethod = account8.optInt("loginMethod");
                    File file = new File(value);
                    if (loginMethod == 1 && !account8.optString("url").isEmpty() || loginMethod == 2 && !account8.optString("uuid").isEmpty() || loginMethod == 3 && !account8.optString("uuid").isEmpty() && !account8.optString("serverId").isEmpty()) {
                        if (!file.exists()) {
                            SkinDownloader.start(file, account8);
                            return;
                        }
                        Utils.printfln(Utils.getString("CONSOLE_FILE_EXISTS"), file.getAbsolutePath());
                        return;
                    }
                    System.out.println(CMCL.getString("CONSOLE_ACCOUNT_UN_OPERABLE_MISSING_INFO"));
                    return;
                }
                case "login": {
                    boolean select;
                    boolean bl = select = arguments.contains("s") || arguments.contains("select");
                    if ("offline".equalsIgnoreCase(value)) {
                        Argument nameArgument = Optional.ofNullable(arguments.optArgument("name")).orElseGet(() -> arguments.optArgument("n"));
                        if (!(nameArgument instanceof ValueArgument)) {
                            System.out.println(Utils.getString("ACCOUNT_LOGIN_NEED_NAME"));
                            return;
                        }
                        String name = ((ValueArgument)nameArgument).value;
                        int indexOf = -1;
                        for (int i = 0; i < accounts.length(); ++i) {
                            JSONObject account9 = accounts.optJSONObject(i);
                            if (account9 == null) continue;
                            if (Objects.equals(account9.optString("playerName"), name) && account9.optInt("loginMethod") == 0) {
                                indexOf = i;
                                continue;
                            }
                            if (!select) continue;
                            account9.put("selected", false);
                        }
                        JSONObject account10 = new JSONObject();
                        account10.put("playerName", name);
                        account10.put("selected", select);
                        account10.put("loginMethod", 0);
                        if (indexOf >= 0) {
                            if (!InteractionUtils.yesOrNo(String.format(CMCL.getString("CONSOLE_REPLACE_LOGGED_ACCOUNT"), indexOf))) return;
                            accounts.put(indexOf, account10);
                            config.put("accounts", accounts);
                            Utils.saveConfig(config);
                            return;
                        }
                        accounts.put(account10);
                        Utils.saveConfig(config);
                        return;
                    }
                    if ("microsoft".equalsIgnoreCase(value)) {
                        JSONObject account11 = MicrosoftAuthentication.loginMicrosoftAccount();
                        if (account11 == null) return;
                        AccountFunction.addOrReplace(account11, config, select, jsonObject1 -> jsonObject1.optInt("loginMethod") == 2 && Objects.equals(account11.optString("id"), jsonObject1.optString("id")) && AccountUtils.isValidAccount(jsonObject1));
                        return;
                    }
                    if ("authlib".equalsIgnoreCase(value)) {
                        JSONObject account12;
                        Argument addressArgument = arguments.optArgument("address");
                        if (!(addressArgument instanceof ValueArgument)) {
                            System.out.println(Utils.getString("ACCOUNT_LOGIN_NEED_ADDRESS"));
                            return;
                        }
                        String address = ((ValueArgument)addressArgument).value;
                        try {
                            account12 = AuthlibInjectorAuthentication.authlibInjectorLogin(address, null, select);
                        }
                        catch (Exception e) {
                            Utils.printfln(CMCL.getString("FAILED_TO_LOGIN_OTHER_AUTHENTICATION_ACCOUNT"), e);
                            return;
                        }
                        if (account12 == null) return;
                        AccountFunction.addOrReplace(account12, config, select, jsonObject -> jsonObject.optInt("loginMethod") == 1 && NetworkUtils.urlEqualsIgnoreSlash(account12.optString("url"), jsonObject.optString("url")) && Objects.equals(account12.optString("uuid"), jsonObject.optString("uuid")) && AccountUtils.isValidAccount(jsonObject));
                        return;
                    }
                    if ("nide8auth".equalsIgnoreCase(value)) {
                        JSONObject account13;
                        Argument serverIdArgument = arguments.optArgument("serverId");
                        if (!(serverIdArgument instanceof ValueArgument)) {
                            System.out.println(Utils.getString("ACCOUNT_LOGIN_NEED_SERVER_ID"));
                            return;
                        }
                        String serverId = ((ValueArgument)serverIdArgument).value;
                        try {
                            account13 = Nide8AuthAuthentication.nide8authLogin(serverId, null, select);
                        }
                        catch (Exception e) {
                            Utils.printfln(CMCL.getString("FAILED_TO_LOGIN_NIDE8AUTH_ACCOUNT"), e);
                            return;
                        }
                        if (account13 == null) return;
                        AccountFunction.addOrReplace(account13, config, select, jsonObject -> jsonObject.optInt("loginMethod") == 3 && account13.optString("serverId").equalsIgnoreCase(jsonObject.optString("serverId")) && Objects.equals(account13.optString("uuid"), jsonObject.optString("uuid")) && AccountUtils.isValidAccount(jsonObject));
                        return;
                    }
                    System.out.println(CMCL.getString("ACCOUNT_LOGIN_UNKNOWN_LOGIN_METHOD", value));
                    return;
                }
                default: {
                    System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", arguments.optArgument((int)1).originString));
                }
            }
            return;
        }
        System.out.println(CMCL.getString("CONSOLE_ONLY_HELP", arguments.optArgument((int)1).originString));
    }

    private static void addOrReplace(JSONObject account, JSONObject config, boolean select, JSONObjectFilter filter) {
        JSONArray accounts = config.optJSONArray("accounts");
        account.put("selected", select);
        int indexOf = -1;
        for (int i = 0; i < accounts.length(); ++i) {
            JSONObject jsonObject1 = accounts.optJSONObject(i);
            if (jsonObject1 == null) continue;
            if (filter.accept(jsonObject1)) {
                indexOf = i;
                continue;
            }
            if (!select) continue;
            jsonObject1.put("selected", false);
        }
        if (indexOf < 0) {
            accounts.put(account);
            config.put("accounts", accounts);
            Utils.saveConfig(config);
            System.out.println(CMCL.getString("MESSAGE_LOGINED_TITLE"));
        } else if (InteractionUtils.yesOrNo(String.format(CMCL.getString("CONSOLE_REPLACE_LOGGED_ACCOUNT"), indexOf))) {
            accounts.put(indexOf, account);
            config.put("accounts", accounts);
            Utils.saveConfig(config);
            System.out.println(CMCL.getString("MESSAGE_LOGINED_TITLE"));
        }
    }

    public static List<JSONObject> getAllAccounts(@NotNull JSONArray accounts) {
        if (accounts == null) {
            AccountFunction.$$$reportNull$$$0(0);
        }
        return Utils.iteratorToStream(accounts.iterator()).filter(AccountUtils::isValidAccount).map(x -> (JSONObject)x).collect(Collectors.toList());
    }

    public static String[] accountInfoToTableItem(JSONObject account, int order, boolean showSelected) {
        String[] stringArray;
        String otherInformation;
        String accountType;
        int loginMethod = account.optInt("loginMethod");
        if (loginMethod == 1) {
            accountType = CMCL.getString("ACCOUNT_TYPE_OAS");
            otherInformation = account.optString("serverName") + " " + account.optString("url");
        } else if (loginMethod == 2) {
            accountType = CMCL.getString("ACCOUNT_TYPE_MICROSOFT");
            otherInformation = "";
        } else if (loginMethod == 3) {
            accountType = CMCL.getString("ACCOUNT_TYPE_NIDE8AUTH");
            otherInformation = account.optString("serverName") + " " + account.optString("serverId");
        } else {
            accountType = CMCL.getString("ACCOUNT_TYPE_OFFLINE");
            otherInformation = "";
        }
        if (showSelected) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = account.optBoolean("selected") ? CMCL.getString("YES_SHORT") : "";
            stringArray2[1] = String.valueOf(order);
            stringArray2[2] = account.optString("playerName", "XPlayer");
            stringArray2[3] = accountType;
            stringArray = stringArray2;
            stringArray2[4] = otherInformation;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = String.valueOf(order);
            stringArray3[1] = account.optString("playerName", "XPlayer");
            stringArray3[2] = accountType;
            stringArray = stringArray3;
            stringArray3[3] = otherInformation;
        }
        return stringArray;
    }

    @Override
    public String getUsageName() {
        return "account";
    }

    public static String getAccountType(JSONObject account) {
        int loginMethod = account.optInt("loginMethod");
        if (loginMethod == 1) {
            return CMCL.getString("ACCOUNT_TYPE_OAS");
        }
        if (loginMethod == 2) {
            return CMCL.getString("ACCOUNT_TYPE_MICROSOFT");
        }
        if (loginMethod == 3) {
            return CMCL.getString("ACCOUNT_TYPE_NIDE8AUTH");
        }
        return CMCL.getString("ACCOUNT_TYPE_OFFLINE");
    }

    public static String getAccountTypeWithInformation(JSONObject account) {
        int loginMethod = account.optInt("loginMethod");
        if (loginMethod == 1) {
            return CMCL.getString("ACCOUNT_TYPE_OAS_WITH_DETAIL", account.optString("serverName"), account.optString("url"));
        }
        if (loginMethod == 2) {
            return CMCL.getString("ACCOUNT_TYPE_MICROSOFT");
        }
        if (loginMethod == 3) {
            return CMCL.getString("ACCOUNT_TYPE_NIDE8AUTH_WITH_DETAIL", account.optString("serverName"), account.optString("serverId"));
        }
        return CMCL.getString("ACCOUNT_TYPE_OFFLINE");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accounts", "com/mrshiehx/cmcl/functions/AccountFunction", "getAllAccounts"));
    }
}

