/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.ArgumentRequirement;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.TextArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import java.util.Arrays;
import org.json.JSONObject;

public class ConfigFunction
implements Function {
    @Override
    public void execute(Arguments arguments) {
        block34: {
            Argument firstArg;
            JSONObject config;
            block35: {
                String key;
                block33: {
                    if (!Function.checkArgs(arguments, 2, 1, ArgumentRequirement.ofSingle("a"), ArgumentRequirement.ofSingle("all"), ArgumentRequirement.ofSingle("getRaw"), ArgumentRequirement.ofSingle("c"), ArgumentRequirement.ofSingle("clear"), ArgumentRequirement.ofSingle("v"), ArgumentRequirement.ofSingle("view"), ArgumentRequirement.ofValue("getRaw"), ArgumentRequirement.ofValue("d"), ArgumentRequirement.ofValue("delete"))) {
                        return;
                    }
                    config = Utils.getConfig();
                    firstArg = arguments.optArgument(1);
                    if (!(firstArg instanceof TextArgument)) break block33;
                    String key2 = firstArg.key;
                    Argument secondArg = arguments.optArgument(2);
                    if (secondArg == null) {
                        Object obj = config.opt(key2);
                        if (obj != null) {
                            System.out.println(key2 + '=' + obj + " (" + Utils.getTypeText(obj.getClass().getSimpleName()) + ")");
                        } else {
                            System.out.println("null");
                        }
                        return;
                    }
                    String value = secondArg.originArray[0];
                    config.put(key2, value);
                    Utils.saveConfig(config);
                    if (CMCL.isImmersiveMode) {
                        CMCL.initConfig();
                    }
                    break block34;
                }
                if (!(firstArg instanceof SingleArgument)) break block35;
                switch (key = firstArg.key) {
                    case "a": 
                    case "all": {
                        PrintingUtils.printTable(new String[]{CMCL.getString("TABLE_CONFIG_ALL_NAME"), CMCL.getString("TABLE_CONFIG_ALL_TYPE"), CMCL.getString("TABLE_CONFIG_ALL_VALUE")}, new int[]{25, 11, 30}, false, (String[][])config.toMap().entrySet().stream().map(stringObjectEntry -> {
                            String value;
                            switch ((String)stringObjectEntry.getKey()) {
                                case "accounts": {
                                    value = CMCL.getString("TABLE_CONFIG_ALL_VIEW_SEPARATELY", stringObjectEntry.getKey());
                                    break;
                                }
                                default: {
                                    value = String.valueOf(stringObjectEntry.getValue());
                                }
                            }
                            return new String[]{(String)stringObjectEntry.getKey(), Utils.getTypeText(stringObjectEntry.getValue().getClass().getSimpleName()), value};
                        }).toArray(x$0 -> new String[x$0][]));
                        break;
                    }
                    case "c": 
                    case "clear": {
                        Utils.saveConfig(new JSONObject());
                        if (CMCL.isImmersiveMode) {
                            CMCL.initConfig();
                            break;
                        }
                        break block34;
                    }
                    case "v": 
                    case "view": {
                        PrintingUtils.printTable(new String[]{CMCL.getString("TABLE_SETTABLE_CONFIG_NAME"), CMCL.getString("TABLE_SETTABLE_CONFIG_TYPE"), CMCL.getString("TABLE_SETTABLE_CONFIG_MEANING")}, new int[]{25, 11, 30}, false, (String[][])Arrays.stream(CMCL.getString("MESSAGE_CONFIGURATIONS_TABLE_CONTENT").split("\n")).map(item -> item.split("\\|")).toArray(x$0 -> new String[x$0][]));
                        System.out.println(CMCL.getString("MESSAGE_CONFIGURATIONS_TIP"));
                        break;
                    }
                    case "getRaw": {
                        System.out.println(config.toString(2));
                        break;
                    }
                    default: {
                        System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
                        break;
                    }
                }
                break block34;
            }
            if (firstArg instanceof ValueArgument) {
                String key = firstArg.key;
                Argument arg = arguments.optArgument(1);
                String value = ((ValueArgument)arg).value;
                switch (key) {
                    case "getRaw": {
                        int indentFactor;
                        try {
                            indentFactor = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            System.out.println(CMCL.getString("CONSOLE_UNSUPPORTED_VALUE", value));
                            break;
                        }
                        System.out.println(config.toString(indentFactor));
                        break;
                    }
                    case "d": 
                    case "delete": {
                        config.remove(value);
                        Utils.saveConfig(config);
                        if (!CMCL.isImmersiveMode) break;
                        CMCL.initConfig();
                        break;
                    }
                    default: {
                        System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
                    }
                }
            }
        }
    }

    @Override
    public String getUsageName() {
        return "config";
    }
}

