/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.TextArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import java.io.File;
import java.io.IOException;
import org.json.JSONObject;

public class GameArgsFunction
implements Function {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Arguments arguments) {
        Argument firstArg;
        JSONObject jsonObject;
        JSONObject gameArgs;
        String version = arguments.opt("v", arguments.opt("version", null));
        JSONObject versionConfigJO = null;
        File versionConfigFile = null;
        if (!Utils.isEmpty(version)) {
            if (!VersionUtils.versionExists(version)) {
                System.out.println(CMCL.getString("EXCEPTION_VERSION_NOT_FOUND", version));
                return;
            }
            versionConfigFile = new File(CMCL.versionsDir, version + "/cmclversion.json");
            if (!versionConfigFile.exists()) {
                try {
                    FileUtils.createFile(versionConfigFile, false);
                    versionConfigJO = new JSONObject();
                }
                catch (IOException e) {
                    System.out.println(CMCL.getString("EXCEPTION_CREATE_FILE_WITH_PATH", e));
                    return;
                }
            }
            try {
                versionConfigJO = new JSONObject(FileUtils.readFileContent(versionConfigFile));
            }
            catch (Exception e) {
                versionConfigJO = new JSONObject();
            }
        }
        if ((gameArgs = (jsonObject = versionConfigJO != null ? versionConfigJO : Utils.getConfig()).optJSONObject("gameArgs")) == null) {
            gameArgs = new JSONObject();
            jsonObject.put("gameArgs", gameArgs);
        }
        if ((firstArg = arguments.optArgument(1)) instanceof SingleArgument) {
            String firstKey = firstArg.key;
            if (firstKey.equals("p") || firstKey.equals("print")) {
                System.out.println(gameArgs.toString(2));
                return;
            }
            System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
            return;
        }
        if (firstArg instanceof ValueArgument) {
            String firstKey = firstArg.key;
            String value = ((ValueArgument)firstArg).value;
            switch (firstKey) {
                case "p": 
                case "print": {
                    int indentFactor;
                    try {
                        indentFactor = Utils.parseWithPrompting(value);
                    }
                    catch (Exception e) {
                        return;
                    }
                    System.out.println(gameArgs.toString(indentFactor));
                    return;
                }
                case "a": 
                case "add": {
                    String valueValue = "";
                    Argument valueArg = arguments.optArgument(2);
                    if (valueArg instanceof TextArgument) {
                        valueValue = valueArg.originString;
                    }
                    gameArgs.put(value, valueValue);
                    if (versionConfigFile != null) {
                        try {
                            FileUtils.writeFile(versionConfigFile, jsonObject.toString(), false);
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    Utils.saveConfig(jsonObject);
                    return;
                }
                case "d": 
                case "delete": {
                    gameArgs.remove(value);
                    if (versionConfigFile != null) {
                        try {
                            FileUtils.writeFile(versionConfigFile, jsonObject.toString(), false);
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    Utils.saveConfig(jsonObject);
                    return;
                }
                default: {
                    System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
                    return;
                }
            }
        }
        System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
    }

    @Override
    public String getUsageName() {
        return "gameArgs";
    }
}

