/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JVMArgsFunction
implements Function {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Arguments arguments) {
        Argument firstArg;
        JSONObject jsonObject;
        JSONArray jvmArgs;
        String version = arguments.opt("v", arguments.opt("version", null));
        JSONObject versionConfigJSONObject = null;
        File versionConfigFile = null;
        if (!Utils.isEmpty(version)) {
            if (!VersionUtils.versionExists(version)) {
                System.out.println(CMCL.getString("EXCEPTION_VERSION_NOT_FOUND", version));
                return;
            }
            versionConfigFile = new File(CMCL.versionsDir, version + "/cmclversion.json");
            if (!versionConfigFile.exists()) {
                try {
                    FileUtils.createFile(versionConfigFile, false);
                    versionConfigJSONObject = new JSONObject();
                }
                catch (IOException e) {
                    System.out.println(CMCL.getString("EXCEPTION_CREATE_FILE_WITH_PATH", e));
                    return;
                }
            }
            try {
                versionConfigJSONObject = new JSONObject(FileUtils.readFileContent(versionConfigFile));
            }
            catch (Exception e) {
                versionConfigJSONObject = new JSONObject();
            }
        }
        if ((jvmArgs = (jsonObject = versionConfigJSONObject != null ? versionConfigJSONObject : Utils.getConfig()).optJSONArray("jvmArgs")) == null) {
            jvmArgs = new JSONArray();
            jsonObject.put("jvmArgs", jvmArgs);
        }
        if ((firstArg = arguments.optArgument(1)) instanceof SingleArgument) {
            String firstKey = firstArg.key;
            if (firstKey.equals("p") || firstKey.equals("print")) {
                System.out.println(jvmArgs.toString(2));
                return;
            }
            System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
            return;
        }
        if (firstArg instanceof ValueArgument) {
            String firstKey = firstArg.key;
            String value = ((ValueArgument)firstArg).value;
            switch (firstKey) {
                case "p": 
                case "print": {
                    int indentFactor;
                    try {
                        indentFactor = Utils.parseWithPrompting(value);
                    }
                    catch (Exception e) {
                        return;
                    }
                    System.out.println(jvmArgs.toString(indentFactor));
                    return;
                }
                case "a": 
                case "add": {
                    jvmArgs.put(value);
                    if (versionConfigFile != null) {
                        try {
                            FileUtils.writeFile(versionConfigFile, jsonObject.toString(), false);
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    Utils.saveConfig(jsonObject);
                    return;
                }
                case "d": 
                case "delete": {
                    try {
                        int order = Utils.parseWithPrompting(value);
                        jvmArgs.remove(order);
                        if (versionConfigFile != null) {
                            try {
                                FileUtils.writeFile(versionConfigFile, jsonObject.toString(), false);
                                return;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                        Utils.saveConfig(jsonObject);
                        return;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                default: {
                    System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
                }
            }
            return;
        }
        System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
    }

    @Override
    public String getUsageName() {
        return "jvmArgs";
    }
}

