/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.utils.Utils;
import org.json.JSONObject;

public class SimplifyCommandFunction
implements Function {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(Arguments arguments) {
        Argument firstArg;
        JSONObject config = Utils.getConfig();
        JSONObject simplifyCommands = config.optJSONObject("simplifyCommands");
        if (simplifyCommands == null) {
            simplifyCommands = new JSONObject();
            config.put("simplifyCommands", simplifyCommands);
        }
        if ((firstArg = arguments.optArgument(1)) instanceof SingleArgument) {
            String firstKey = firstArg.key;
            if (!firstKey.equals("p") && !firstKey.equals("print")) {
                System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
                return;
            }
            System.out.println(simplifyCommands.toString(2));
            return;
        }
        if (!(firstArg instanceof ValueArgument)) {
            System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
            return;
        }
        String firstKey = firstArg.key;
        String simplifiedCommand = ((ValueArgument)firstArg).value;
        switch (firstKey) {
            case "s": 
            case "set": {
                Argument originCommandArg = arguments.optArgument(2);
                if (originCommandArg == null) {
                    System.out.println(CMCL.getString("CONSOLE_IMMERSIVE_MISSING_PARAMETER"));
                    return;
                }
                String originCommand = originCommandArg.originString;
                simplifyCommands.put(simplifiedCommand, originCommand);
                Utils.saveConfig(config);
                return;
            }
            case "d": 
            case "delete": {
                simplifyCommands.remove(simplifiedCommand);
                Utils.saveConfig(config);
                return;
            }
        }
        System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", firstArg.originString));
    }

    @Override
    public String getUsageName() {
        return "simplify";
    }
}

