/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Library;
import com.mrshiehx.cmcl.bean.ThreeReturns;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.TextArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.exceptions.CommandTooLongException;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.functions.mod.ModFunction;
import com.mrshiehx.cmcl.functions.root.LaunchCommands;
import com.mrshiehx.cmcl.modSources.modrinth.ModrinthModManager;
import com.mrshiehx.cmcl.modules.MinecraftLauncher;
import com.mrshiehx.cmcl.modules.extra.ExtraInstaller;
import com.mrshiehx.cmcl.modules.extra.fabric.FabricInstaller;
import com.mrshiehx.cmcl.modules.extra.forge.ForgeInstaller;
import com.mrshiehx.cmcl.modules.extra.liteloader.LiteloaderInstaller;
import com.mrshiehx.cmcl.modules.extra.optifine.OptiFineInstaller;
import com.mrshiehx.cmcl.modules.extra.quilt.QuiltInstaller;
import com.mrshiehx.cmcl.modules.version.PrintVersionInfo;
import com.mrshiehx.cmcl.modules.version.VersionCompleter;
import com.mrshiehx.cmcl.modules.version.downloaders.AssetsDownloader;
import com.mrshiehx.cmcl.modules.version.downloaders.LibrariesDownloader;
import com.mrshiehx.cmcl.modules.version.downloaders.NativesDownloader;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionFunction
implements Function {
    @Override
    public void execute(Arguments arguments) {
        Argument first = arguments.optArgument(1);
        Argument second = arguments.optArgument(2);
        if (first instanceof TextArgument) {
            if (second instanceof ValueArgument || second instanceof SingleArgument) {
                VersionFunction.operate(arguments, second, arguments.optArgument(3), first.key);
            } else {
                System.out.println(CMCL.getString("CONSOLE_ONLY_HELP"));
            }
        } else {
            String selectedVersion = Utils.getConfig().optString("selectedVersion");
            if (second == null) {
                if (CMCL.isEmpty(selectedVersion)) {
                    System.out.println(CMCL.getString("MESSAGE_TO_SELECT_VERSION"));
                    return;
                }
                VersionFunction.operate(arguments, first, null, selectedVersion);
            } else if (VersionUtils.versionExists(first.originArray[0])) {
                VersionFunction.operate(arguments, second, arguments.optArgument(3), first.originArray[0]);
            } else {
                if (CMCL.isEmpty(selectedVersion)) {
                    System.out.println(CMCL.getString("MESSAGE_TO_SELECT_VERSION"));
                    return;
                }
                VersionFunction.operate(arguments, first, second, selectedVersion);
            }
        }
    }

    private static void operate(Arguments arguments, Argument operateArg, Argument operateArgNext, String versionName) {
        File versionDir = new File(CMCL.versionsDir, versionName);
        File jsonFile = new File(versionDir, versionName + ".json");
        File jarFile = new File(versionDir, versionName + ".jar");
        if (!jsonFile.exists()) {
            System.out.println(CMCL.getString("EXCEPTION_VERSION_NOT_FOUND", versionName));
            return;
        }
        if (operateArg instanceof SingleArgument) {
            String key;
            switch (key = operateArg.key) {
                case "info": {
                    PrintVersionInfo.execute(jsonFile, jarFile, versionDir, versionName);
                    break;
                }
                case "d": 
                case "delete": {
                    FileUtils.deleteDirectory(versionDir);
                    break;
                }
                case "complete": {
                    VersionCompleter.execute(jsonFile, jarFile, versionName);
                    break;
                }
                case "fabric": {
                    VersionFunction.installFabric(jsonFile, jarFile, null, arguments.contains("api"), arguments.opt("api"));
                    break;
                }
                case "forge": {
                    VersionFunction.installExtra(jsonFile, jarFile, new ForgeInstaller(), null);
                    break;
                }
                case "liteloader": {
                    VersionFunction.installExtra(jsonFile, jarFile, new LiteloaderInstaller(), null);
                    break;
                }
                case "optifine": {
                    VersionFunction.installExtra(jsonFile, jarFile, new OptiFineInstaller(), null);
                    break;
                }
                case "quilt": {
                    VersionFunction.installExtra(jsonFile, jarFile, new QuiltInstaller(), null);
                    break;
                }
                case "isolate": {
                    JSONObject versionCfg;
                    File cfgFile = new File(versionDir, "cmclversion.json");
                    if (cfgFile.exists()) {
                        try {
                            versionCfg = new JSONObject(FileUtils.readFileContent(cfgFile));
                        }
                        catch (Throwable ignored) {
                            versionCfg = new JSONObject();
                        }
                    } else {
                        versionCfg = new JSONObject();
                    }
                    versionCfg.put("isolate", true);
                    try {
                        FileUtils.writeFile(cfgFile, versionCfg.toString(), false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "unset-isolate": {
                    JSONObject versionCfg;
                    File cfgFile = new File(versionDir, "cmclversion.json");
                    if (cfgFile.exists()) {
                        try {
                            versionCfg = new JSONObject(FileUtils.readFileContent(cfgFile));
                        }
                        catch (Throwable ignored) {
                            versionCfg = new JSONObject();
                        }
                    } else {
                        versionCfg = new JSONObject();
                    }
                    versionCfg.put("isolate", false);
                    try {
                        FileUtils.writeFile(cfgFile, versionCfg.toString(), false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "p": 
                case "print-command": {
                    LaunchCommands.print(versionName);
                    break;
                }
                default: {
                    System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", operateArg.originString));
                }
            }
        } else if (operateArg instanceof ValueArgument) {
            String key = operateArg.key;
            String value = ((ValueArgument)operateArg).value;
            switch (key) {
                case "rename": {
                    if (VersionUtils.versionExists(value)) {
                        System.out.println(CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS", value));
                        return;
                    }
                    try {
                        XJSONObject head = new XJSONObject(FileUtils.readFileContent(jsonFile));
                        head.put("id", value);
                        FileUtils.writeFile(jsonFile, head.toString(2), false);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("MESSAGE_FAILED_RENAME_VERSION", e));
                        return;
                    }
                    File newFile = new File(CMCL.versionsDir, value);
                    File file2 = new File(newFile, versionName + ".jar");
                    File file3 = new File(newFile, versionName + ".json");
                    versionDir.renameTo(newFile);
                    file2.renameTo(new File(newFile, value + ".jar"));
                    file3.renameTo(new File(newFile, value + ".json"));
                    break;
                }
                case "complete": {
                    if ("assets".equalsIgnoreCase(value)) {
                        try {
                            AssetsDownloader.start(new JSONObject(FileUtils.readFileContent(jsonFile)), arguments.optInt("t", arguments.optInt("thread", 64)), () -> System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADED_ASSETS")));
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                        break;
                    }
                    if ("libraries".equalsIgnoreCase(value)) {
                        try {
                            JSONArray libraries = new JSONObject(FileUtils.readFileContent(jsonFile)).optJSONArray("libraries");
                            ThreeReturns<List<Library>, List<Library>, Boolean> pair = MinecraftLauncher.getLibraries(libraries);
                            List notFound = (List)pair.second;
                            if (notFound.size() == 0) {
                                System.out.println(CMCL.getString("VERSION_COMPLETE_LIBRARIES_NO_NEED_TO"));
                                return;
                            }
                            VersionFunction.executeNotFound(notFound);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    if ("natives".equalsIgnoreCase(value)) {
                        try {
                            JSONArray libraries = new JSONObject(FileUtils.readFileContent(jsonFile)).optJSONArray("libraries");
                            System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADING_LIBRARIES"));
                            NativesDownloader.download(versionDir, JSONUtils.jsonArrayToJSONObjectList(libraries));
                            System.out.println(CMCL.getString("MESSAGE_REDOWNLOADED_NATIVES"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    System.out.println(CMCL.getString("VERSION_UNKNOWN_COMPLETING", value));
                    break;
                }
                case "config": {
                    JSONObject versionCfg;
                    File cfgFile = new File(versionDir, "cmclversion.json");
                    if (cfgFile.exists()) {
                        try {
                            versionCfg = new JSONObject(FileUtils.readFileContent(cfgFile));
                        }
                        catch (Throwable ignored) {
                            versionCfg = new JSONObject();
                        }
                    } else {
                        versionCfg = new JSONObject();
                    }
                    if (operateArgNext != null) {
                        versionCfg.put(value, operateArgNext.originArray[0]);
                    } else {
                        versionCfg.remove(value);
                    }
                    try {
                        FileUtils.writeFile(cfgFile, versionCfg.toString(), false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "fabric": {
                    VersionFunction.installFabric(jsonFile, jarFile, value, arguments.contains("api"), arguments.opt("api"));
                    break;
                }
                case "forge": {
                    VersionFunction.installExtra(jsonFile, jarFile, new ForgeInstaller(), value);
                    break;
                }
                case "liteloader": {
                    VersionFunction.installExtra(jsonFile, jarFile, new LiteloaderInstaller(), value);
                    break;
                }
                case "optifine": {
                    VersionFunction.installExtra(jsonFile, jarFile, new OptiFineInstaller(), value);
                    break;
                }
                case "quilt": {
                    VersionFunction.installExtra(jsonFile, jarFile, new QuiltInstaller(), value);
                    break;
                }
                case "export-script": {
                    File scriptFilePs = new File(value);
                    if (scriptFilePs.exists()) {
                        System.out.println(CMCL.getString("CONSOLE_FILE_EXISTS", value));
                        return;
                    }
                    try {
                        FileUtils.writeFile(scriptFilePs, SystemUtils.isWindows() ? LaunchCommands.getBatContent(versionName) : LaunchCommands.getShContent(versionName), false);
                    }
                    catch (CommandTooLongException e) {
                        System.out.println(CMCL.getString("MESSAGE_EXPORT_COMMAND_EXCEEDS_LENGTH_LIMIT"));
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("EXCEPTION_WRITE_FILE") + ": " + e);
                    }
                    break;
                }
                case "export-script-ps": {
                    File scriptFilePs = new File(value);
                    if (scriptFilePs.exists()) {
                        System.out.println(CMCL.getString("CONSOLE_FILE_EXISTS", value));
                        return;
                    }
                    try {
                        FileUtils.writeFile(scriptFilePs, LaunchCommands.getPowerShellContent(versionName), false);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("EXCEPTION_WRITE_FILE") + ": " + e);
                    }
                    break;
                }
                default: {
                    System.out.println(CMCL.getString("CONSOLE_UNKNOWN_COMMAND_OR_MEANING", operateArg.originString));
                }
            }
        } else {
            System.out.println(CMCL.getString("CONSOLE_ONLY_HELP"));
        }
    }

    private static boolean installFabric(File jsonFile, File jarFile, @Nullable String fabricVersion, boolean installApi, @Nullable String fabricApiVersion) {
        boolean success = new FabricInstaller().install(jsonFile, jarFile, fabricVersion);
        if (success && installApi) {
            String ver = null;
            try {
                ver = VersionUtils.getGameVersion((JSONObject)new JSONObject((String)FileUtils.readFileContent((File)jsonFile)), (File)jarFile).id.replace(" Pre-Release ", "-pre");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String url = new ModrinthModManager().getDownloadLink("P7dR8mSH", "Fabric API", ver, fabricApiVersion, false, ModFunction.MOD_MR_DEPENDENCY_INSTALLER);
            if (!CMCL.isEmpty(url)) {
                ModFunction.downloadMod(url);
            }
        }
        return success;
    }

    private static boolean installExtra(File jsonFile, File jarFile, ExtraInstaller extraInstaller, @Nullable String extraVersion) {
        return extraInstaller.install(jsonFile, jarFile, extraVersion);
    }

    public static void executeNotFound(List<Library> notFound) {
        for (Library library : notFound) {
            System.out.print("    ");
            System.out.println(library.libraryJSONObject.optString("name"));
        }
        if (InteractionUtils.yesOrNo(CMCL.getString("CONSOLE_LACK_LIBRARIES_WHETHER_DOWNLOAD"))) {
            LibrariesDownloader.downloadLibraries(notFound);
        }
    }

    @Override
    public String getUsageName() {
        return "version";
    }
}

