/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.mod;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.enums.CurseForgeSection;
import com.mrshiehx.cmcl.modSources.curseforge.CurseForgeManager;
import org.json.JSONObject;

public class CurseForgeSearcher {
    public static JSONObject search(CurseForgeManager cf, String modNameInput, String modIdInput, int limit) {
        JSONObject mod;
        if (!CMCL.isEmpty(modNameInput)) {
            mod = cf.search(modNameInput, limit < 0 ? 50 : limit);
        } else {
            String alc = cf.getSection().nameAllLowerCase;
            try {
                mod = cf.getByID(modIdInput);
            }
            catch (CurseForgeManager.NotMinecraftAddon e) {
                System.out.println(CMCL.getString("CF_GET_BY_ID_NOT_OF_MC", e.gameId).replace("${NAME}", alc));
                return null;
            }
            catch (CurseForgeManager.IncorrectCategoryAddon e) {
                CurseForgeSection target = CurseForgeSection.valueOf(e.gameCategoryId);
                if (target == null) {
                    System.out.println(CMCL.getString("CF_GET_BY_ID_INCORRECT_CATEGORY", e.gameCategoryId).replace("${NAME}", alc));
                } else {
                    System.out.println(CMCL.getString("CF_GET_BY_ID_INCORRECT_CATEGORY_DETAIL").replace("${NAME}", alc).replace("${TARGET}", target.nameAllLowerCase));
                }
                return null;
            }
            catch (Exception e) {
                System.out.println(CMCL.getString("CF_GET_BY_ID_FAILED", e).replace("${NAME}", alc));
                return null;
            }
        }
        return mod;
    }
}

