/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.mod;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.bean.arguments.ArgumentRequirement;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.functions.mod.CurseForgeSearcher;
import com.mrshiehx.cmcl.functions.mod.ModrinthSearcher;
import com.mrshiehx.cmcl.modSources.Manager;
import com.mrshiehx.cmcl.modSources.curseforge.CurseForgeModManager;
import com.mrshiehx.cmcl.modSources.modrinth.ModrinthModManager;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import org.json.JSONObject;

public class ModFunction
implements Function {
    public static final Manager.DependencyInstaller MOD_CF_DEPENDENCY_INSTALLER = new Manager.DependencyInstaller(){

        @Override
        public void install(String mcVersion, String name, String id) {
            ModFunction.downloadMod(new CurseForgeModManager().getDownloadLink(id, name, mcVersion, null, false, MOD_CF_DEPENDENCY_INSTALLER));
        }
    };
    public static final Manager.DependencyInstaller MOD_MR_DEPENDENCY_INSTALLER = new Manager.DependencyInstaller(){

        @Override
        public void install(String mcVersion, String name, String id) {
            ModFunction.downloadMod(new ModrinthModManager().getDownloadLink(id, name, mcVersion, null, false, MOD_MR_DEPENDENCY_INSTALLER));
        }
    };

    @Override
    public void execute(Arguments arguments) {
        boolean source;
        if (!Function.checkArgs(arguments, 2, 1, ArgumentRequirement.ofSingle("install"), ArgumentRequirement.ofSingle("info"), ArgumentRequirement.ofValue("source"), ArgumentRequirement.ofValue("n"), ArgumentRequirement.ofValue("name"), ArgumentRequirement.ofValue("id"), ArgumentRequirement.ofValue("limit"), ArgumentRequirement.ofValue("url"), ArgumentRequirement.ofValue("game-version"), ArgumentRequirement.ofValue("v"), ArgumentRequirement.ofValue("version"))) {
            return;
        }
        int count = 0;
        if (arguments.contains("install")) {
            ++count;
        }
        if (arguments.contains("info")) {
            ++count;
        }
        if (arguments.contains("url")) {
            ++count;
        }
        if (count == 0) {
            System.out.println(Utils.getString("MOD_CONTAINS_NOTHING"));
            return;
        }
        if (count > 1) {
            System.out.println(Utils.getString("MOD_CONTAINS_TWO_OR_MORE"));
            return;
        }
        int todo = -1;
        if (arguments.contains("install")) {
            todo = 0;
        } else if (arguments.contains("info")) {
            todo = 1;
        } else if (arguments.contains("url")) {
            todo = 3;
        }
        if (todo == 3) {
            ModFunction.downloadMod(arguments.opt("url"));
            return;
        }
        String sourceStr = arguments.opt("source");
        if (CMCL.isEmpty(sourceStr)) {
            JSONObject config = CMCL.getConfig();
            sourceStr = ModFunction.getModDownloadSource(config);
        }
        switch (Objects.requireNonNull(sourceStr).toLowerCase()) {
            case "cf": 
            case "curseforge": {
                source = false;
                break;
            }
            case "mr": 
            case "modrinth": {
                source = true;
                break;
            }
            default: {
                System.out.println(Utils.getString("MOD_UNKNOWN_SOURCE", sourceStr));
                return;
            }
        }
        String modNameInput = arguments.opt("n", arguments.opt("name"));
        String modIdInput = arguments.opt("id");
        if (!CMCL.isEmpty(modNameInput) && !CMCL.isEmpty(modIdInput)) {
            System.out.println(Utils.getString("MOD_CONTAINS_BOTH_NAME_AND_ID"));
            return;
        }
        if (CMCL.isEmpty(modNameInput) && CMCL.isEmpty(modIdInput)) {
            System.out.println(Utils.getString("MOD_CONTAINS_BOTH_NOT_NAME_AND_ID"));
            return;
        }
        if (!CMCL.isEmpty(modIdInput) && arguments.contains("limit")) {
            System.out.println(Utils.getString("MOD_ID_LIMIT_COEXIST"));
            return;
        }
        int limit = arguments.optInt("limit", 50);
        if (limit > 50 && !source) {
            System.out.println(Utils.getString("MOD_SEARCH_LIMIT_GREATER_THAN_FIFTY"));
            return;
        }
        if (!source) {
            CurseForgeModManager cf = new CurseForgeModManager();
            JSONObject mod = CurseForgeSearcher.search(cf, modNameInput, modIdInput, limit);
            if (mod == null) {
                return;
            }
            String modName = mod.optString("name");
            if (todo == 0) {
                int modId = mod.optInt("id");
                String modDownloadLink = cf.getDownloadLink(String.valueOf(modId), modName, arguments.opt("game-version"), arguments.opt("v", arguments.opt("version")), false, MOD_CF_DEPENDENCY_INSTALLER);
                if (CMCL.isEmpty(modDownloadLink)) {
                    return;
                }
                ModFunction.downloadMod(modDownloadLink);
            } else if (todo == 1) {
                cf.printInformation(mod, modName);
            }
        } else {
            ModrinthModManager mr = new ModrinthModManager();
            ModrinthSearcher.Result result = ModrinthSearcher.search(mr, modNameInput, modIdInput, limit);
            if (result == null) {
                return;
            }
            JSONObject mod = result.mod;
            JSONObject modByID = result.modByID;
            String modName = result.modName;
            String modID = result.modID;
            if (todo == 0) {
                String modDownloadLink = mr.getDownloadLink(modID, modName, arguments.opt("game-version"), arguments.opt("v", arguments.opt("version")), false, MOD_MR_DEPENDENCY_INSTALLER);
                if (CMCL.isEmpty(modDownloadLink)) {
                    return;
                }
                ModFunction.downloadMod(modDownloadLink);
            } else if (todo == 1) {
                mr.printInformation(mod, modByID, null, null);
            }
        }
    }

    public static File askStorage(File last, String $NAME) {
        System.out.println(Utils.getString("CF_STORAGE_FILE_EXISTS_OPERATIONS"));
        int sel = InteractionUtils.inputInt(Utils.getString("CF_STORAGE_FILE_EXISTS_SELECT_OPERATION", last.getAbsolutePath()), 0, 2);
        switch (sel) {
            case 0: {
                return last;
            }
            case 1: {
                return ModFunction.askStorageForNewPath(last, $NAME);
            }
        }
        return null;
    }

    private static File askStorageForNewPath(File last, String $NAME) {
        String path;
        System.out.print(Utils.getString("CF_STORAGE_FILE_EXISTS").replace("${NAME}", $NAME));
        try {
            path = new Scanner(System.in).nextLine();
        }
        catch (NoSuchElementException e) {
            return null;
        }
        if (CMCL.isEmpty(path)) {
            return ModFunction.askStorageForNewPath(last, $NAME);
        }
        File file = new File(path, last.getName());
        if (!file.exists()) {
            return file;
        }
        return ModFunction.askStorage(file, $NAME);
    }

    @Override
    public String getUsageName() {
        return "mod";
    }

    public static void downloadMod(String modDownloadLink) {
        File modFile;
        String fileName;
        if (CMCL.isEmpty(modDownloadLink)) {
            return;
        }
        File mods = new File(CMCL.gameDir, "mods");
        mods.mkdirs();
        try {
            fileName = URLDecoder.decode(modDownloadLink.substring(modDownloadLink.lastIndexOf(47) + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (Utils.isEmpty(fileName)) {
            fileName = System.currentTimeMillis() + ".jar";
        }
        if ((modFile = new File(mods, fileName)).exists()) {
            File file = ModFunction.askStorage(modFile, Utils.getString("CF_BESEARCHED_MOD_ALC"));
            if (file != null) {
                modFile = file;
                mods = file.getParentFile();
            } else {
                return;
            }
        }
        try {
            System.out.print(Utils.getString("MESSAGE_DOWNLOADING_FILE_TO", fileName, mods.getAbsolutePath()));
            DownloadUtils.downloadFile(modDownloadLink, modFile, new PercentageTextProgress());
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(Utils.getString("MESSAGE_FAILED_DOWNLOAD_FILE_WITH_REASON", fileName, e));
        }
    }

    public static String getModDownloadSource(JSONObject config) {
        String sourceStr = config.optString("modDownloadSource");
        if (!(sourceStr.equalsIgnoreCase("curseforge") || sourceStr.equalsIgnoreCase("modrinth") || sourceStr.equalsIgnoreCase("cf") || sourceStr.equalsIgnoreCase("mr"))) {
            int n;
            ArrayList<Pair<String, Integer>> sources = new ArrayList<Pair<String, Integer>>(2);
            sources.add(0, new Pair<String, Integer>("CurseForge", 0));
            sources.add(1, new Pair<String, Integer>("Modrinth", 1));
            for (Pair pair : sources) {
                System.out.printf("[%d]%s\n", pair.getValue(), pair.getKey());
            }
            int defaultDownloadSource = 0;
            boolean bl = false;
            System.out.print(Utils.getString("CONSOLE_CHOOSE_DOWNLOAD_SOURCE_CF_OR_MR", defaultDownloadSource));
            try {
                n = Integer.parseInt(new Scanner(System.in).nextLine());
            }
            catch (NumberFormatException | NoSuchElementException runtimeException) {
                // empty catch block
            }
            String mds = n == 1 ? "modrinth" : "curseforge";
            config.put("modDownloadSource", mds);
            Utils.saveConfig(config);
        }
        return config.optString("modDownloadSource");
    }
}

