/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.mod;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.ArgumentRequirement;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.functions.mod.CurseForgeSearcher;
import com.mrshiehx.cmcl.functions.mod.ModFunction;
import com.mrshiehx.cmcl.functions.mod.ModrinthSearcher;
import com.mrshiehx.cmcl.modSources.curseforge.CurseForgeModpackManager;
import com.mrshiehx.cmcl.modSources.modrinth.ModrinthModpackManager;
import com.mrshiehx.cmcl.modules.modpack.CurseForgeModpackInstaller;
import com.mrshiehx.cmcl.modules.modpack.MCBBSModpackInstaller;
import com.mrshiehx.cmcl.modules.modpack.ModrinthModpackInstaller;
import com.mrshiehx.cmcl.modules.modpack.MultiMCModpackInstaller;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONObject;

public class ModpackFunction
implements Function {
    @Override
    public void execute(Arguments arguments) {
        int source;
        if (!Function.checkArgs(arguments, 2, 1, ArgumentRequirement.ofSingle("install"), ArgumentRequirement.ofSingle("info"), ArgumentRequirement.ofSingle("no-assets"), ArgumentRequirement.ofSingle("no-libraries"), ArgumentRequirement.ofSingle("no-natives"), ArgumentRequirement.ofSingle("k"), ArgumentRequirement.ofSingle("keep-file"), ArgumentRequirement.ofValue("file"), ArgumentRequirement.ofValue("storage"), ArgumentRequirement.ofValue("source"), ArgumentRequirement.ofValue("n"), ArgumentRequirement.ofValue("name"), ArgumentRequirement.ofValue("id"), ArgumentRequirement.ofValue("limit"), ArgumentRequirement.ofValue("t"), ArgumentRequirement.ofValue("thread"), ArgumentRequirement.ofValue("url"), ArgumentRequirement.ofValue("game-version"), ArgumentRequirement.ofValue("v"), ArgumentRequirement.ofValue("version"))) {
            return;
        }
        int count = 0;
        if (arguments.contains("install")) {
            ++count;
        }
        if (arguments.contains("info")) {
            ++count;
        }
        if (arguments.contains("file")) {
            ++count;
        }
        if (arguments.contains("url")) {
            ++count;
        }
        if (count == 0) {
            System.out.println(CMCL.getString("MODPACK_CONTAINS_NOTHING"));
            return;
        }
        if (count > 1) {
            System.out.println(CMCL.getString("MODPACK_CONTAINS_TWO_OR_MORE"));
            return;
        }
        int todo = -1;
        if (arguments.contains("install")) {
            todo = 0;
        } else if (arguments.contains("info")) {
            todo = 1;
        } else if (arguments.contains("file")) {
            todo = 2;
        } else if (arguments.contains("url")) {
            todo = 3;
        }
        if (todo == 2) {
            File modpack = new File(arguments.opt("file"));
            if (!modpack.exists() || modpack.isDirectory()) {
                System.out.println(CMCL.getString("FILE_NOT_FOUND_OR_IS_A_DIRECTORY"));
                return;
            }
            String versionStorageName = arguments.opt("storage");
            if (CMCL.isEmpty(versionStorageName)) {
                versionStorageName = InteractionUtils.inputStringInFilter(CMCL.getString("MESSAGE_INPUT_VERSION_NAME"), CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS"), string -> !CMCL.isEmpty(string) && !VersionUtils.versionExists(string));
            }
            if (CMCL.isEmpty(versionStorageName)) {
                return;
            }
            if (VersionUtils.versionExists(versionStorageName)) {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS", versionStorageName));
                return;
            }
            int threadCount = arguments.optInt("t", arguments.optInt("thread"));
            File versionDir = new File(CMCL.versionsDir, versionStorageName);
            try (ZipFile zipFile = new ZipFile(modpack);){
                ModpackFunction.installModpack(zipFile, modpack, versionDir, true, !arguments.contains("no-assets"), !arguments.contains("no-natives"), !arguments.contains("no-libraries"), threadCount > 0 ? threadCount : 64);
            }
            catch (Exception e) {
                System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e));
                FileUtils.deleteDirectory(versionDir);
            }
            return;
        }
        if (todo == 3) {
            String url = arguments.opt("url");
            String versionStorageName = arguments.opt("storage");
            if (CMCL.isEmpty(versionStorageName)) {
                versionStorageName = InteractionUtils.inputStringInFilter(CMCL.getString("MESSAGE_INPUT_VERSION_NAME"), CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS"), string -> !CMCL.isEmpty(string) && !VersionUtils.versionExists(string));
            }
            if (CMCL.isEmpty(versionStorageName)) {
                return;
            }
            if (VersionUtils.versionExists(versionStorageName)) {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS", versionStorageName));
                return;
            }
            ModpackFunction.downloadModpackWithInstalling(versionStorageName, url, arguments, -1);
            return;
        }
        String sourceStr = arguments.opt("source");
        if (CMCL.isEmpty(sourceStr)) {
            JSONObject config = CMCL.getConfig();
            sourceStr = ModFunction.getModDownloadSource(config);
        }
        switch (Objects.requireNonNull(sourceStr).toLowerCase()) {
            case "cf": 
            case "curseforge": {
                source = 0;
                break;
            }
            case "mr": 
            case "modrinth": {
                source = 1;
                break;
            }
            default: {
                System.out.println(Utils.getString("MOD_UNKNOWN_SOURCE", sourceStr));
                return;
            }
        }
        String modNameInput = arguments.opt("n", arguments.opt("name"));
        String modIdInput = arguments.opt("id");
        if (!CMCL.isEmpty(modNameInput) && !CMCL.isEmpty(modIdInput)) {
            System.out.println(CMCL.getString("MOD_CONTAINS_BOTH_NAME_AND_ID"));
            return;
        }
        if (CMCL.isEmpty(modNameInput) && CMCL.isEmpty(modIdInput)) {
            System.out.println(CMCL.getString("MOD_CONTAINS_BOTH_NOT_NAME_AND_ID"));
            return;
        }
        if (!CMCL.isEmpty(modIdInput) && arguments.contains("limit")) {
            System.out.println(CMCL.getString("MOD_ID_LIMIT_COEXIST"));
            return;
        }
        int limit = arguments.optInt("limit", 50);
        if (limit > 50 && source == 0) {
            System.out.println(CMCL.getString("MOD_SEARCH_LIMIT_GREATER_THAN_FIFTY"));
            return;
        }
        if (source == 0) {
            CurseForgeModpackManager cf = new CurseForgeModpackManager();
            JSONObject mod = CurseForgeSearcher.search(cf, modNameInput, modIdInput, limit);
            if (mod == null) {
                return;
            }
            String modpackName = mod.optString("name");
            if (todo == 0) {
                int modId = mod.optInt("id");
                String modpackDownloadLink = cf.getDownloadLink(String.valueOf(modId), modpackName, arguments.opt("game-version"), arguments.opt("v", arguments.opt("version")), true, (x, y, z) -> {});
                if (CMCL.isEmpty(modpackDownloadLink)) {
                    return;
                }
                String versionStorageName = arguments.opt("storage");
                if (CMCL.isEmpty(versionStorageName)) {
                    versionStorageName = InteractionUtils.inputStringInFilter(CMCL.getString("MESSAGE_INPUT_VERSION_NAME"), CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS"), string -> !CMCL.isEmpty(string) && !VersionUtils.versionExists(string));
                }
                if (CMCL.isEmpty(versionStorageName)) {
                    return;
                }
                if (VersionUtils.versionExists(versionStorageName)) {
                    System.out.println(CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS", versionStorageName));
                    return;
                }
                ModpackFunction.downloadModpackWithInstalling(versionStorageName, modpackDownloadLink, arguments, source);
            } else if (todo == 1) {
                cf.printInformation(mod, modpackName);
            }
        } else {
            ModrinthModpackManager mr = new ModrinthModpackManager();
            ModrinthSearcher.Result result = ModrinthSearcher.search(mr, modNameInput, modIdInput, limit);
            if (result == null) {
                return;
            }
            JSONObject mod = result.mod;
            JSONObject modByID = result.modByID;
            String modName = result.modName;
            String modID = result.modID;
            if (todo == 0) {
                String modDownloadLink = mr.getDownloadLink(modID, modName, arguments.opt("game-version"), arguments.opt("v", arguments.opt("version")), true, (x, y, z) -> {});
                if (CMCL.isEmpty(modDownloadLink)) {
                    return;
                }
                String versionStorageName = arguments.opt("storage");
                if (CMCL.isEmpty(versionStorageName)) {
                    versionStorageName = InteractionUtils.inputStringInFilter(CMCL.getString("MESSAGE_INPUT_VERSION_NAME"), CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS"), string -> !CMCL.isEmpty(string) && !VersionUtils.versionExists(string));
                }
                if (CMCL.isEmpty(versionStorageName)) {
                    return;
                }
                if (VersionUtils.versionExists(versionStorageName)) {
                    System.out.println(CMCL.getString("MESSAGE_INSTALL_INPUT_NAME_EXISTS", versionStorageName));
                    return;
                }
                ModpackFunction.downloadModpackWithInstalling(versionStorageName, modDownloadLink, arguments, source);
            } else if (todo == 1) {
                mr.printInformation(mod, modByID, null, null);
            }
        }
    }

    private static int installModpack(ZipFile zipFile, File file, File versionDir, boolean keepFile, boolean installAssets, boolean installNatives, boolean installLibraries, int threadCount) {
        try {
            return MCBBSModpackInstaller.tryToInstallMCBBSModpack(zipFile, file, versionDir, keepFile, installAssets, installNatives, installLibraries, threadCount);
        }
        catch (NotValidModPackFormat notValidModPackFormat) {
            try {
                return CurseForgeModpackInstaller.tryToInstallCurseForgeModpack(zipFile, file, versionDir, keepFile, installAssets, installNatives, installLibraries, threadCount);
            }
            catch (NotValidModPackFormat notValidModPackFormat2) {
                try {
                    return MultiMCModpackInstaller.tryToInstallMultiMCModpack(zipFile, file, versionDir, keepFile, installAssets, installNatives, installLibraries, threadCount);
                }
                catch (NotValidModPackFormat notValidModPackFormat3) {
                    try {
                        return ModrinthModpackInstaller.tryToInstallModrinthModpack(zipFile, file, versionDir, keepFile, installAssets, installNatives, installLibraries, threadCount);
                    }
                    catch (NotValidModPackFormat notValidModPackFormat4) {
                        System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_UNKNOWN_TYPE"));
                        return -1;
                    }
                }
            }
        }
    }

    @Override
    public String getUsageName() {
        return "modpack";
    }

    private static void downloadModpackWithInstalling(String versionName, String modDownloadLink, Arguments arguments, int source) {
        File modpackFile;
        String fileName;
        File modpacks = new File(CMCL.getCMCLWorkingDirectory(), "modpacks");
        modpacks.mkdirs();
        try {
            fileName = URLDecoder.decode(modDownloadLink.substring(modDownloadLink.lastIndexOf(47) + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (Utils.isEmpty(fileName)) {
            fileName = System.currentTimeMillis() + ".zip";
        }
        if ((modpackFile = new File(modpacks, fileName)).exists()) {
            File file = ModFunction.askStorage(modpackFile, CMCL.getString("CF_BESEARCHED_MODPACK_ALC"));
            if (file != null) {
                modpackFile = file;
                modpacks = file.getParentFile();
            } else {
                return;
            }
        }
        try {
            System.out.print(CMCL.getString("MESSAGE_DOWNLOADING_FILE_TO", fileName, modpacks.getAbsolutePath()));
            DownloadUtils.downloadFile(modDownloadLink, modpackFile, new PercentageTextProgress());
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("MESSAGE_FAILED_DOWNLOAD_FILE_WITH_REASON", fileName, e));
            return;
        }
        int threadCount = arguments.optInt("t", arguments.optInt("thread"));
        File versionDir = new File(CMCL.versionsDir, versionName);
        try (ZipFile zipFile = new ZipFile(modpackFile);){
            if (source == 0 || source == 1) {
                ZipEntry entry = zipFile.getEntry(source == 0 ? "manifest.json" : "modrinth.index.json");
                XJSONObject manifest = new XJSONObject(Utils.inputStream2String(zipFile.getInputStream(entry)));
                if (source == 0) {
                    CurseForgeModpackInstaller.installCurseForgeModpack(manifest, zipFile, modpackFile, versionDir, arguments.contains("k") || arguments.contains("keep-file"), !arguments.contains("no-assets"), !arguments.contains("no-natives"), !arguments.contains("no-libraries"), threadCount > 0 ? threadCount : 64);
                } else {
                    ModrinthModpackInstaller.installModrinthModpack(manifest, zipFile, modpackFile, versionDir, arguments.contains("k") || arguments.contains("keep-file"), !arguments.contains("no-assets"), !arguments.contains("no-natives"), !arguments.contains("no-libraries"), threadCount > 0 ? threadCount : 64);
                }
            } else {
                ModpackFunction.installModpack(zipFile, modpackFile, versionDir, true, !arguments.contains("no-assets"), !arguments.contains("no-natives"), !arguments.contains("no-libraries"), threadCount > 0 ? threadCount : 64);
            }
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e));
            FileUtils.deleteDirectory(versionDir);
        }
    }

    public static class NotValidModPackFormat
    extends Exception {
        public NotValidModPackFormat(String message) {
            super(message);
        }
    }
}

