/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.mod;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.enums.ModrinthSection;
import com.mrshiehx.cmcl.modSources.modrinth.ModrinthManager;
import org.json.JSONObject;

public class ModrinthSearcher {
    public static Result search(ModrinthManager mr, String modNameInput, String modIdInput, int limit) {
        JSONObject modByID;
        String modID;
        String modName;
        JSONObject mod;
        if (!CMCL.isEmpty(modNameInput)) {
            mod = mr.search(modNameInput, limit < 0 ? 50 : limit);
            if (mod == null) {
                return null;
            }
            modName = mod.optString("title");
            modID = mod.optString("project_id");
            try {
                modByID = mr.getByID(modID);
            }
            catch (Exception ignore) {
                modByID = null;
            }
        } else {
            try {
                modByID = mr.getByID(modIdInput);
                modName = modByID.optString("title");
                modID = modByID.optString("id");
                mod = null;
            }
            catch (ModrinthManager.IncorrectCategoryAddon e) {
                ModrinthSection target = e.section;
                System.out.println(CMCL.getString("CF_GET_BY_ID_INCORRECT_CATEGORY_DETAIL").replace("${NAME}", mr.getSection().nameAllLowerCase).replace("${TARGET}", target != null ? target.nameAllLowerCase : "null"));
                return null;
            }
            catch (Exception e) {
                System.out.println(CMCL.getString("CF_GET_BY_ID_FAILED", e).replace("${NAME}", mr.getSection().nameAllLowerCase));
                return null;
            }
        }
        return new Result(mod, modByID, modName, modID);
    }

    public static class Result {
        public final JSONObject mod;
        public final JSONObject modByID;
        public final String modName;
        public final String modID;

        public Result(JSONObject mod, JSONObject modByID, String modName, String modID) {
            this.mod = mod;
            this.modByID = modByID;
            this.modName = modName;
            this.modID = modID;
        }
    }
}

