/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.root;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.NotSelectedException;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.functions.Functions;
import com.mrshiehx.cmcl.functions.root.RootFunction;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.console.CommandUtils;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.json.JSONObject;

public class ImmersiveMode {
    public static void getIn() {
        CMCL.isImmersiveMode = true;
        block14: while (true) {
            Argument argument;
            String command;
            String s;
            if (Constants.ECHO_OPEN_FOR_IMMERSIVE) {
                ImmersiveMode.printPrompt();
            }
            Scanner scanner = new Scanner(System.in);
            try {
                s = scanner.nextLine();
            }
            catch (NoSuchElementException e) {
                return;
            }
            if (Utils.isEmpty(s)) continue;
            switch (command = ImmersiveMode.format(s)) {
                case "echo off": {
                    Constants.ECHO_OPEN_FOR_IMMERSIVE = false;
                    continue block14;
                }
                case "echo on": {
                    Constants.ECHO_OPEN_FOR_IMMERSIVE = true;
                    continue block14;
                }
                case "exit": {
                    System.exit(0);
                    return;
                }
            }
            List<String> list = CommandUtils.splitCommand(command);
            Arguments args = new Arguments(list.toArray(new String[0]), true);
            if (args.getSize() == 0 || (argument = args.optArgument(0)) == null) continue;
            String key = argument.key;
            if ("help".equals(key)) {
                RootFunction.printHelp();
                continue;
            }
            Function function = Functions.get(key);
            if (function == null) {
                RootFunction.execute(args, true);
                continue;
            }
            Argument usage = args.optArgument(1);
            if (usage != null && (usage.equals("help") || usage.equals("h"))) {
                String name = function.getUsageName();
                if (!Utils.isEmpty(name)) {
                    System.out.println(CMCL.getHelpDocumentation(name));
                    continue;
                }
                RootFunction.printHelp();
                continue;
            }
            try {
                function.execute(args);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static String format(String command) {
        return !Utils.isEmpty(command) ? CommandUtils.clearRedundantSpaces(command) : "";
    }

    private static void printPrompt() {
        JSONObject account = null;
        JSONObject config = Utils.getConfig();
        try {
            account = AccountUtils.getSelectedAccount(config, false);
        }
        catch (NotSelectedException notSelectedException) {
            // empty catch block
        }
        String selectedVersion = config.optString("selectedVersion");
        StringBuilder stringBuilder = new StringBuilder();
        if (account != null && !Utils.isEmpty(account.optString("playerName"))) {
            stringBuilder.append(account.optString("playerName"));
            if (!Utils.isEmpty(selectedVersion)) {
                stringBuilder.append('@');
            }
        }
        if (!Utils.isEmpty(selectedVersion)) {
            stringBuilder.append(selectedVersion);
        }
        stringBuilder.append("$ ");
        System.out.print(stringBuilder);
    }
}

