/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.root;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.VersionConfig;
import com.mrshiehx.cmcl.exceptions.CommandTooLongException;
import com.mrshiehx.cmcl.exceptions.EmptyNativesException;
import com.mrshiehx.cmcl.exceptions.InvalidJavaException;
import com.mrshiehx.cmcl.exceptions.LaunchException;
import com.mrshiehx.cmcl.exceptions.LibraryDefectException;
import com.mrshiehx.cmcl.functions.VersionFunction;
import com.mrshiehx.cmcl.functions.root.VersionStarter;
import com.mrshiehx.cmcl.modules.MinecraftLauncher;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorInformation;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.nide8auth.Nide8AuthInformation;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.cmcl.ArgumentsUtils;
import com.mrshiehx.cmcl.utils.console.CommandUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LaunchCommands {
    public static String getBatContent(String version) throws CommandTooLongException {
        try {
            List<String> args = LaunchCommands.getArguments(version);
            if (args == null) {
                return null;
            }
            File versionsFolder = new File(CMCL.gameDir, "versions");
            File versionFolder = new File(versionsFolder, version);
            StringBuilder stringBuilder = new StringBuilder();
            String command = CommandUtils.argsToCommand(args);
            if (command.length() > 8190) {
                throw new CommandTooLongException();
            }
            String path = versionFolder.getAbsolutePath();
            stringBuilder.append("@echo off").append('\n');
            stringBuilder.append("cd /D ").append(path.contains(" ") ? "\"" + path + "\"" : path).append('\n');
            stringBuilder.append(command).append('\n');
            stringBuilder.append("pause").append('\n');
            return stringBuilder.toString();
        }
        catch (CommandTooLongException e) {
            throw e;
        }
        catch (EmptyNativesException ex) {
            System.out.println(CMCL.getString("EXCEPTION_NATIVE_LIBRARIES_NOT_FOUND"));
        }
        catch (LibraryDefectException ex) {
            VersionFunction.executeNotFound(ex.list);
        }
        catch (LaunchException ex) {
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex);
        }
        return null;
    }

    public static String getShContent(String version) {
        try {
            List<String> args = LaunchCommands.getArguments(version);
            if (args == null) {
                return null;
            }
            File versionsFolder = new File(CMCL.gameDir, "versions");
            File versionFolder = new File(versionsFolder, version);
            StringBuilder stringBuilder = new StringBuilder();
            String command = CommandUtils.argsToCommand(args);
            String path = versionFolder.getAbsolutePath();
            stringBuilder.append("#!/usr/bin/env bash").append('\n');
            stringBuilder.append("cd ").append(path.contains(" ") ? "\"" + path + "\"" : path).append('\n');
            stringBuilder.append(command).append('\n');
            return stringBuilder.toString();
        }
        catch (EmptyNativesException ex) {
            System.out.println(CMCL.getString("EXCEPTION_NATIVE_LIBRARIES_NOT_FOUND"));
        }
        catch (LibraryDefectException ex) {
            VersionFunction.executeNotFound(ex.list);
        }
        catch (LaunchException ex) {
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex);
        }
        return null;
    }

    public static String getPowerShellContent(String version) {
        try {
            List<String> args = LaunchCommands.getArguments(version);
            if (args == null) {
                return null;
            }
            File versionsFolder = new File(CMCL.gameDir, "versions");
            File versionFolder = new File(versionsFolder, version);
            StringBuilder stringBuilder = new StringBuilder();
            String path = versionFolder.getAbsolutePath();
            stringBuilder.append("Set-Location -Path ").append(CommandUtils.powershellString(path)).append('\n');
            stringBuilder.append('&');
            for (String raw : args) {
                stringBuilder.append(' ');
                stringBuilder.append(CommandUtils.powershellString(raw));
            }
            stringBuilder.append('\n');
            return stringBuilder.toString();
        }
        catch (EmptyNativesException ex) {
            System.out.println(CMCL.getString("EXCEPTION_NATIVE_LIBRARIES_NOT_FOUND"));
        }
        catch (LibraryDefectException ex) {
            VersionFunction.executeNotFound(ex.list);
        }
        catch (LaunchException ex) {
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex);
        }
        return null;
    }

    public static void print(String version) {
        try {
            List<String> args = LaunchCommands.getArguments(version);
            if (args == null) {
                return;
            }
            File versionsFolder = new File(CMCL.gameDir, "versions");
            File versionFolder = new File(versionsFolder, version);
            String command = CommandUtils.argsToCommand(args);
            String path = versionFolder.getAbsolutePath();
            System.out.println(CMCL.getString("CONSOLE_START_COMMAND"));
            System.out.println("===================================================================================================================");
            System.out.println("cd " + (SystemUtils.isWindows() ? "/D " : "") + (path.contains(" ") ? "\"" + path + "\"" : path));
            System.out.println(command);
            System.out.println("===================================================================================================================");
            if (SystemUtils.isWindows() && command.length() > 8190) {
                System.out.println(CMCL.getString("MESSAGE_PRINT_COMMAND_EXCEEDS_LENGTH_LIMIT"));
            }
        }
        catch (EmptyNativesException ex) {
            System.out.println(CMCL.getString("EXCEPTION_NATIVE_LIBRARIES_NOT_FOUND"));
        }
        catch (LibraryDefectException ex) {
            VersionFunction.executeNotFound(ex.list);
        }
        catch (LaunchException ex) {
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex);
        }
    }

    public static List<String> getArguments(String version) throws LaunchException, IOException {
        String quickPlayRealmsID;
        int windowSizeHeight;
        int windowSizeWidth;
        int maxMemory;
        String javaPath;
        JSONObject config = Utils.getConfig();
        if (CMCL.isEmpty(version) && CMCL.isEmpty(version = config.optString("selectedVersion"))) {
            System.out.println(CMCL.getString("MESSAGE_TO_SELECT_VERSION"));
            return null;
        }
        if (!config.has("checkAccountBeforeStart")) {
            config.put("checkAccountBeforeStart", InteractionUtils.yesOrNo(CMCL.getString("CONSOLE_ASK_CHECK_ACCOUNT")));
        }
        Utils.saveConfig(config);
        File versionsFolder = new File(CMCL.gameDir, "versions");
        File versionFolder = new File(versionsFolder, version);
        File versionJarFile = new File(versionFolder, version + ".jar");
        File versionJsonFile = new File(versionFolder, version + ".json");
        JSONObject account = AccountUtils.getSelectedAccountIfNotLoginNow(config);
        if (account == null) {
            return null;
        }
        if (!Utils.isEmpty(account.optString("offlineSkin")) || !Utils.isEmpty(account.optString("providedSkin"))) {
            System.out.println(CMCL.getString("PRINT_COMMAND_NOT_SUPPORT_OFFLINE_CUSTOM_SKIN"));
        }
        VersionConfig versionConfig = VersionStarter.getVersionInfo(versionFolder);
        File workingDirectory = Boolean.parseBoolean(versionConfig.isolate) ? versionFolder : (!Utils.isEmpty(versionConfig.gameDir) ? new File(versionConfig.gameDir) : (MinecraftLauncher.isModpack(versionFolder) ? versionFolder : CMCL.gameDir));
        String viJavaPath = versionConfig.javaPath;
        String viMaxMemory = versionConfig.maxMemory;
        String viWindowSizeWidth = versionConfig.windowSizeWidth;
        String viWindowSizeHeight = versionConfig.windowSizeHeight;
        if (CMCL.isEmpty(viJavaPath)) {
            javaPath = CMCL.javaPath;
        } else {
            try {
                javaPath = MinecraftLauncher.getRealJavaPath(viJavaPath);
            }
            catch (InvalidJavaException e) {
                javaPath = CMCL.javaPath;
                System.out.println(CMCL.getString("WARNING_VCFG_JAVA_INCORRECT"));
            }
        }
        if (CMCL.isEmpty(viMaxMemory)) {
            maxMemory = config.optInt("maxMemory", (int)SystemUtils.getDefaultMemory());
        } else {
            try {
                maxMemory = Integer.parseInt(viMaxMemory);
                if (maxMemory <= 0) {
                    maxMemory = config.optInt("maxMemory", (int)SystemUtils.getDefaultMemory());
                    System.out.println(CMCL.getString("WARNING_VCFG_MAX_MEMORY_INCORRECT"));
                }
            }
            catch (NumberFormatException n) {
                maxMemory = config.optInt("maxMemory", (int)SystemUtils.getDefaultMemory());
            }
        }
        if (CMCL.isEmpty(viWindowSizeWidth)) {
            windowSizeWidth = config.optInt("windowSizeWidth", 854);
        } else {
            try {
                windowSizeWidth = Integer.parseInt(viWindowSizeWidth);
                if (windowSizeWidth <= 0) {
                    windowSizeWidth = config.optInt("windowSizeWidth", 854);
                    System.out.println(CMCL.getString("WARNING_VCFG_WINDOW_SIZE_WIDTH_INCORRECT"));
                }
            }
            catch (NumberFormatException n) {
                windowSizeWidth = config.optInt("windowSizeWidth", 854);
            }
        }
        if (CMCL.isEmpty(viWindowSizeHeight)) {
            windowSizeHeight = config.optInt("windowSizeHeight", 480);
        } else {
            try {
                windowSizeHeight = Integer.parseInt(viWindowSizeHeight);
                if (windowSizeHeight <= 0) {
                    windowSizeHeight = config.optInt("windowSizeHeight", 480);
                    System.out.println(CMCL.getString("WARNING_VCFG_WINDOW_SIZE_HEIGHT_INCORRECT"));
                }
            }
            catch (NumberFormatException n) {
                windowSizeHeight = config.optInt("windowSizeHeight", 480);
            }
        }
        boolean checkAccountBeforeStart = !Utils.isEmpty(versionConfig.checkAccountBeforeStart) ? Boolean.parseBoolean(versionConfig.checkAccountBeforeStart) : config.optBoolean("checkAccountBeforeStart");
        boolean isFullscreen = !Utils.isEmpty(versionConfig.isFullscreen) ? Boolean.parseBoolean(versionConfig.isFullscreen) : config.optBoolean("isFullscreen");
        List<String> jvmArgs = ArgumentsUtils.parseJVMArgs(config.optJSONArray("jvmArgs"));
        jvmArgs.addAll(versionConfig.jvmArgs);
        Map<String, String> gameArgs = ArgumentsUtils.parseGameArgs(config.optJSONObject("gameArgs"));
        gameArgs.putAll(versionConfig.gameArgs);
        File assetsDir = !Utils.isEmpty(versionConfig.assetsDir) ? new File(versionConfig.assetsDir) : CMCL.assetsDir;
        File resourcesDir = !Utils.isEmpty(versionConfig.resourcesDir) ? new File(versionConfig.resourcesDir) : CMCL.resourcePacksDir;
        String quickPlayLogFilePath = !Utils.isEmpty(versionConfig.qpLogFile) ? versionConfig.qpLogFile : config.optString("qpLogFile");
        String quickPlaySaveName = !Utils.isEmpty(versionConfig.qpSaveName) ? versionConfig.qpSaveName : config.optString("qpSaveName");
        String quickPlayServerAddress = !Utils.isEmpty(versionConfig.qpServerAddress) ? versionConfig.qpServerAddress : config.optString("qpServerAddress");
        String string = quickPlayRealmsID = !Utils.isEmpty(versionConfig.qpRealmsID) ? versionConfig.qpRealmsID : config.optString("qpRealmsID");
        if (CMCL.isEmpty(javaPath) || !new File(javaPath).exists()) {
            System.out.println(CMCL.getString("CONSOLE_INCORRECT_JAVA"));
            return null;
        }
        if (checkAccountBeforeStart && !VersionStarter.checkAccount(account, config)) {
            return null;
        }
        String accessToken = Utils.randomUUIDNoSymbol();
        String uuid = AccountUtils.getUUIDByName(account.optString("playerName", "XPlayer"));
        if (account.optInt("loginMethod") > 0) {
            accessToken = account.optString("accessToken", accessToken);
            uuid = account.optString("uuid", uuid);
        }
        return MinecraftLauncher.getMinecraftLaunchCommandArguments(versionJarFile, versionJsonFile, workingDirectory, assetsDir, resourcesDir, account.optString("playerName", "XPlayer"), javaPath, maxMemory, 128, windowSizeWidth, windowSizeHeight, isFullscreen, accessToken, uuid, false, !isFullscreen, account.optJSONObject("properties"), null, jvmArgs, gameArgs, AuthlibInjectorInformation.valuesOf(account, accessToken, uuid, false), account.optInt("loginMethod") == 3 ? Nide8AuthInformation.valueOf(account) : null, quickPlayLogFilePath, quickPlaySaveName, quickPlayServerAddress, quickPlayRealmsID);
    }
}

