/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.root;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.SingleArgument;
import com.mrshiehx.cmcl.bean.arguments.TextArgument;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.functions.Function;
import com.mrshiehx.cmcl.functions.root.AboutPrinter;
import com.mrshiehx.cmcl.functions.root.ImmersiveMode;
import com.mrshiehx.cmcl.functions.root.LaunchCommands;
import com.mrshiehx.cmcl.functions.root.UpdatesChecker;
import com.mrshiehx.cmcl.functions.root.VersionSelector;
import com.mrshiehx.cmcl.functions.root.VersionStarter;
import com.mrshiehx.cmcl.functions.root.VersionsLister;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;

public class RootFunction
implements Function {
    @Override
    public void execute(Arguments arguments) {
        RootFunction.execute(arguments, false);
    }

    public static void execute(Arguments arguments, boolean isImmersive) {
        Argument firstArgument = arguments.optArgument(0);
        String key = firstArgument.key;
        String originString = firstArgument.originString;
        String[] originArray = firstArgument.originArray;
        if (!isImmersive) {
            if (firstArgument instanceof SingleArgument) {
                switch (key) {
                    case "h": 
                    case "help": {
                        RootFunction.printHelp();
                        break;
                    }
                    case "a": 
                    case "about": {
                        AboutPrinter.execute();
                        break;
                    }
                    case "c": 
                    case "check-for-updates": {
                        UpdatesChecker.execute();
                        break;
                    }
                    case "l": 
                    case "list": {
                        VersionsLister.execute(null);
                        break;
                    }
                    case "p": 
                    case "print": {
                        String selectedVersion = Utils.getConfig().optString("selectedVersion");
                        if (CMCL.isEmpty(selectedVersion)) {
                            System.out.println(CMCL.getString("MESSAGE_TO_SELECT_VERSION"));
                            return;
                        }
                        LaunchCommands.print(selectedVersion);
                        break;
                    }
                    default: {
                        RootFunction.tryToStartVersion(originArray[0]);
                        break;
                    }
                }
            } else if (firstArgument instanceof ValueArgument) {
                String value = ((ValueArgument)firstArgument).value;
                switch (key) {
                    case "l": 
                    case "list": {
                        VersionsLister.execute(value);
                        break;
                    }
                    case "p": 
                    case "print": {
                        LaunchCommands.print(value);
                        break;
                    }
                    case "s": 
                    case "select": {
                        VersionSelector.execute(value);
                        break;
                    }
                    case "h": 
                    case "help": {
                        System.out.println(Utils.getString("CONSOLE_HELP_WRONG_WRITE", originString));
                        break;
                    }
                    default: {
                        RootFunction.tryToStartVersion(originArray[0]);
                        break;
                    }
                }
            } else {
                RootFunction.tryToStartVersion(originArray[0]);
            }
        } else {
            if (!(firstArgument instanceof TextArgument)) {
                System.out.println(Utils.getString("CONSOLE_IMMERSIVE_WRONG", firstArgument.originString));
                return;
            }
            Argument secondArgument = arguments.optArgument(1);
            switch (key) {
                case "help": {
                    RootFunction.printHelp();
                    break;
                }
                case "about": {
                    AboutPrinter.execute();
                    break;
                }
                case "immersive": {
                    ImmersiveMode.getIn();
                    break;
                }
                case "check-for-updates": {
                    UpdatesChecker.execute();
                    break;
                }
                case "list": {
                    String dir = null;
                    if (secondArgument != null) {
                        dir = secondArgument.originArray[0];
                    }
                    VersionsLister.execute(dir);
                    break;
                }
                case "print": {
                    String versionToPrint = null;
                    if (secondArgument != null) {
                        versionToPrint = secondArgument.originArray[0];
                    }
                    LaunchCommands.print(versionToPrint);
                    break;
                }
                case "select": {
                    if (secondArgument == null) {
                        System.out.println(Utils.getString("CONSOLE_IMMERSIVE_MISSING_PARAMETER"));
                        return;
                    }
                    VersionSelector.execute(secondArgument.originArray[0]);
                    break;
                }
                case "start": {
                    String version = null;
                    if (secondArgument != null) {
                        version = secondArgument.originArray[0];
                    }
                    VersionStarter.execute(version);
                    break;
                }
                default: {
                    System.out.println(Utils.getString("CONSOLE_IMMERSIVE_NOT_FOUND", key));
                }
            }
        }
    }

    private static void tryToStartVersion(String versionName) {
        if (VersionUtils.versionExists(versionName)) {
            VersionStarter.execute(versionName);
        } else {
            System.out.println(Utils.getString("CONSOLE_NOT_FOUND_VERSION_OR_OPTION", versionName));
        }
    }

    @Override
    public String getUsageName() {
        return null;
    }

    public static void printHelp() {
        System.out.println(CMCL.getHelpDocumentation("ROOT"));
    }
}

