/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.functions.root;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.RunningMinecraft;
import com.mrshiehx.cmcl.bean.VersionConfig;
import com.mrshiehx.cmcl.enums.GameCrashError;
import com.mrshiehx.cmcl.exceptions.EmptyNativesException;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.exceptions.InvalidJavaException;
import com.mrshiehx.cmcl.exceptions.LaunchException;
import com.mrshiehx.cmcl.exceptions.LibraryDefectException;
import com.mrshiehx.cmcl.functions.AccountFunction;
import com.mrshiehx.cmcl.functions.VersionFunction;
import com.mrshiehx.cmcl.modules.MinecraftLauncher;
import com.mrshiehx.cmcl.modules.account.authentication.AccountRefresher;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorInformation;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.nide8auth.Nide8AuthInformation;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.cmcl.ArgumentsUtils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionStarter {
    public static VersionConfig getVersionInfo(File versionFolder) {
        File versionInfoFile = new File(versionFolder, "cmclversion.json");
        File versionInfoFileHMCL = new File(versionFolder, "hmclversion.cfg");
        File versionInfoFilePCL2 = new File(versionFolder, "PCL/Setup.ini");
        JSONObject cmclJO = null;
        JSONObject hmclJO = null;
        String pcl2File = null;
        if (versionInfoFile.exists()) {
            try {
                cmclJO = JSONUtils.parseJSONObject(FileUtils.readFileContent(versionInfoFile));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (versionInfoFileHMCL.exists()) {
            try {
                hmclJO = JSONUtils.parseJSONObject(FileUtils.readFileContent(versionInfoFileHMCL));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (versionInfoFilePCL2.exists()) {
            try {
                pcl2File = FileUtils.readFileContent(versionInfoFilePCL2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        VersionConfig cmcl = null;
        VersionConfig hmcl = null;
        VersionConfig pcl2 = null;
        if (cmclJO != null) {
            cmcl = VersionConfig.valueOf(cmclJO);
        }
        if (hmclJO != null) {
            hmcl = VersionConfig.valueOfHMCL(hmclJO);
        }
        if (pcl2File != null) {
            pcl2 = VersionConfig.valueOfPCL2(pcl2File);
        }
        VersionConfig Final = VersionConfig.EMPTY;
        if (cmcl != null && hmcl != null && pcl2 != null) {
            Final = pcl2.mergeTo(hmcl.mergeTo(cmcl));
        } else if (cmcl != null && hmcl != null) {
            Final = hmcl.mergeTo(cmcl);
        } else if (cmcl != null && pcl2 != null) {
            Final = pcl2.mergeTo(cmcl);
        } else if (hmcl != null && pcl2 != null) {
            Final = pcl2.mergeTo(hmcl);
        } else if (cmcl != null) {
            Final = cmcl;
        } else if (hmcl != null) {
            Final = hmcl;
        } else if (pcl2 != null) {
            Final = pcl2;
        }
        return Final;
    }

    public static void execute(String version) {
        JSONObject config = Utils.getConfig();
        if (CMCL.isEmpty(version) && CMCL.isEmpty(version = config.optString("selectedVersion"))) {
            System.out.println(CMCL.getString("CONSOLE_NO_SELECTED_VERSION"));
            return;
        }
        if (!config.has("exitWithMinecraft")) {
            config.put("exitWithMinecraft", InteractionUtils.yesOrNo(CMCL.getString("CONSOLE_ASK_EXIT_WITH_MC")));
        }
        if (!config.has("printStartupInfo")) {
            config.put("printStartupInfo", InteractionUtils.yesOrNo(CMCL.getString("CONSOLE_ASK_PRINT_STARTUP_INFO")));
        }
        if (!config.has("checkAccountBeforeStart")) {
            config.put("checkAccountBeforeStart", InteractionUtils.yesOrNo(CMCL.getString("CONSOLE_ASK_CHECK_ACCOUNT")));
        }
        Utils.saveConfig(config);
        VersionStarter.start(version, config);
    }

    public static void start(String version, JSONObject config) {
        File versionsFolder = new File(CMCL.gameDir, "versions");
        File versionFolder = new File(versionsFolder, version);
        File versionJarFile = new File(versionFolder, version + ".jar");
        File versionJsonFile = new File(versionFolder, version + ".json");
        try {
            String quickPlayRealmsID;
            int windowSizeHeight;
            int windowSizeWidth;
            int maxMemory;
            String javaPath;
            JSONObject account = AccountUtils.getSelectedAccountIfNotLoginNow(config);
            if (account == null) {
                return;
            }
            VersionConfig versionConfig = VersionStarter.getVersionInfo(versionFolder);
            File workingDirectory = Boolean.parseBoolean(versionConfig.isolate) ? versionFolder : (!Utils.isEmpty(versionConfig.gameDir) ? new File(versionConfig.gameDir) : (MinecraftLauncher.isModpack(versionFolder) ? versionFolder : CMCL.gameDir));
            String viJavaPath = versionConfig.javaPath;
            String viMaxMemory = versionConfig.maxMemory;
            String viWindowSizeWidth = versionConfig.windowSizeWidth;
            String viWindowSizeHeight = versionConfig.windowSizeHeight;
            if (CMCL.isEmpty(viJavaPath)) {
                javaPath = CMCL.javaPath;
            } else {
                try {
                    javaPath = MinecraftLauncher.getRealJavaPath(viJavaPath);
                }
                catch (InvalidJavaException e) {
                    javaPath = CMCL.javaPath;
                    System.out.println(CMCL.getString("WARNING_VCFG_JAVA_INCORRECT"));
                }
            }
            if (CMCL.isEmpty(viMaxMemory)) {
                maxMemory = config.optInt("maxMemory", (int)SystemUtils.getDefaultMemory());
            } else {
                try {
                    maxMemory = Integer.parseInt(viMaxMemory);
                    if (maxMemory <= 0) {
                        maxMemory = config.optInt("maxMemory", (int)SystemUtils.getDefaultMemory());
                        System.out.println(CMCL.getString("WARNING_VCFG_MAX_MEMORY_INCORRECT"));
                    }
                }
                catch (NumberFormatException n) {
                    maxMemory = config.optInt("maxMemory", (int)SystemUtils.getDefaultMemory());
                }
            }
            if (CMCL.isEmpty(viWindowSizeWidth)) {
                windowSizeWidth = config.optInt("windowSizeWidth", 854);
            } else {
                try {
                    windowSizeWidth = Integer.parseInt(viWindowSizeWidth);
                    if (windowSizeWidth <= 0) {
                        windowSizeWidth = config.optInt("windowSizeWidth", 854);
                        System.out.println(CMCL.getString("WARNING_VCFG_WINDOW_SIZE_WIDTH_INCORRECT"));
                    }
                }
                catch (NumberFormatException n) {
                    windowSizeWidth = config.optInt("windowSizeWidth", 854);
                }
            }
            if (CMCL.isEmpty(viWindowSizeHeight)) {
                windowSizeHeight = config.optInt("windowSizeHeight", 480);
            } else {
                try {
                    windowSizeHeight = Integer.parseInt(viWindowSizeHeight);
                    if (windowSizeHeight <= 0) {
                        windowSizeHeight = config.optInt("windowSizeHeight", 480);
                        System.out.println(CMCL.getString("WARNING_VCFG_WINDOW_SIZE_HEIGHT_INCORRECT"));
                    }
                }
                catch (NumberFormatException n) {
                    windowSizeHeight = config.optInt("windowSizeHeight", 480);
                }
            }
            boolean isFullscreen = !Utils.isEmpty(versionConfig.isFullscreen) ? Boolean.parseBoolean(versionConfig.isFullscreen) : config.optBoolean("isFullscreen");
            List<String> jvmArgs = versionConfig.jvmArgs.size() > 0 ? versionConfig.jvmArgs : ArgumentsUtils.parseJVMArgs(config.optJSONArray("jvmArgs"));
            Map<String, String> gameArgs = versionConfig.gameArgs.size() > 0 ? versionConfig.gameArgs : ArgumentsUtils.parseGameArgs(config.optJSONObject("gameArgs"));
            File assetsDir = !Utils.isEmpty(versionConfig.assetsDir) ? new File(versionConfig.assetsDir) : CMCL.assetsDir;
            File resourcePackDir = !Utils.isEmpty(versionConfig.resourcesDir) ? new File(versionConfig.resourcesDir) : CMCL.resourcePacksDir;
            boolean exitWithMinecraft = !Utils.isEmpty(versionConfig.exitWithMinecraft) ? Boolean.parseBoolean(versionConfig.exitWithMinecraft) : config.optBoolean("exitWithMinecraft");
            boolean printStartupInfo = !Utils.isEmpty(versionConfig.printStartupInfo) ? Boolean.parseBoolean(versionConfig.printStartupInfo) : config.optBoolean("printStartupInfo");
            boolean checkAccountBeforeStart = !Utils.isEmpty(versionConfig.checkAccountBeforeStart) ? Boolean.parseBoolean(versionConfig.checkAccountBeforeStart) : config.optBoolean("checkAccountBeforeStart");
            String quickPlayLogFilePath = !Utils.isEmpty(versionConfig.qpLogFile) ? versionConfig.qpLogFile : config.optString("qpLogFile");
            String quickPlaySaveName = !Utils.isEmpty(versionConfig.qpSaveName) ? versionConfig.qpSaveName : config.optString("qpSaveName");
            String quickPlayServerAddress = !Utils.isEmpty(versionConfig.qpServerAddress) ? versionConfig.qpServerAddress : config.optString("qpServerAddress");
            String string = quickPlayRealmsID = !Utils.isEmpty(versionConfig.qpRealmsID) ? versionConfig.qpRealmsID : config.optString("qpRealmsID");
            if (CMCL.isEmpty(javaPath) || !new File(javaPath).exists()) {
                System.out.println(CMCL.getString("CONSOLE_INCORRECT_JAVA"));
                return;
            }
            if (printStartupInfo) {
                StringBuilder sb = new StringBuilder();
                sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_MAIN").replace("${VERSION_NAME}", version).replace("${REAL_VERSION_NAME}", VersionStarter.getVersion(versionJsonFile, versionJarFile)).replace("${PLAYER_NAME}", account.optString("playerName", "XPlayer")).replace("${ACCOUNT_TYPE}", AccountFunction.getAccountTypeWithInformation(account)).replace("${JAVA_PATH}", javaPath).replace("${EXIT_WITH_MC}", String.valueOf(exitWithMinecraft)).replace("${FULLSCREEN}", String.valueOf(isFullscreen)).replace("${MAX_MEMORY}", maxMemory + "MB").replace("${WIDTH}", String.valueOf(windowSizeWidth)).replace("${HEIGHT}", String.valueOf(windowSizeHeight)).replace("${CHECK_ACCOUNT_BEFORE_START}", String.valueOf(checkAccountBeforeStart)).replace("${GAME_DIR}", workingDirectory.getAbsolutePath())).append('\n');
                if (!assetsDir.equals(new File(workingDirectory, "assets"))) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_ASSETS_DIR").replace("${ASSETS_DIR}", assetsDir.getAbsolutePath())).append('\n');
                }
                if (!resourcePackDir.equals(new File(workingDirectory, "resourcepacks"))) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_RESOURCE_PACKS_DIR").replace("${RESOURCE_PACKS_DIR}", resourcePackDir.getAbsolutePath())).append('\n');
                }
                if (!CMCL.isEmpty(quickPlayLogFilePath)) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_QUICK_PLAY_LOG_FILE_PATH").replace("${QUICK_PLAY_LOG_FILE_PATH}", quickPlayLogFilePath)).append('\n');
                }
                if (!CMCL.isEmpty(quickPlaySaveName)) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_QUICK_PLAY_SAVE_NAME").replace("${QUICK_PLAY_SAVE_NAME}", quickPlaySaveName)).append('\n');
                }
                if (!CMCL.isEmpty(quickPlayServerAddress)) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_QUICK_PLAY_SERVER_ADDRESS").replace("${QUICK_PLAY_SERVER_ADDRESS}", quickPlayServerAddress)).append('\n');
                }
                if (!CMCL.isEmpty(quickPlayRealmsID)) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_QUICK_PLAY_REALMS_ID").replace("${QUICK_PLAY_REALMS_ID}", quickPlayRealmsID)).append('\n');
                }
                if (jvmArgs.size() > 0 || gameArgs.size() > 0) {
                    sb.append(CMCL.getString("MESSAGE_STARTUP_INFO_ARGS").replace("${JVM_ARGS}", new JSONArray((Collection<?>)jvmArgs).toString(2)).replace("${GAME_ARGS}", new JSONObject(gameArgs).toString(2)));
                }
                System.out.println(sb);
            }
            if (checkAccountBeforeStart && !VersionStarter.checkAccount(account, config)) {
                return;
            }
            String accessToken = Utils.randomUUIDNoSymbol();
            String uuid = AccountUtils.getUUIDByName(account.optString("playerName", "XPlayer"));
            if (account.optInt("loginMethod") > 0) {
                accessToken = account.optString("accessToken", accessToken);
                uuid = account.optString("uuid", uuid);
            }
            CMCL.runningMc = new RunningMinecraft(MinecraftLauncher.launchMinecraft(versionFolder, versionJarFile, versionJsonFile, workingDirectory, assetsDir, resourcePackDir, account.optString("playerName", "XPlayer"), javaPath, maxMemory, 128, windowSizeWidth, windowSizeHeight, isFullscreen, accessToken, uuid, false, !isFullscreen, account.optJSONObject("properties"), jvmArgs, gameArgs, AuthlibInjectorInformation.valuesOf(account, accessToken, uuid, true), account.optInt("loginMethod") == 3 ? Nide8AuthInformation.valueOf(account) : null, quickPlayLogFilePath, quickPlaySaveName, quickPlayServerAddress, quickPlayRealmsID), exitWithMinecraft);
            GameCrashError[] crashError = new GameCrashError[]{null};
            new Thread(() -> {
                BufferedReader dis = new BufferedReader(new InputStreamReader(CMCL.runningMc.process.getInputStream()));
                try {
                    String line;
                    while ((line = dis.readLine()) != null) {
                        System.out.println(line);
                        if (line.contains("cannot be cast to class java.net.URLClassLoader")) {
                            crashError[0] = GameCrashError.URLClassLoader;
                            continue;
                        }
                        if (line.contains("Failed to load a library. Possible solutions:")) {
                            crashError[0] = GameCrashError.LWJGLFailedLoad;
                            continue;
                        }
                        if (line.contains("java.lang.OutOfMemoryError:") || line.contains("Too small maximum heap")) {
                            crashError[0] = GameCrashError.MemoryTooSmall;
                            continue;
                        }
                        if (!line.contains("Unrecognized option: ")) continue;
                        crashError[0] = GameCrashError.JvmUnrecognizedOption;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            try {
                CMCL.runningMc.process.waitFor();
                System.out.println(CMCL.getString("MESSAGE_FINISHED_GAME"));
                if (crashError[0] != null) {
                    System.out.println(CMCL.getString("MESSAGE_GAME_CRASH_CAUSE_TIPS", crashError[0].cause));
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        catch (EmptyNativesException ex) {
            System.out.println(CMCL.getString("EXCEPTION_NATIVE_LIBRARIES_NOT_FOUND"));
        }
        catch (LibraryDefectException ex) {
            VersionFunction.executeNotFound(ex.list);
        }
        catch (LaunchException ex) {
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(CMCL.getString("CONSOLE_FAILED_START") + ": " + ex);
        }
    }

    public static boolean checkAccount(JSONObject account, JSONObject config) {
        try {
            if (AccountRefresher.execute(account, config.optJSONArray("accounts"))) {
                Utils.saveConfig(config);
            }
            return true;
        }
        catch (ExceptionWithDescription e) {
            e.print();
            System.out.println(CMCL.getString("MESSAGE_TELL_USER_CHECK_ACCOUNT_CAN_BE_OFF"));
            return false;
        }
    }

    private static String getVersion(File versionJsonFile, File versionJarFile) {
        try {
            return Utils.valueOf(VersionUtils.getGameVersion((JSONObject)new JSONObject((String)FileUtils.readFileContent((File)versionJsonFile)), (File)versionJarFile).id);
        }
        catch (Exception e) {
            return "null";
        }
    }
}

