/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modSources.curseforge;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.enums.CurseForgeSection;
import com.mrshiehx.cmcl.modSources.Manager;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class CurseForgeManager
extends Manager<CurseForgeSection> {
    private static final String SEARCH_ADDONS = "https://api.curseforge.com/v1/mods/search?gameId=432";
    private static final String GET_ADDON_INFORMATION = "https://api.curseforge.com/v1/mods/";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public abstract CurseForgeSection getSection();

    @Override
    protected abstract String getNameAllLowerCase();

    protected abstract String getNameFirstUpperCase();

    /*
     * WARNING - void declaration
     */
    @Override
    public String getDownloadLink(String modId, String modName, @Nullable String mcversion, @Nullable String addonVersion, boolean isModpack, Manager.DependencyInstaller dependencyInstaller) {
        JSONArray jSONArray;
        List list;
        String modSupportMinecraftVersion;
        JSONArray modAllVersionsJsonArrayFather;
        try {
            JSONObject jsonObject = new JSONObject(NetworkUtils.curseForgeGet(GET_ADDON_INFORMATION + modId + "/files?pageSize=10000"));
            modAllVersionsJsonArrayFather = jsonObject.optJSONArray("data");
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("MOD_FAILED_TO_GET_ALL_FILES", e).replace("${NAME}", this.getNameAllLowerCase()));
            return null;
        }
        HashMap<String, ArrayList> modClassificationMap = new HashMap<String, ArrayList>();
        for (int i = 0; i < modAllVersionsJsonArrayFather.length(); ++i) {
            JSONObject modVersion = modAllVersionsJsonArrayFather.optJSONObject(i);
            if (modVersion == null) continue;
            JSONArray gameVersion = modVersion.optJSONArray("gameVersions");
            for (int j = 0; j < gameVersion.length(); ++j) {
                String ver = gameVersion.optString(j);
                ArrayList oneMcVerOfModSupport = modClassificationMap.containsKey(ver) ? (ArrayList)modClassificationMap.get(ver) : new ArrayList();
                modVersion.put("fileDate", modVersion.optString("fileDate").substring(0, 19));
                oneMcVerOfModSupport.add(modVersion);
                CurseForgeManager.addonFilesTimeSort(oneMcVerOfModSupport);
                modClassificationMap.put(ver, oneMcVerOfModSupport);
            }
        }
        modClassificationMap.remove("Fabric");
        modClassificationMap.remove("Forge");
        modClassificationMap.remove("Rift");
        if (!CMCL.isEmpty(mcversion) && modClassificationMap.get(mcversion) != null) {
            modSupportMinecraftVersion = mcversion;
        } else {
            ArrayList<String> modSupportedMcVer = new ArrayList<String>();
            for (Map.Entry entry : modClassificationMap.entrySet()) {
                String version = ((String)entry.getKey()).replace("-Snapshot", ".-1");
                if (modSupportedMcVer.contains(version)) continue;
                modSupportedMcVer.add(version);
            }
            modSupportedMcVer.sort((o1, o2) -> {
                String[] o1s = o1.split("\\.");
                String[] o2s = o2.split("\\.");
                if (o1s.length == 0 || o2s.length == 0) {
                    return 0;
                }
                int[] o1i = new int[o1s.length];
                int[] o2i = new int[o2s.length];
                try {
                    int i;
                    for (i = 0; i < o1s.length; ++i) {
                        String o1String = o1s[i];
                        o1i[i] = Integer.parseInt(o1String);
                    }
                    for (i = 0; i < o2s.length; ++i) {
                        String o2String = o2s[i];
                        o2i[i] = Integer.parseInt(o2String);
                    }
                }
                catch (Exception e) {
                    return 0;
                }
                if (o1i[1] > o2i[1]) {
                    return -1;
                }
                if (o1i[1] < o2i[1]) {
                    return 1;
                }
                if (o1i.length >= 3 && o2i.length >= 3) {
                    return Integer.compare(o2i[2], o1i[2]);
                }
                if (o1i.length >= 3) {
                    return Integer.compare(0, o1i[2]);
                }
                if (o2i.length >= 3) {
                    return Integer.compare(o2i[2], 0);
                }
                return 0;
            });
            if (CMCL.isEmpty(modName)) {
                try {
                    modName = new JSONObject(NetworkUtils.curseForgeGet(GET_ADDON_INFORMATION + modId)).optJSONObject("data").optString("name");
                }
                catch (Exception gameVersion) {
                    // empty catch block
                }
            }
            System.out.println(CMCL.getString("CF_SUPPORTED_GAME_VERSION", modName));
            for (int i = 0; i < modSupportedMcVer.size(); ++i) {
                String string = (String)modSupportedMcVer.get(i);
                if (!string.endsWith(".-1")) continue;
                modSupportedMcVer.set(i, string.replace(".-1", "-Snapshot"));
            }
            PrintingUtils.printListItems(modSupportedMcVer, true, 6, 3, true);
            modSupportMinecraftVersion = InteractionUtils.inputStringInFilter(CMCL.getString("CF_INPUT_GAME_VERSION"), CMCL.getString("CONSOLE_INPUT_STRING_NOT_FOUND"), modSupportedMcVer::contains);
        }
        List versions = (List)modClassificationMap.get(modSupportMinecraftVersion);
        if (versions == null) {
            return null;
        }
        if (versions.size() == 0) {
            System.out.println(CMCL.getString("CF_NO_VERSION_FOR_GAME_VERSION", this.getNameAllLowerCase()));
            return null;
        }
        JSONObject targetFile = null;
        if (!CMCL.isEmpty(addonVersion) && (list = versions.stream().filter(mod -> {
            String fileName = mod.optString("fileName");
            return fileName.contains(addonVersion);
        }).collect(Collectors.toList())).size() == 1) {
            targetFile = (JSONObject)list.get(0);
        }
        if (targetFile == null) {
            void var12_23;
            AnsiConsole.systemInstall();
            int n = versions.size() - 1;
            while (var12_23 >= 0) {
                System.out.print(Ansi.ansi().fg(Ansi.Color.WHITE).a("[") + "" + Ansi.ansi().fg(Ansi.Color.CYAN).a((int)(var12_23 + true)) + Ansi.ansi().fg(Ansi.Color.WHITE).a("]" + ((JSONObject)versions.get((int)var12_23)).optString("fileName") + "\n"));
                --var12_23;
            }
            AnsiConsole.systemUninstall();
            int n2 = InteractionUtils.inputInt(CMCL.getString("CF_INPUT_VERSION", 1, versions.size()).replace("${NAME}", this.getNameAllLowerCase()), 1, versions.size(), true, -1);
            if (n2 == Integer.MAX_VALUE || n2 == -1) {
                return null;
            }
            targetFile = (JSONObject)versions.get(n2 - 1);
        }
        if ((jSONArray = targetFile.optJSONArray("dependencies")) != null && jSONArray.length() > 0) {
            HashMap<Integer, String> list2 = new HashMap<Integer, String>();
            for (Object object : jSONArray) {
                JSONObject jsonObject;
                if (!(object instanceof JSONObject) || (jsonObject = (JSONObject)object).optInt("relationType") != 3 || !jsonObject.has("modId")) continue;
                int addonId = jsonObject.optInt("modId");
                String name = null;
                try {
                    JSONObject head = new JSONObject(NetworkUtils.curseForgeGet(GET_ADDON_INFORMATION + addonId)).optJSONObject("data");
                    name = head.optString("name");
                }
                catch (Exception head) {
                    // empty catch block
                }
                list2.put(addonId, name);
            }
            if (list2.size() > 0) {
                System.out.println();
                System.out.println(CMCL.getString("CF_DEPENDENCIES_TIP").replace("${NAME}", this.getNameAllLowerCase()));
                int i = 0;
                for (Map.Entry entry : list2.entrySet()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int id = (Integer)entry.getKey();
                    String name = (String)entry.getValue();
                    stringBuilder.append(CMCL.getString("CF_DEPENDENCY_INFORMATION_ID", id)).append('\n');
                    if (!CMCL.isEmpty(name)) {
                        stringBuilder.append(CMCL.getString("CF_DEPENDENCY_INFORMATION_NAME", name)).append('\n');
                    }
                    System.out.println(stringBuilder);
                    ++i;
                }
                for (Map.Entry entry : list2.entrySet()) {
                    dependencyInstaller.install(modSupportMinecraftVersion, (String)entry.getValue(), String.valueOf(entry.getKey()));
                }
            }
        }
        return targetFile.optString("downloadUrl", String.format("https://edge.forgecdn.net/files/%d/%d/%s", targetFile.optInt("id") / 1000, targetFile.optInt("id") % 1000, targetFile.optString("fileName")));
    }

    @Override
    public JSONObject search(String searchContent, int limit) {
        JSONArray searchResult;
        try {
            JSONObject jsonObject = new JSONObject(NetworkUtils.curseForgeGet("https://api.curseforge.com/v1/mods/search?gameId=432&pageSize=" + limit + "&classId=" + this.getSection().sectionId + "&searchFilter=" + URLEncoder.encode(searchContent, StandardCharsets.UTF_8.name())));
            searchResult = jsonObject.optJSONArray("data");
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("MESSAGE_FAILED_SEARCH", e));
            return null;
        }
        List<JSONObject> list = JSONUtils.jsonArrayToJSONObjectList(searchResult);
        if (list.size() == 0) {
            System.out.println(CMCL.getString("NO_SEARCH_RESULTS"));
            return null;
        }
        Collections.reverse(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            try {
                JSONObject first;
                String gameVersion = null;
                String projectFileName = null;
                JSONObject result = list.get(i);
                if (result == null) continue;
                JSONArray gameVersionLatestFiles = result.optJSONArray("latestFilesIndexes");
                if (gameVersionLatestFiles != null && gameVersionLatestFiles.length() > 0 && (first = gameVersionLatestFiles.optJSONObject(0)) != null) {
                    gameVersion = first.optString("gameVersion");
                    projectFileName = first.optString("filename");
                }
                CurseForgeManager.printOne(i + 1, result.optString("name"), result.optString("summary"), CurseForgeManager.getAuthor(result.optJSONArray("authors")), gameVersion, projectFileName);
                continue;
            }
            catch (Exception e) {
                System.out.println(CMCL.getString("CF_FAILED_TO_SHOW_SOMEONE", i + 1, e).replace("${NAME}", this.getNameAllLowerCase()));
            }
        }
        int number = InteractionUtils.inputInt(Utils.getString("CF_SELECT_TARGET", 1, list.size()).replace("${NAME}", this.getNameAllLowerCase()), 1, list.size());
        if (number != Integer.MAX_VALUE) {
            return list.get(number - 1);
        }
        return null;
    }

    public static void printOne(int order, String name, String summary, String author, String latestGameVersion, String latestFileName) {
        boolean notEmptyBoth;
        AnsiConsole.systemInstall();
        if (CMCL.isEmpty(name)) {
            return;
        }
        author = !CMCL.isEmpty(author) ? Ansi.ansi().fg(Ansi.Color.WHITE).a("/ ") + "" + author + " " : "";
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = notEmptyBoth = !CMCL.isEmpty(latestGameVersion) && !CMCL.isEmpty(latestFileName);
        if (!CMCL.isEmpty(latestGameVersion) || !CMCL.isEmpty(latestFileName)) {
            stringBuilder.append("(");
        }
        if (!CMCL.isEmpty(latestGameVersion)) {
            stringBuilder.append(latestGameVersion);
        }
        if (notEmptyBoth) {
            stringBuilder.append(", ");
        }
        if (!CMCL.isEmpty(latestFileName)) {
            stringBuilder.append(latestFileName);
        }
        if (!CMCL.isEmpty(latestGameVersion) || !CMCL.isEmpty(latestFileName)) {
            stringBuilder.append(")");
        }
        String gameVersionAndFileName = stringBuilder.toString();
        System.out.println(Ansi.ansi().fg(Ansi.Color.CYAN).a(order) + " " + Ansi.ansi().fg(Ansi.Color.GREEN).a(name) + Ansi.ansi().fg(Ansi.Color.WHITE).a(" ") + author + (!Utils.isEmpty(gameVersionAndFileName) ? Ansi.ansi().fg(Ansi.Color.WHITE).a(gameVersionAndFileName) : ""));
        AnsiConsole.systemUninstall();
        if (!Utils.isEmpty(summary)) {
            System.out.println("    " + summary);
        }
    }

    private static String getAuthor(JSONArray authors) {
        if (authors == null || authors.length() == 0) {
            return null;
        }
        String first = null;
        int count = 0;
        for (int i = 0; i < authors.length(); ++i) {
            String name;
            JSONObject jsonObject = authors.optJSONObject(i);
            if (jsonObject == null || CMCL.isEmpty(name = jsonObject.optString("name"))) continue;
            if (i == 0) {
                first = name;
                continue;
            }
            ++count;
        }
        if (first == null) {
            return null;
        }
        return count == 0 ? Ansi.ansi().fg(Ansi.Color.RED).a(first).toString() : Ansi.ansi().fg(Ansi.Color.RED).a(first) + " " + Ansi.ansi().fg(Ansi.Color.WHITE).a(CMCL.getString("CF_AUTHOR_MORE", count));
    }

    public JSONObject getByID(String modId) throws NotMinecraftAddon, IncorrectCategoryAddon, IOException {
        JSONObject mod = new JSONObject(NetworkUtils.curseForgeGet(GET_ADDON_INFORMATION + modId)).optJSONObject("data");
        int gameId = mod.optInt("gameId");
        if (gameId != 432) {
            throw new NotMinecraftAddon(gameId);
        }
        int a = mod.optInt("classId");
        if (a != this.getSection().sectionId) {
            throw new IncorrectCategoryAddon(a);
        }
        return mod;
    }

    private static void addonFilesTimeSort(List<JSONObject> list) {
        list.sort((o1, o2) -> {
            try {
                Date dt1 = TIME_FORMAT.parse(o1.optString("fileDate"));
                Date dt2 = TIME_FORMAT.parse(o2.optString("fileDate"));
                return Long.compare(dt2.getTime(), dt1.getTime());
            }
            catch (Exception exception) {
                return 0;
            }
        });
    }

    public void printInformation(JSONObject mod, String modName) {
        JSONObject links;
        String dateReleased;
        String dateCreated;
        String dateModified;
        int downloadCount;
        List<JSONObject> gameVersionLatestFilesList;
        JSONArray authorsJSONArray;
        String url;
        JSONObject logo;
        String summary;
        String id;
        LinkedHashMap<String, String> information = new LinkedHashMap<String, String>();
        if (!CMCL.isEmpty(modName)) {
            information.put(this.getSection().informationNameTip, modName);
        }
        if (!CMCL.isEmpty(id = mod.optString("id"))) {
            information.put(this.getSection().informationIdTip, id);
        }
        if (!CMCL.isEmpty(summary = mod.optString("summary"))) {
            information.put(CMCL.getString("CF_INFORMATION_SUMMARY"), summary);
        }
        if ((logo = mod.optJSONObject("logo")) != null && !CMCL.isEmpty(url = logo.optString("url"))) {
            information.put(CMCL.getString("CF_INFORMATION_ICON"), url);
        }
        if ((authorsJSONArray = mod.optJSONArray("authors")) != null && authorsJSONArray.length() > 0) {
            StringBuilder author = new StringBuilder();
            List<JSONObject> authors = JSONUtils.jsonArrayToJSONObjectList(authorsJSONArray);
            for (JSONObject jsonObject : authors) {
                String name = jsonObject.optString("name");
                if (CMCL.isEmpty(name)) continue;
                author.append("\n      ").append(name).append('\n');
                String url2 = jsonObject.optString("url");
                if (CMCL.isEmpty(url2)) continue;
                author.append(CMCL.getString("CF_INFORMATION_AUTHOR_URL")).append(url2);
            }
            information.put(CMCL.getString("CF_INFORMATION_AUTHORS"), author.toString());
        }
        if ((gameVersionLatestFilesList = JSONUtils.jsonArrayToJSONObjectList(mod.optJSONArray("latestFilesIndexes"))).size() > 0) {
            List list = gameVersionLatestFilesList.stream().map(a -> a.optString("gameVersion")).sorted(VersionUtils.VERSION_COMPARATOR).collect(Collectors.toList());
            information.put(CMCL.getString("CF_INFORMATION_LATEST_GAME_VERSION"), (String)list.get(list.size() - 1));
        }
        if ((downloadCount = mod.optInt("downloadCount", -1)) >= 0) {
            information.put(CMCL.getString("CF_INFORMATION_DOWNLOAD_COUNT"), Integer.toString(downloadCount));
        }
        if (!Utils.isEmpty(dateModified = mod.optString("dateModified")) && dateModified.length() >= 19) {
            String dateString = CurseForgeManager.parseDate(dateModified);
            information.put(CMCL.getString("CF_INFORMATION_DATE_MODIFIED"), dateString);
        }
        if (!Utils.isEmpty(dateCreated = mod.optString("dateCreated")) && dateCreated.length() >= 19) {
            String dateString = CurseForgeManager.parseDate(dateCreated);
            information.put(CMCL.getString("CF_INFORMATION_DATE_CREATED"), dateString);
        }
        if (!Utils.isEmpty(dateReleased = mod.optString("dateReleased")) && dateReleased.length() >= 19) {
            String dateString = CurseForgeManager.parseDate(dateReleased);
            information.put(CMCL.getString("CF_INFORMATION_DATE_RELEASED"), dateString);
        }
        if ((links = mod.optJSONObject("links")) != null) {
            String wikiUrl;
            String websiteUrl;
            String sourceUrl;
            String issueTrackerUrl = links.optString("issuesUrl");
            if (!CMCL.isEmpty(issueTrackerUrl)) {
                information.put(CMCL.getString("CF_INFORMATION_ISSUE_TRACKER_URL"), issueTrackerUrl);
            }
            if (!CMCL.isEmpty(sourceUrl = links.optString("sourceUrl"))) {
                information.put(CMCL.getString("CF_INFORMATION_SOURCE_URL"), sourceUrl);
            }
            if (!CMCL.isEmpty(websiteUrl = links.optString("websiteUrl"))) {
                information.put(CMCL.getString("CF_INFORMATION_WEBSITE_URL"), websiteUrl);
            }
            if (!CMCL.isEmpty(wikiUrl = links.optString("wikiUrl"))) {
                information.put(CMCL.getString("CF_INFORMATION_WIKI_URL"), wikiUrl);
            }
        }
        if (information.size() == 0) {
            System.out.println(CMCL.getString("CF_INFORMATION_NOTHING", this.getNameAllLowerCase()));
        } else {
            System.out.println(modName + ":");
            for (Map.Entry entry : information.entrySet()) {
                System.out.print((String)entry.getKey());
                System.out.println((String)entry.getValue());
            }
        }
    }

    public static String parseDate(String sourceDate) {
        String dateString;
        try {
            Date date = TIME_FORMAT.parse(sourceDate.substring(0, 19) + "+0000");
            SimpleDateFormat format = new SimpleDateFormat(CMCL.getString("TIME_FORMAT"), CMCL.getLocale());
            dateString = format.format(date) + " (" + TimeZone.getDefault().getDisplayName() + ")";
        }
        catch (Exception e) {
            dateString = CMCL.getString("EXCEPTION_UNABLE_PARSE");
        }
        return dateString;
    }

    public static class IncorrectCategoryAddon
    extends Exception {
        public int gameCategoryId;

        public IncorrectCategoryAddon(int gameCategoryId) {
            this.gameCategoryId = gameCategoryId;
        }

        public IncorrectCategoryAddon(String message) {
            super(message);
        }

        public IncorrectCategoryAddon(String message, Throwable cause) {
            super(message, cause);
        }

        public IncorrectCategoryAddon(Throwable cause) {
            super(cause);
        }
    }

    public static class NotMinecraftAddon
    extends Exception {
        public int gameId;

        public NotMinecraftAddon(int gameId) {
            this.gameId = gameId;
        }

        public NotMinecraftAddon(String message) {
            super(message);
        }

        public NotMinecraftAddon(String message, Throwable cause) {
            super(message, cause);
        }

        public NotMinecraftAddon(Throwable cause) {
            super(cause);
        }
    }
}

