/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modSources.modrinth;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.enums.ModrinthSection;
import com.mrshiehx.cmcl.modSources.Manager;
import com.mrshiehx.cmcl.modSources.curseforge.CurseForgeManager;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class ModrinthManager
extends Manager<ModrinthSection> {
    private static final String ROOT = "https://api.modrinth.com/v2/";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public abstract ModrinthSection getSection();

    @Override
    public JSONObject search(String searchContent, int limit) {
        JSONArray searchResult;
        try {
            JSONObject jsonObject = new JSONObject(NetworkUtils.get("https://api.modrinth.com/v2/search?query=" + URLEncoder.encode(searchContent, StandardCharsets.UTF_8.name()) + "&limit=" + (limit < 0 ? 50 : limit) + "&facets=" + URLEncoder.encode("[[\"project_type:" + this.getSection().projectType + "\"]]", StandardCharsets.UTF_8.name())));
            searchResult = jsonObject.optJSONArray("hits");
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("MESSAGE_FAILED_SEARCH", e));
            return null;
        }
        List<JSONObject> list = JSONUtils.jsonArrayToJSONObjectList(searchResult);
        if (list.size() == 0) {
            System.out.println(CMCL.getString("NO_SEARCH_RESULTS"));
            return null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            try {
                JSONObject result = list.get(i);
                if (result == null) continue;
                String gameVersion = null;
                JSONArray versions = result.optJSONArray("versions");
                if (versions != null && versions.length() > 0) {
                    LinkedList<String> list2 = new LinkedList<String>();
                    for (Object o : versions.toList()) {
                        if (!(o instanceof String)) continue;
                        list2.add((String)o);
                    }
                    list2.sort((o1, o2) -> -VersionUtils.tryToCompareVersion(o1, o2));
                    if (list2.size() > 0) {
                        gameVersion = (String)list2.get(0);
                    }
                }
                CurseForgeManager.printOne(i + 1, result.optString("title"), result.optString("description"), Ansi.ansi().fg(Ansi.Color.RED).a(result.optString("author")).toString(), gameVersion, null);
                continue;
            }
            catch (Exception e) {
                System.out.println(CMCL.getString("CF_FAILED_TO_SHOW_SOMEONE", i + 1, e).replace("${NAME}", this.getSection().nameAllLowerCase));
            }
        }
        int number = InteractionUtils.inputInt(Utils.getString("CF_SELECT_TARGET", 1, list.size()).replace("${NAME}", this.getSection().nameAllLowerCase), 1, list.size());
        if (number != Integer.MAX_VALUE) {
            return list.get(number - 1);
        }
        return null;
    }

    public void printInformation(@Nullable JSONObject bySearch, JSONObject byID, @Nullable String modName, @Nullable String modId) {
        String dateString;
        List list;
        JSONArray categories;
        String a;
        LinkedHashMap<String, String> information = new LinkedHashMap<String, String>();
        String id = modId;
        String description = null;
        String author = null;
        String dateModified = null;
        String dateCreated = null;
        String iconUrl = null;
        JSONArray gameVersions = null;
        int downloads = -1;
        HashSet<String> categories1 = new HashSet<String>();
        LinkedList<Pair<String, String>> donations = new LinkedList<Pair<String, String>>();
        if (bySearch != null) {
            id = bySearch.optString("project_id", modId);
            description = bySearch.optString("description");
            author = bySearch.optString("author");
            dateModified = bySearch.optString("date_modified");
            dateCreated = bySearch.optString("date_created");
            iconUrl = bySearch.optString("icon_url");
            gameVersions = bySearch.optJSONArray("versions");
            a = bySearch.optString("title");
            if (!CMCL.isEmpty(a)) {
                modName = a;
            }
            downloads = bySearch.optInt("downloads", -1);
            categories = bySearch.optJSONArray("categories");
            if (categories != null && categories.length() > 0) {
                for (Object object : categories) {
                    if (!(object instanceof String)) continue;
                    categories1.add((String)object);
                }
            }
        }
        if (byID != null) {
            Object donation_urls;
            if (CMCL.isEmpty(description)) {
                description = byID.optString("description");
            }
            if (CMCL.isEmpty(dateModified)) {
                dateModified = byID.optString("updated");
            }
            if (CMCL.isEmpty(dateCreated)) {
                dateCreated = byID.optString("published");
            }
            if (CMCL.isEmpty(id)) {
                id = byID.optString("id");
            }
            if (downloads < 0) {
                downloads = byID.optInt("downloads", -1);
            }
            if (CMCL.isEmpty(modName)) {
                modName = byID.optString("title");
            }
            if (CMCL.isEmpty(iconUrl)) {
                iconUrl = byID.optString("icon_url");
            }
            if (gameVersions == null) {
                gameVersions = byID.optJSONArray("game_versions");
            }
            if (!CMCL.isEmpty(a = byID.optString("title"))) {
                modName = a;
            }
            if ((categories = byID.optJSONArray("categories")) != null && categories.length() > 0) {
                for (Object object : categories) {
                    if (!(object instanceof String)) continue;
                    categories1.add((String)object);
                }
            }
            if ((donation_urls = byID.optJSONArray("donation_urls")) != null && ((JSONArray)donation_urls).length() > 0) {
                Iterator<Object> iterator = ((JSONArray)donation_urls).iterator();
                while (iterator.hasNext()) {
                    Object o2 = iterator.next();
                    if (!(o2 instanceof JSONObject)) continue;
                    String platform = ((JSONObject)o2).optString("platform");
                    String url = ((JSONObject)o2).optString("url");
                    if (CMCL.isEmpty(platform) || CMCL.isEmpty(url)) continue;
                    donations.add(new Pair<String, String>(platform, url));
                }
            }
        }
        if (!CMCL.isEmpty(modName)) {
            information.put(this.getSection().informationNameTip, modName);
        }
        if (!CMCL.isEmpty(id)) {
            information.put(this.getSection().informationIdTip, id);
        }
        if (!CMCL.isEmpty(description)) {
            information.put(CMCL.getString("CF_INFORMATION_SUMMARY"), description);
        }
        if (!CMCL.isEmpty(iconUrl)) {
            information.put(CMCL.getString("CF_INFORMATION_ICON"), iconUrl);
        }
        if (!CMCL.isEmpty(author)) {
            information.put(CMCL.getString("CF_INFORMATION_AUTHOR"), author);
        }
        String latestGameVersion = null;
        if (gameVersions != null && !(list = gameVersions.toList().stream().map(String::valueOf).sorted(VersionUtils.VERSION_COMPARATOR).collect(Collectors.toList())).isEmpty()) {
            latestGameVersion = (String)list.get(list.size() - 1);
        }
        if (CMCL.isEmpty(latestGameVersion) && bySearch != null) {
            latestGameVersion = bySearch.optString("latest_version");
        }
        if (!CMCL.isEmpty(latestGameVersion)) {
            information.put(CMCL.getString("CF_INFORMATION_LATEST_GAME_VERSION"), latestGameVersion);
        }
        if (categories1.size() > 0) {
            information.put(CMCL.getString("CF_INFORMATION_CATEGORIES"), Arrays.toString(categories1.toArray()));
        }
        if (!Utils.isEmpty(dateModified) && dateModified.length() >= 19) {
            dateString = CurseForgeManager.parseDate(dateModified);
            information.put(CMCL.getString("CF_INFORMATION_DATE_MODIFIED"), dateString);
        }
        if (!Utils.isEmpty(dateCreated) && dateCreated.length() >= 19) {
            dateString = CurseForgeManager.parseDate(dateCreated);
            information.put(CMCL.getString("CF_INFORMATION_DATE_CREATED"), dateString);
        }
        if (downloads >= 0) {
            information.put(CMCL.getString("CF_INFORMATION_DOWNLOAD_COUNT"), String.valueOf(downloads));
        }
        if (donations.size() > 0) {
            StringBuilder donation = new StringBuilder();
            for (Pair pair : donations) {
                String name = (String)pair.getKey();
                donation.append('\n').append("      ").append(name).append('\n');
                String url = (String)pair.getValue();
                donation.append(CMCL.getString("CF_INFORMATION_DONATION_URL")).append(url);
            }
            information.put(CMCL.getString("CF_INFORMATION_DONATION"), donation.toString());
        }
        if (byID != null) {
            String discordUrl;
            String wikiUrl;
            String string;
            String sourceUrl;
            String issueTrackerUrl = byID.optString("issues_url");
            if (!CMCL.isEmpty(issueTrackerUrl)) {
                information.put(CMCL.getString("CF_INFORMATION_ISSUE_TRACKER_URL"), issueTrackerUrl);
            }
            if (!CMCL.isEmpty(sourceUrl = byID.optString("source_url"))) {
                information.put(CMCL.getString("CF_INFORMATION_SOURCE_URL"), sourceUrl);
            }
            if (!CMCL.isEmpty(string = byID.optString("body_url"))) {
                information.put(CMCL.getString("CF_INFORMATION_WEBSITE_URL"), string);
            }
            if (!CMCL.isEmpty(wikiUrl = byID.optString("wiki_url"))) {
                information.put(CMCL.getString("CF_INFORMATION_WIKI_URL"), wikiUrl);
            }
            if (!CMCL.isEmpty(discordUrl = byID.optString("discord_url"))) {
                information.put(CMCL.getString("CF_INFORMATION_DISCORD_URL"), discordUrl);
            }
        }
        if (information.size() == 0) {
            System.out.println(CMCL.getString("CF_INFORMATION_NOTHING", this.getSection().nameAllLowerCase));
        } else {
            System.out.println(modName + ":");
            for (Map.Entry entry : information.entrySet()) {
                System.out.print((String)entry.getKey());
                System.out.println((String)entry.getValue());
            }
        }
    }

    public JSONObject getByID(String id) throws IncorrectCategoryAddon, IOException {
        JSONObject mod = new JSONObject(NetworkUtils.get("https://api.modrinth.com/v2/project/" + id));
        ModrinthSection a = ModrinthSection.xvalueOf(mod.optString("project_type"));
        if (a != this.getSection()) {
            throw new IncorrectCategoryAddon(a);
        }
        return mod;
    }

    @Override
    public String getDownloadLink(String modID, String modName, @Nullable String mcversion, @Nullable String addonVersion, boolean isModpack, Manager.DependencyInstaller dependencyInstaller) {
        JSONArray jsonArray;
        List matches;
        String modSupportMinecraftVersion;
        JSONArray modAllVersionsJsonArrayFather;
        try {
            modAllVersionsJsonArrayFather = new JSONArray(NetworkUtils.get("https://api.modrinth.com/v2/project/" + modID + "/version"));
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("MOD_FAILED_TO_GET_ALL_FILES", e).replace("${NAME}", this.getNameAllLowerCase()));
            return null;
        }
        HashMap<String, Object> modClassificationMap = new HashMap<String, Object>();
        for (int i = 0; i < modAllVersionsJsonArrayFather.length(); ++i) {
            JSONObject modVersion = modAllVersionsJsonArrayFather.optJSONObject(i);
            if (modVersion == null) continue;
            JSONArray gameVersion = modVersion.optJSONArray("game_versions");
            for (int j = 0; j < gameVersion.length(); ++j) {
                String ver = gameVersion.optString(j);
                ArrayList oneMcVerOfModSupport = modClassificationMap.containsKey(ver) ? (ArrayList)modClassificationMap.get(ver) : new ArrayList();
                modVersion.put("date_published", modVersion.optString("date_published").substring(0, 19));
                JSONArray files = modVersion.optJSONArray("files");
                if (files != null) {
                    for (Object object : files) {
                        if (!(object instanceof JSONObject)) continue;
                        if (files.length() == 1) {
                            oneMcVerOfModSupport.add(new Pair<JSONObject, JSONObject>((JSONObject)object, modVersion));
                            continue;
                        }
                        String url = ((JSONObject)object).optString("url");
                        String filename = ((JSONObject)object).optString("filename");
                        if (CMCL.isEmpty(url) || CMCL.isEmpty(filename) || filename.endsWith("-sources-dev.jar") || filename.endsWith("-sources.jar")) continue;
                        oneMcVerOfModSupport.add(new Pair<JSONObject, JSONObject>((JSONObject)object, modVersion));
                    }
                }
                ModrinthManager.addonFilesTimeSort(oneMcVerOfModSupport);
                modClassificationMap.put(ver, oneMcVerOfModSupport);
            }
        }
        if (!CMCL.isEmpty(mcversion) && modClassificationMap.get(mcversion) != null) {
            modSupportMinecraftVersion = mcversion;
        } else {
            ArrayList<String> modSupportedMcVer = new ArrayList<String>(modClassificationMap.keySet());
            modSupportedMcVer.sort(VersionUtils.VERSION_COMPARATOR);
            if (CMCL.isEmpty(modName)) {
                try {
                    modName = this.getByID(modID).optString("title");
                }
                catch (Exception gameVersion) {
                    // empty catch block
                }
            }
            System.out.println(CMCL.getString("CF_SUPPORTED_GAME_VERSION", modName));
            PrintingUtils.printListItems(modSupportedMcVer, false, 6, 3, true);
            modSupportMinecraftVersion = InteractionUtils.inputStringInFilter(CMCL.getString("CF_INPUT_GAME_VERSION"), CMCL.getString("CONSOLE_INPUT_STRING_NOT_FOUND"), modSupportedMcVer::contains);
        }
        List versions = (List)modClassificationMap.get(modSupportMinecraftVersion);
        if (versions == null) {
            return null;
        }
        if (versions.size() == 0) {
            System.out.println(CMCL.getString("CF_NO_VERSION_FOR_GAME_VERSION", this.getNameAllLowerCase()));
            return null;
        }
        Pair targetFile = null;
        if (!CMCL.isEmpty(addonVersion) && (matches = versions.stream().filter(pair -> {
            String version_number = ((JSONObject)pair.getValue()).optString("version_number");
            return version_number.contains(addonVersion);
        }).collect(Collectors.toList())).size() == 1) {
            targetFile = (Pair)matches.get(0);
        }
        if (targetFile == null) {
            AnsiConsole.systemInstall();
            for (int i = versions.size() - 1; i >= 0; --i) {
                System.out.print(Ansi.ansi().fg(Ansi.Color.WHITE).a("[") + "" + Ansi.ansi().fg(Ansi.Color.CYAN).a(i + 1) + Ansi.ansi().fg(Ansi.Color.WHITE).a("]" + ((JSONObject)((Pair)versions.get(i)).getKey()).optString("filename") + "\n"));
            }
            AnsiConsole.systemUninstall();
            int modVersionOfSingleMcVersion = InteractionUtils.inputInt(CMCL.getString("CF_INPUT_VERSION", 1, versions.size()).replace("${NAME}", this.getNameAllLowerCase()), 1, versions.size(), true, -1);
            if (modVersionOfSingleMcVersion == Integer.MAX_VALUE || modVersionOfSingleMcVersion == -1) {
                return null;
            }
            targetFile = (Pair)versions.get(modVersionOfSingleMcVersion - 1);
        }
        if (!isModpack && (jsonArray = ((JSONObject)targetFile.getValue()).optJSONArray("dependencies")) != null && jsonArray.length() > 0) {
            HashMap<String, String> list = new HashMap<String, String>();
            for (Object object : jsonArray) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)object;
                String dmodid = jsonObject.optString("project_id");
                String name = null;
                try {
                    JSONObject head = this.getByID(dmodid);
                    name = head.optString("title");
                }
                catch (Exception head) {
                    // empty catch block
                }
                if (CMCL.isEmpty(dmodid)) continue;
                list.put(dmodid, name);
            }
            if (list.size() > 0) {
                System.out.println();
                System.out.println(CMCL.getString("CF_DEPENDENCIES_TIP").replace("${NAME}", this.getNameAllLowerCase()));
                int i = 0;
                for (Map.Entry entry : list.entrySet()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String id = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    stringBuilder.append(CMCL.getString("CF_DEPENDENCY_INFORMATION_ID_STRING", id)).append('\n');
                    if (!CMCL.isEmpty(name)) {
                        stringBuilder.append(CMCL.getString("CF_DEPENDENCY_INFORMATION_NAME", name)).append('\n');
                    }
                    System.out.println(stringBuilder);
                    ++i;
                }
                System.out.println();
                for (Map.Entry entry : list.entrySet()) {
                    dependencyInstaller.install(modSupportMinecraftVersion, (String)entry.getValue(), (String)entry.getKey());
                }
            }
        }
        return ((JSONObject)targetFile.getKey()).optString("url");
    }

    @Override
    protected String getNameAllLowerCase() {
        return this.getSection().nameAllLowerCase;
    }

    private static void addonFilesTimeSort(ArrayList<Pair<JSONObject, JSONObject>> list) {
        list.sort((o1, o2) -> {
            try {
                Date dt1 = TIME_FORMAT.parse(((JSONObject)o1.getKey()).optString("date_published"));
                Date dt2 = TIME_FORMAT.parse(((JSONObject)o2.getKey()).optString("date_published"));
                return Long.compare(dt2.getTime(), dt1.getTime());
            }
            catch (Exception exception) {
                return 0;
            }
        });
    }

    public static class IncorrectCategoryAddon
    extends Exception {
        public ModrinthSection section;

        public IncorrectCategoryAddon(ModrinthSection section) {
            this.section = section;
        }

        public IncorrectCategoryAddon(String message) {
            super(message);
        }

        public IncorrectCategoryAddon(String message, Throwable cause) {
            super(message, cause);
        }

        public IncorrectCategoryAddon(Throwable cause) {
            super(cause);
        }
    }
}

