/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Library;
import com.mrshiehx.cmcl.bean.SplitLibraryName;
import com.mrshiehx.cmcl.bean.ThreeReturns;
import com.mrshiehx.cmcl.bean.arguments.Argument;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.bean.arguments.ValueArgument;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.EmptyNativesException;
import com.mrshiehx.cmcl.exceptions.InvalidJavaException;
import com.mrshiehx.cmcl.exceptions.LaunchException;
import com.mrshiehx.cmcl.exceptions.LibraryDefectException;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorInformation;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.nide8auth.Nide8AuthAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.nide8auth.Nide8AuthInformation;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionLibraryUtils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.CommandUtils;
import com.mrshiehx.cmcl.utils.system.JavaUtils;
import com.mrshiehx.cmcl.utils.system.OperatingSystem;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MinecraftLauncher {
    public static List<String> getMinecraftLaunchCommandArguments(File minecraftJarFile, File minecraftVersionJsonFile, File gameDir, File assetsDir, File resourcePacksDir, String playerName, String javaPath, long maxMemory, int miniMemory, int width, int height, boolean fullscreen, String accessToken, String uuid, boolean isDemo, boolean customScreenSize, JSONObject properties, @Nullable Void startLaunch, @Nullable List<String> jvmArgs, @Nullable Map<String, String> gameArgs, @Nullable AuthlibInjectorInformation authlibInjectorInformation, @Nullable Nide8AuthInformation nide8AuthInformation, @Nullable String quickPlayLogFilePath, @Nullable String quickPlaySaveName, @Nullable String quickPlayServerAddress, @Nullable String quickPlayRealmsID) throws LibraryDefectException, EmptyNativesException, LaunchException, IOException, JSONException {
        String args;
        int majorVersion;
        JSONObject headJsonObject;
        long physicalTotal;
        try {
            javaPath = MinecraftLauncher.getRealJavaPath(javaPath);
        }
        catch (InvalidJavaException e) {
            throw new LaunchException(e.getMessage());
        }
        if (null == gameDir) {
            gameDir = new File(".minecraft");
        }
        if (null == assetsDir) {
            assetsDir = new File(gameDir, "assets");
        }
        if (null == resourcePacksDir) {
            resourcePacksDir = new File(gameDir, "resourcepacks");
        }
        if (!gameDir.exists()) {
            gameDir.mkdirs();
        }
        if (maxMemory <= 0L) {
            throw new LaunchException(CMCL.getString("EXCEPTION_MAX_MEMORY_MUST_BE_GREATER_THAN_ZERO"));
        }
        if (width <= 0 || height <= 0) {
            throw new LaunchException(CMCL.getString("EXCEPTION_WINDOW_SIZE_MUST_BE_GREATER_THAN_ZERO"));
        }
        if (!assetsDir.exists()) {
            assetsDir.mkdirs();
        }
        if (!resourcePacksDir.exists()) {
            resourcePacksDir.mkdirs();
        }
        if (maxMemory > (physicalTotal = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 0x100000L)) {
            throw new LaunchException(CMCL.getString("EXCEPTION_MAX_MEMORY_TOO_BIG"));
        }
        if (!minecraftVersionJsonFile.exists()) {
            throw new LaunchException(CMCL.getString("EXCEPTION_VERSION_JSON_NOT_FOUND"));
        }
        String contentOfJsonFile = FileUtils.readFileContent(minecraftVersionJsonFile);
        File authlibFile = null;
        if (authlibInjectorInformation != null && authlibInjectorInformation.isEmpty()) {
            authlibInjectorInformation = null;
        }
        if (authlibInjectorInformation != null) {
            try {
                authlibFile = AuthlibInjectorAuthentication.getAuthlibInjectorFile();
            }
            catch (Exception e) {
                if (Constants.isDebug()) {
                    e.printStackTrace();
                }
                Utils.printflnErr(CMCL.getString("UNAVAILABLE_AUTHLIB_ACCOUNT_REASON"), e);
                Utils.printflnErr(authlibInjectorInformation.forOfflineSkin ? CMCL.getString("UNAVAILABLE_CUSTOM_SKIN") : CMCL.getString("UNAVAILABLE_AUTHLIB_ACCOUNT"), new Object[0]);
                authlibInjectorInformation = null;
            }
        }
        if (authlibInjectorInformation != null) {
            if (!Utils.isEmpty(authlibInjectorInformation.uuid)) {
                uuid = authlibInjectorInformation.uuid;
            }
            if (!Utils.isEmpty(authlibInjectorInformation.token)) {
                accessToken = authlibInjectorInformation.token;
            }
        }
        File nide8authFile = null;
        if (nide8AuthInformation != null) {
            try {
                nide8authFile = Nide8AuthAuthentication.getNide8AuthFile();
            }
            catch (Exception e) {
                if (Constants.isDebug()) {
                    e.printStackTrace();
                }
                Utils.printflnErr(CMCL.getString("UNAVAILABLE_NIDE8AUTH_ACCOUNT_REASON"), e);
                Utils.printflnErr(CMCL.getString("UNAVAILABLE_NIDE8AUTH_ACCOUNT"), new Object[0]);
                nide8AuthInformation = null;
            }
        }
        if (startLaunch != null) {
            startLaunch.execute();
        }
        if (!CMCL.isEmpty((headJsonObject = new JSONObject(contentOfJsonFile)).optString("inheritsFrom"))) {
            throw new LaunchException(CMCL.getString("EXCEPTION_INCOMPLETE_VERSION"));
        }
        if (!minecraftJarFile.exists()) {
            throw new LaunchException(CMCL.getString("EXCEPTION_VERSION_JAR_NOT_FOUND"));
        }
        JSONObject javaVersionJO = headJsonObject.optJSONObject("javaVersion");
        int javaVersionInt = JavaUtils.getJavaVersion(javaPath);
        if (javaVersionInt > -1 && javaVersionJO != null && (majorVersion = javaVersionJO.optInt("majorVersion", -1)) != -1 && javaVersionInt < majorVersion) {
            throw new LaunchException(String.format(CMCL.getString("EXCEPTION_JAVA_VERSION_TOO_LOW"), majorVersion, javaVersionInt));
        }
        if (nide8AuthInformation != null) {
            String originalJavaVersion;
            if (javaVersionInt < 8) {
                throw new LaunchException(CMCL.getString("EXCEPTION_NIDE8AUTH_JAVA_VERSION_TOO_LOW"));
            }
            if (javaVersionInt == 8 && !CMCL.isEmpty(originalJavaVersion = JavaUtils.getOriginalJavaVersion(javaPath)) && originalJavaVersion.contains("_")) {
                try {
                    int subVer = Integer.parseInt(originalJavaVersion.split("_")[1]);
                    if (subVer < 101) {
                        throw new LaunchException(CMCL.getString("EXCEPTION_NIDE8AUTH_JAVA_VERSION_TOO_LOW"));
                    }
                }
                catch (NumberFormatException subVer) {
                    // empty catch block
                }
            }
        }
        LinkedList<String> arguments = new LinkedList<String>();
        LinkedList<String> minecraftArguments = new LinkedList<String>();
        LinkedList<String> jvmArguments = new LinkedList<String>();
        JSONObject assetIndexObject = headJsonObject.optJSONObject("assetIndex");
        String assetsIndex = assetIndexObject.optString("id");
        HashMap<String, Boolean> featuresProvided = new HashMap<String, Boolean>();
        featuresProvided.put("is_demo_user", isDemo);
        featuresProvided.put("has_custom_resolution", customScreenSize);
        featuresProvided.put("has_quick_plays_support", !CMCL.isEmpty(quickPlayLogFilePath));
        featuresProvided.put("is_quick_play_singleplayer", !CMCL.isEmpty(quickPlaySaveName));
        featuresProvided.put("is_quick_play_multiplayer", !CMCL.isEmpty(quickPlayServerAddress));
        featuresProvided.put("is_quick_play_realms", !CMCL.isEmpty(quickPlayRealmsID));
        if (headJsonObject.optJSONObject("arguments") != null) {
            MinecraftLauncher.getGameArguments(headJsonObject, featuresProvided, minecraftArguments);
            MinecraftLauncher.getJavaVirtualMachineArguments(headJsonObject, featuresProvided, jvmArguments);
        }
        if (!Utils.isEmpty(args = headJsonObject.optString("minecraftArguments"))) {
            List<String> argus = CommandUtils.splitCommand(CommandUtils.clearRedundantSpaces(args));
            minecraftArguments.addAll(argus);
        }
        Arguments a = Arguments.valueOf(minecraftArguments, false).removeDuplicate();
        LinkedList<Argument> arguments1 = new LinkedList<Argument>(a.getArguments());
        arguments1.sort((o1, o2) -> {
            if ("tweakClass".equals(o1.key) && !"tweakClass".equals(o2.key)) {
                return -1;
            }
            if (!"tweakClass".equals(o1.key) && "tweakClass".equals(o2.key)) {
                return 1;
            }
            if (!"tweakClass".equals(o1.key)) {
                return 0;
            }
            if (o1 instanceof ValueArgument && o2 instanceof ValueArgument) {
                String o1s = ((ValueArgument)o1).value;
                String o2s = ((ValueArgument)o2).value;
                String f1 = "net.minecraftforge.legacy._1_5_2.LibraryFixerTweaker";
                String f2 = "cpw.mods.fml.common.launcher.FMLTweaker";
                String f3 = "net.minecraftforge.fml.common.launcher.FMLTweaker";
                if (o1s.equals(f1) || o1s.equals(f2) || o1s.equals(f3)) {
                    return -1;
                }
                if (o2s.equals(f1) || o2s.equals(f2) || o2s.equals(f3)) {
                    return 1;
                }
                return 0;
            }
            return 0;
        });
        minecraftArguments.clear();
        for (Argument argument : arguments1) {
            minecraftArguments.add("--" + argument.key);
            if (!(argument instanceof ValueArgument)) continue;
            minecraftArguments.add(((ValueArgument)argument).value);
        }
        boolean hasThree = false;
        int hasOFT = -1;
        boolean hasOFTorOFFT = false;
        int size = minecraftArguments.size();
        for (int i = 0; i < size; ++i) {
            String argument = (String)minecraftArguments.get(i);
            if (!"-tweakClass".equals(argument) && !"--tweakClass".equals(argument) && !"/tweakClass".equals(argument) || i + 1 >= size) continue;
            String tweakClass = (String)minecraftArguments.get(i + 1);
            boolean aa = "optifine.OptiFineTweaker".equals(tweakClass);
            if (aa) {
                hasOFT = i + 1;
            }
            if ((aa || "OptiFineForgeTweaker.OptiFineTweaker".equals(tweakClass)) & !hasOFTorOFFT) {
                hasOFTorOFFT = true;
            }
            if ("com.mumfrey.liteloader.launch.LiteLoaderTweaker".equals(tweakClass) || "net.minecraftforge.fml.common.launcher.FMLTweaker".equals(tweakClass) || "cpw.mods.fml.common.launcher.FMLTweaker".equals(tweakClass) || "net.minecraftforge.legacy._1_5_2.LibraryFixerTweaker".equals(tweakClass)) {
                hasThree = true;
            }
            if (hasOFT >= 0 && hasThree && hasOFTorOFFT) break;
        }
        if (hasOFT >= 0 && hasThree) {
            minecraftArguments.set(hasOFT, "optifine.OptiFineForgeTweaker");
        }
        String mainClass = headJsonObject.optString("mainClass", "net.minecraft.client.main.Main");
        boolean var = hasThree && hasOFTorOFFT && ("net.minecraft.launchwrapper.Launch".equals(mainClass) || "cpw.mods.modlauncher.Launcher".equals(mainClass));
        JSONArray libraries = headJsonObject.optJSONArray("libraries");
        File librariesFile = CMCL.librariesDir;
        ThreeReturns<List<Library>, List<Library>, Boolean> pair = MinecraftLauncher.getLibraries(libraries, var);
        List librariesPaths = (List)pair.first;
        List notFound = (List)pair.second;
        if (notFound.size() > 0) {
            throw new LibraryDefectException(notFound);
        }
        File nativesFolder = VersionUtils.getNativesDir(minecraftVersionJsonFile.getParentFile());
        StringBuilder librariesString = new StringBuilder();
        for (Library library : librariesPaths) {
            librariesString.append(library.localFile.getAbsolutePath()).append(File.pathSeparator);
        }
        librariesString.append(minecraftJarFile.getAbsolutePath());
        String assetsPath = assetsDir.getAbsolutePath();
        if (assetsIndex.equals("legacy")) {
            assetsPath = new File(assetsDir, "virtual/legacy").getAbsolutePath();
        }
        String lastGameDirPath = gameDir.getAbsolutePath();
        for (int i = 0; i < minecraftArguments.size(); ++i) {
            String s = (String)minecraftArguments.get(i);
            String source = "${main_class}";
            if (s.contains("${main_class}")) {
                s = s.replace(source, headJsonObject.optString("mainClass", "net.minecraft.client.main.Main"));
                minecraftArguments.set(i, s);
            }
            source = "${auth_player_name}";
            if (s.contains("${auth_player_name}")) {
                s = s.replace(source, playerName);
                minecraftArguments.set(i, s);
            }
            source = "${version_name}";
            if (s.contains("${version_name}")) {
                s = s.replace(source, headJsonObject.optString("id"));
                minecraftArguments.set(i, s);
            }
            String n = authlibInjectorInformation != null && !authlibInjectorInformation.forOfflineSkin ? String.format("CMCL %s(%s)", "2.2.2", authlibInjectorInformation.serverName) : (nide8AuthInformation != null ? String.format("CMCL %s(%s)", "2.2.2", nide8AuthInformation.serverName) : "CMCL 2.2.2");
            source = "${version_type}";
            if (s.contains("${version_type}")) {
                s = s.replace(source, n);
                minecraftArguments.set(i, s);
            }
            source = "${profile_name}";
            if (s.contains("${profile_name}")) {
                s = s.replace(source, n);
                minecraftArguments.set(i, s);
            }
            source = "${auth_access_token}";
            if (s.contains("${auth_access_token}")) {
                s = s.replace(source, accessToken);
                minecraftArguments.set(i, s);
            }
            source = "${auth_session}";
            if (s.contains("${auth_session}")) {
                s = s.replace(source, accessToken);
                minecraftArguments.set(i, s);
            }
            source = "${game_directory}";
            if (s.contains("${game_directory}")) {
                s = s.replace(source, lastGameDirPath);
                minecraftArguments.set(i, s);
            }
            source = "${assets_root}";
            if (s.contains("${assets_root}")) {
                s = s.replace(source, assetsDir.getAbsolutePath());
                minecraftArguments.set(i, s);
            }
            source = "${assets_index_name}";
            if (s.contains("${assets_index_name}")) {
                s = s.replace(source, assetsIndex);
                minecraftArguments.set(i, s);
            }
            source = "${auth_uuid}";
            if (s.contains("${auth_uuid}")) {
                s = s.replace(source, CMCL.isEmpty(uuid) ? AccountUtils.getUUIDByName(playerName) : uuid);
                minecraftArguments.set(i, s);
            }
            source = "${user_type}";
            if (s.contains("${user_type}")) {
                s = s.replace(source, "msa");
                minecraftArguments.set(i, s);
            }
            source = "${game_assets}";
            if (s.contains("${game_assets}")) {
                s = s.replace(source, assetsPath);
                minecraftArguments.set(i, s);
            }
            source = "${user_properties}";
            if (s.contains("${user_properties}")) {
                s = s.replace(source, properties != null ? properties.toString() : "{}");
                minecraftArguments.set(i, s);
            }
            source = "${resolution_width}";
            if (s.contains("${resolution_width}")) {
                s = s.replace(source, String.valueOf(width));
                minecraftArguments.set(i, s);
            }
            source = "${resolution_height}";
            if (s.contains("${resolution_height}")) {
                s = s.replace(source, String.valueOf(height));
                minecraftArguments.set(i, s);
            }
            source = "${primary_jar}";
            if (s.contains("${primary_jar}")) {
                s = s.replace(source, minecraftJarFile.getAbsolutePath());
                minecraftArguments.set(i, s);
            }
            source = "${classpath_separator}";
            if (s.contains("${classpath_separator}")) {
                s = s.replace(source, File.pathSeparator);
                minecraftArguments.set(i, s);
            }
            source = "${primary_jar_name}";
            if (s.contains("${primary_jar_name}")) {
                s = s.replace(source, minecraftJarFile.getName());
                minecraftArguments.set(i, s);
            }
            source = "${library_directory}";
            if (s.contains("${library_directory}")) {
                s = s.replace(source, librariesFile.getAbsolutePath());
                minecraftArguments.set(i, s);
            }
            source = "${libraries_directory}";
            if (s.contains("${libraries_directory}")) {
                s = s.replace(source, librariesFile.getAbsolutePath());
                minecraftArguments.set(i, s);
            }
            source = "${language}";
            if (s.contains("${language}")) {
                s = s.replace(source, CMCL.getLocale().toString());
                minecraftArguments.set(i, s);
            }
            source = "${quickPlayPath}";
            if (s.contains("${quickPlayPath}") && !CMCL.isEmpty(quickPlayLogFilePath)) {
                s = s.replace(source, quickPlayLogFilePath);
                minecraftArguments.set(i, s);
            }
            source = "${quickPlaySingleplayer}";
            if (s.contains("${quickPlaySingleplayer}") && !CMCL.isEmpty(quickPlaySaveName)) {
                s = s.replace(source, quickPlaySaveName);
                minecraftArguments.set(i, s);
            }
            source = "${quickPlayMultiplayer}";
            if (s.contains("${quickPlayMultiplayer}") && !CMCL.isEmpty(quickPlayServerAddress)) {
                s = s.replace(source, quickPlayServerAddress);
                minecraftArguments.set(i, s);
            }
            source = "${quickPlayRealms}";
            if (!s.contains("${quickPlayRealms}") || CMCL.isEmpty(quickPlayRealmsID)) continue;
            s = s.replace(source, quickPlayRealmsID);
            minecraftArguments.set(i, s);
        }
        if (resourcePacksDir != null && resourcePacksDir.exists() && !resourcePacksDir.equals(new File(gameDir, "resourcepacks"))) {
            minecraftArguments.add("--resourcePackDir");
            minecraftArguments.add(resourcePacksDir.getAbsolutePath());
        }
        if (fullscreen) {
            minecraftArguments.add("--fullscreen");
        }
        File[] nativesFiles = nativesFolder.listFiles();
        if (((Boolean)pair.third).booleanValue() && (!nativesFolder.exists() || nativesFiles == null || nativesFiles.length == 0)) {
            throw new EmptyNativesException(libraries);
        }
        if (jvmArguments.size() > 0) {
            jvmArguments.add(0, "-Xmn" + miniMemory + "m");
            jvmArguments.add(1, "-Xmx" + maxMemory + "m");
            jvmArguments.add(2, "-Dfile.encoding=UTF-8");
            for (int i = 0; i < jvmArguments.size(); ++i) {
                String s = (String)jvmArguments.get(i);
                String source = "${natives_directory}";
                if (s.contains("${natives_directory}")) {
                    s = s.replace(source, nativesFolder.getAbsolutePath());
                    jvmArguments.set(i, s);
                }
                source = "${launcher_name}";
                if (s.contains("${launcher_name}")) {
                    String launcherName = authlibInjectorInformation != null && !authlibInjectorInformation.forOfflineSkin ? String.format("CMCL(%s)", authlibInjectorInformation.serverName) : (nide8AuthInformation != null ? String.format("CMCL(%s)", nide8AuthInformation.serverName) : "CMCL");
                    s = s.replace(source, launcherName);
                    jvmArguments.set(i, s);
                }
                source = "${launcher_version}";
                if (s.contains("${launcher_version}")) {
                    s = s.replace(source, "2.2.2");
                    jvmArguments.set(i, s);
                }
                source = "${classpath}";
                if (s.contains("${classpath}")) {
                    s = s.replace(source, librariesString.toString());
                    jvmArguments.set(i, s);
                }
                source = "${file_separator}";
                if (s.contains("${file_separator}")) {
                    s = s.replace(source, File.separator);
                    jvmArguments.set(i, s);
                }
                source = "${classpath_separator}";
                if (s.contains("${classpath_separator}")) {
                    s = s.replace(source, File.pathSeparator);
                    jvmArguments.set(i, s);
                }
                source = "${library_directory}";
                if (s.contains("${library_directory}")) {
                    s = s.replace(source, librariesFile.getAbsolutePath());
                    jvmArguments.set(i, s);
                }
                source = "${libraries_directory}";
                if (s.contains("${libraries_directory}")) {
                    s = s.replace(source, librariesFile.getAbsolutePath());
                    jvmArguments.set(i, s);
                }
                source = "${primary_jar_name}";
                if (s.contains("${primary_jar_name}")) {
                    s = s.replace(source, minecraftJarFile.getName());
                    jvmArguments.set(i, s);
                }
                source = "${version_name}";
                if (!s.contains("${version_name}")) continue;
                s = s.replace(source, headJsonObject.optString("id"));
                jvmArguments.set(i, s);
            }
        } else {
            jvmArguments.add("-Xmn" + miniMemory + "m");
            jvmArguments.add("-Xmx" + maxMemory + "m");
            jvmArguments.add("-Dfile.encoding=UTF-8");
            jvmArguments.add("-Djava.library.path=" + nativesFolder.getAbsolutePath());
            jvmArguments.add("-Dminecraft.launcher.brand=CMCL");
            jvmArguments.add("-Dminecraft.launcher.version=2.2.2");
            jvmArguments.add("-cp");
            jvmArguments.add(librariesString.toString());
        }
        int jvmArgusIndex = 3;
        if (authlibInjectorInformation != null) {
            jvmArguments.add(jvmArgusIndex++, "-Dauthlibinjector.side=client");
            jvmArguments.add(jvmArgusIndex++, "-Dauthlibinjector.noShowServerName");
            jvmArguments.add(jvmArgusIndex++, "-javaagent:" + authlibFile.getAbsolutePath() + "=" + authlibInjectorInformation.serverAddress);
            if (!Utils.isEmpty(authlibInjectorInformation.metadataEncoded)) {
                jvmArguments.add(jvmArgusIndex++, "-Dauthlibinjector.yggdrasil.prefetched=" + authlibInjectorInformation.metadataEncoded);
            }
        }
        if (nide8AuthInformation != null) {
            jvmArguments.add(jvmArgusIndex++, "-javaagent:" + nide8authFile.getAbsolutePath() + "=" + nide8AuthInformation.serverId);
            jvmArguments.add(jvmArgusIndex++, "-Dnide8auth.client=true");
        }
        JSONObject config = Utils.getConfig();
        boolean proxyEnabled = config.optBoolean("proxyEnabled");
        String proxyHost = config.optString("proxyHost");
        String proxyPort = config.optString("proxyPort");
        if (proxyEnabled && !Utils.isEmpty(proxyHost) && !Utils.isEmpty(proxyPort) && config.optString("proxyUsername").isEmpty() && config.optString("proxyPassword").isEmpty()) {
            jvmArguments.add(jvmArgusIndex++, "-Dhttp.proxyHost=" + proxyHost);
            jvmArguments.add(jvmArgusIndex++, "-Dhttp.proxyPort=" + proxyPort);
            jvmArguments.add(jvmArgusIndex++, "-Dhttps.proxyHost=" + proxyHost);
            jvmArguments.add(jvmArgusIndex++, "-Dhttps.proxyPort=" + proxyPort);
        }
        LinkedList<String> addableJvmArgs = new LinkedList<String>();
        if (jvmArgs != null && jvmArgs.size() > 0) {
            for (String string : jvmArgs) {
                int n = string.indexOf(61);
                String ab = null;
                if (n >= 0) {
                    ab = string.substring(0, n) + "=";
                }
                boolean contains = false;
                int replace = -1;
                if (!CMCL.isEmpty(ab)) {
                    for (int i = 0; i < jvmArguments.size(); ++i) {
                        String rarg = (String)jvmArguments.get(i);
                        if (!rarg.startsWith(ab)) continue;
                        contains = true;
                        if (n + 1 >= string.length()) break;
                        replace = i;
                        break;
                    }
                } else {
                    for (String rarg : jvmArguments) {
                        if (!rarg.equals(string)) continue;
                        contains = true;
                        break;
                    }
                }
                if (!contains) {
                    addableJvmArgs.add(string);
                    continue;
                }
                if (replace < 0) continue;
                jvmArguments.set(replace, string);
            }
        }
        LinkedList<String> addableGameArgs = new LinkedList<String>();
        if (gameArgs != null && gameArgs.size() > 0) {
            for (Map.Entry<String, String> entry : gameArgs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                boolean contains = false;
                if (CMCL.isEmpty(value)) {
                    for (String arg : minecraftArguments) {
                        if (!arg.equals("--" + key) && !arg.equals("-" + key)) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    addableGameArgs.add("--" + key);
                    continue;
                }
                for (int i = 0; i < minecraftArguments.size(); ++i) {
                    String arg;
                    arg = (String)minecraftArguments.get(i);
                    if (!arg.equals("--" + key) && !arg.equals("-" + key)) continue;
                    contains = true;
                    if (i + 1 >= minecraftArguments.size()) {
                        minecraftArguments.add(value);
                        break;
                    }
                    String next = (String)minecraftArguments.get(i + 1);
                    if (!next.startsWith("--") && !next.startsWith("-")) {
                        minecraftArguments.set(i + 1, value);
                        break;
                    }
                    minecraftArguments.add(i + 1, value);
                    break;
                }
                if (contains) continue;
                addableGameArgs.add("--" + key);
                addableGameArgs.add(value);
            }
        }
        if (!CMCL.isEmpty(quickPlayServerAddress) && !minecraftArguments.contains("--quickPlayMultiplayer")) {
            String[] stringArray = quickPlayServerAddress.split(":");
            minecraftArguments.add("--server");
            minecraftArguments.add(stringArray[0]);
            minecraftArguments.add("--port");
            minecraftArguments.add(stringArray.length > 1 ? stringArray[1] : "25565");
        }
        arguments.add(javaPath);
        arguments.addAll(addableJvmArgs);
        arguments.addAll(jvmArguments);
        arguments.add(mainClass);
        arguments.addAll(minecraftArguments);
        arguments.addAll(addableGameArgs);
        return arguments;
    }

    public static String getMinecraftLaunchCommand(File minecraftJarFile, File minecraftVersionJsonFile, File gameDir, File assetsDir, File resourcePacksDir, String playerName, String javaPath, long maxMemory, int miniMemory, int width, int height, boolean fullscreen, String accessToken, String uuid, boolean isDemo, boolean customScreenSize, JSONObject properties, @Nullable List<String> jvmArgs, @Nullable Map<String, String> gameArgs, @Nullable AuthlibInjectorInformation authlibInjectorInformation, @Nullable Nide8AuthInformation nide8AuthInformation, @Nullable String quickPlayLogFilePath, @Nullable String quickPlaySaveName, @Nullable String quickPlayServerAddress, @Nullable String quickPlayRealmsID) throws LibraryDefectException, EmptyNativesException, LaunchException, IOException, JSONException {
        List<String> args = MinecraftLauncher.getMinecraftLaunchCommandArguments(minecraftJarFile, minecraftVersionJsonFile, gameDir, assetsDir, resourcePacksDir, playerName, javaPath, maxMemory, miniMemory, width, height, fullscreen, accessToken, uuid, isDemo, customScreenSize, properties, null, jvmArgs, gameArgs, authlibInjectorInformation, nide8AuthInformation, quickPlayLogFilePath, quickPlaySaveName, quickPlayServerAddress, quickPlayRealmsID);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.size(); ++i) {
            String str = args.get(i);
            if (str.contains(" ") && (str = "\"" + str + "\"").contains("\\")) {
                str = str.replace("\\", "\\\\");
            }
            stringBuilder.append(str);
            if (i + 1 == args.size()) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static boolean isMeetConditions(JSONArray rules, Map<String, Boolean> featuresProvided) {
        if (rules == null || rules.length() == 0) {
            return true;
        }
        String action = "disallow";
        for (int i = 0; i < rules.length(); ++i) {
            String thisAction;
            boolean osMatches;
            JSONObject rule = rules.optJSONObject(i);
            if (rule == null) continue;
            JSONObject os = rule.optJSONObject("os");
            JSONObject features = rule.optJSONObject("features");
            if (os != null) {
                String name = os.optString("name");
                String version = os.optString("version");
                String arch = os.optString("arch");
                osMatches = !CMCL.isEmpty(name) && !name.equals(OperatingSystem.CURRENT_OS.getCheckedName()) ? false : (!CMCL.isEmpty(version) && !Pattern.compile(version).matcher(System.getProperty("os.version")).find() ? false : (!CMCL.isEmpty(arch) ? Pattern.compile(arch).matcher(System.getProperty("os.arch")).matches() : true));
            } else {
                osMatches = false;
            }
            if (os != null && !osMatches) {
                thisAction = null;
            } else if (features != null) {
                for (Map.Entry<String, Object> entry : features.toMap().entrySet()) {
                    if (Objects.equals(featuresProvided.get(entry.getKey()), entry.getValue())) continue;
                    thisAction = null;
                    break;
                }
            } else {
                thisAction = rule.optString("action");
            }
            if (CMCL.isEmpty(thisAction)) continue;
            action = thisAction;
        }
        return action.equals("allow");
    }

    public static Process launchMinecraft(File versionDir, File minecraftJarFile, File minecraftVersionJsonFile, File gameDir, File assetsDir, File resourcePacksDir, String playerName, String javaPath, long maxMemory, int miniMemory, int width, int height, boolean fullscreen, String accessToken, String uuid, boolean isDemo, boolean customScreenSize, JSONObject properties, @Nullable List<String> jvmArgs, @Nullable Map<String, String> gameArgs, @Nullable AuthlibInjectorInformation authlibInjectorInformation, @Nullable Nide8AuthInformation nide8AuthInformation, @Nullable String quickPlayLogFilePath, @Nullable String quickPlaySaveName, @Nullable String quickPlayServerAddress, @Nullable String quickPlayRealmsID) throws LibraryDefectException, EmptyNativesException, LaunchException, IOException, JSONException {
        List<String> args = MinecraftLauncher.getMinecraftLaunchCommandArguments(minecraftJarFile, minecraftVersionJsonFile, gameDir, assetsDir, resourcePacksDir, playerName, javaPath, maxMemory, miniMemory, width, height, fullscreen, accessToken, uuid, isDemo, customScreenSize, properties, () -> System.out.println(CMCL.getString("MESSAGE_STARTING_GAME")), jvmArgs, gameArgs, authlibInjectorInformation, nide8AuthInformation, quickPlayLogFilePath, quickPlaySaveName, quickPlayServerAddress, quickPlayRealmsID);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.directory(versionDir);
        processBuilder.redirectErrorStream(true);
        return processBuilder.start();
    }

    private static void getJavaVirtualMachineArguments(JSONObject headJsonObject, Map<String, Boolean> featuresProvided, List<String> args) {
        MinecraftLauncher.getArguments(headJsonObject, "jvm", featuresProvided, args);
    }

    private static void getGameArguments(JSONObject headJsonObject, Map<String, Boolean> featuresProvided, List<String> args) {
        MinecraftLauncher.getArguments(headJsonObject, "game", featuresProvided, args);
    }

    private static void getArguments(JSONObject headJsonObject, String name, Map<String, Boolean> featuresProvided, List<String> args) {
        JSONObject argumentsArray = headJsonObject.optJSONObject("arguments");
        JSONArray array = argumentsArray.optJSONArray(name);
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value;
            JSONObject jsonObject;
            Object obj = array.opt(i);
            if (obj instanceof String) {
                String a = (String)obj;
                args.add(a);
                continue;
            }
            if (!(obj instanceof JSONObject) || (jsonObject = array.optJSONObject(i)) == null || !jsonObject.has("value") || (value = jsonObject.opt("value")) == null) continue;
            boolean meetConditions = true;
            JSONArray rules = jsonObject.optJSONArray("rules");
            if (rules != null) {
                meetConditions = MinecraftLauncher.isMeetConditions(rules, featuresProvided);
            }
            if (!meetConditions) continue;
            if (value instanceof JSONArray) {
                JSONArray value2 = (JSONArray)value;
                for (int k = 0; k < value2.length(); ++k) {
                    if (!(value2.opt(k) instanceof String)) continue;
                    args.add(Utils.valueOf(value2.opt(k)));
                }
                continue;
            }
            args.add(Utils.valueOf(value));
        }
    }

    public static ThreeReturns<List<Library>, List<Library>, Boolean> getLibraries(JSONArray libraries) {
        return MinecraftLauncher.getLibraries(libraries, false);
    }

    public static ThreeReturns<List<Library>, List<Library>, Boolean> getLibraries(JSONArray libraries, boolean replaceOptiFineToOptiFineInstaller) {
        LinkedHashMap<String, Library> librariesPaths = new LinkedHashMap<String, Library>();
        HashMap<String, Library> notFound = new HashMap<String, Library>();
        boolean needNatives = false;
        for (int i = 0; i < libraries.length(); ++i) {
            int compare;
            String name;
            SplitLibraryName nameSplit;
            JSONObject library = libraries.optJSONObject(i);
            boolean meet = true;
            JSONArray rules = library.optJSONArray("rules");
            if (rules != null) {
                meet = MinecraftLauncher.isMeetConditions(rules, Collections.emptyMap());
            }
            if (!meet) continue;
            JSONObject downloads = library.optJSONObject("downloads");
            if (downloads != null && downloads.optJSONObject("classifiers") != null) {
                needNatives = true;
                if (downloads.optJSONObject("artifact") == null) continue;
            }
            if ((nameSplit = VersionLibraryUtils.splitLibraryName(name = library.optString("name"))) == null) continue;
            if (replaceOptiFineToOptiFineInstaller && "optifine".equals(nameSplit.first) && "OptiFine".equals(nameSplit.second)) {
                nameSplit = new SplitLibraryName(nameSplit.first, nameSplit.second, nameSplit.version, "installer", nameSplit.extension);
            }
            String key = nameSplit.first + ":" + nameSplit.second + (!CMCL.isEmpty(nameSplit.classifier) ? ":" + nameSplit.classifier : "");
            Library exist = (Library)librariesPaths.get(key);
            File libraryFile = nameSplit.getPhysicalFile();
            Library lb = new Library(library, libraryFile);
            if (exist == null) {
                if (libraryFile.exists() && libraryFile.length() > 0L) {
                    librariesPaths.put(key, lb);
                    continue;
                }
                notFound.put(key, lb);
                continue;
            }
            String existName = exist.libraryJSONObject.optString("name");
            SplitLibraryName existNameSplit = VersionLibraryUtils.splitLibraryName(existName);
            if (existNameSplit == null || !Objects.equals(existNameSplit.first, nameSplit.first) || !Objects.equals(existNameSplit.second, nameSplit.second) || (compare = VersionUtils.tryToCompareVersion(existNameSplit.version, nameSplit.version)) != -1 && (compare != 0 || lb.libraryJSONObject.length() <= exist.libraryJSONObject.length())) continue;
            if (libraryFile.exists() && libraryFile.length() > 0L) {
                librariesPaths.put(key, lb);
                notFound.remove(key);
                continue;
            }
            notFound.put(key, lb);
            librariesPaths.remove(key);
        }
        return new ThreeReturns<List<Library>, List<Library>, Boolean>(new LinkedList(librariesPaths.values()), new LinkedList(notFound.values()), needNatives);
    }

    public static boolean isModpack(File versionDir) {
        if (new File(versionDir, "modpack.cfg").exists()) {
            return true;
        }
        if (new File(versionDir, "modpack.json").exists()) {
            return true;
        }
        if (new File(versionDir, "manifest.json").exists() || new File(versionDir, "mcbbs.packmeta").exists() || new File(versionDir, "modrinth.index.json").exists() || new File(versionDir, "mmc-pack.json").exists()) {
            return true;
        }
        File setupIni = new File(versionDir, "PCL/Setup.ini");
        try {
            if (setupIni.isFile() && Pattern.compile("VersionArgumentIndie:\\s*1").matcher(FileUtils.readFileContent(setupIni)).find()) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static String getRealJavaPath(String javaPath) throws InvalidJavaException {
        File javaPathFile = new File(javaPath);
        if (!javaPathFile.exists()) {
            throw new InvalidJavaException(CMCL.getString("EXCEPTION_JAVA_NOT_FOUND"));
        }
        if (javaPathFile.isDirectory()) {
            javaPathFile = new File(javaPathFile, javaPathFile.getName().equalsIgnoreCase("bin") ? (SystemUtils.isWindows() ? "java.exe" : "java") : (SystemUtils.isWindows() ? "bin\\java.exe" : "bin/java"));
            if (!javaPathFile.exists()) {
                javaPathFile = new File(javaPath, SystemUtils.isWindows() ? "java.exe" : "java");
                if (!javaPathFile.exists()) {
                    throw new InvalidJavaException(CMCL.getString("CONSOLE_INCORRECT_JAVA"));
                }
                javaPath = javaPathFile.getPath();
            } else {
                javaPath = javaPathFile.getPath();
            }
        }
        return javaPath;
    }
}

