/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.account.authentication.microsoft;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.server.MicrosoftAuthenticationServer;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.AccountUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONObject;

public class MicrosoftAuthentication {
    public static final String ACCESS_TOKEN_URL = "https://login.live.com/oauth20_token.srf";

    public static JSONObject loginMicrosoftAccount() {
        MicrosoftAuthenticationServer server = null;
        try {
            server = MicrosoftAuthentication.getServer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (server != null) {
            String url = "https://login.live.com/oauth20_authorize.srf?client_id=" + Constants.CLIENT_ID + "&response_type=code&scope=XboxLive.signin+offline_access&prompt=select_account&redirect_uri=" + server.getRedirectURI();
            System.out.println(Utils.getString("CONSOLE_LOGIN_MICROSOFT_WAIT_FOR_RESPONSE", url));
            SystemUtils.openLink(url);
            try {
                return MicrosoftAuthentication.onGotCode(server.getCode(), server.getRedirectURI());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        System.out.println(CMCL.getString("MESSAGE_UNABLE_TO_LOGIN_MICROSOFT"));
        return null;
    }

    private static JSONObject onGotCode(String code, String rUrl) {
        try {
            String secondString = "client_id=" + Constants.CLIENT_ID + "&grant_type=authorization_code&scope=XboxLive.signin+offline_access&client_id=" + Constants.CLIENT_ID + "&redirect_uri=" + rUrl + "&code=" + code;
            String first = NetworkUtils.post(ACCESS_TOKEN_URL, secondString, "application/x-www-form-urlencoded", null);
            JSONObject result = JSONUtils.parseJSONObject(first);
            if (result == null) {
                System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE"));
                return null;
            }
            if (result.has("error") || result.has("error_description")) {
                String var = result.optString("error_description");
                System.out.println(CMCL.getString("ERROR_WITH_MESSAGE", result.optString("error"), var));
                return null;
            }
            String tokenType = result.optString("token_type");
            String refreshToken = result.optString("refresh_token");
            JSONObject mcFirst = MicrosoftAuthentication.continueAuthentication(refreshToken);
            if (mcFirst == null) {
                return null;
            }
            long expiresIn = (long)mcFirst.optInt("expires_in") * 1000L + System.currentTimeMillis();
            String accessToken = mcFirst.optString("access_token");
            JSONObject profile = MicrosoftAuthentication.getProfile(tokenType, accessToken);
            if (profile == null) {
                System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE"));
                return null;
            }
            if (profile.has("error") || profile.has("errorMessage")) {
                String var = profile.optString("errorMessage");
                System.out.println(CMCL.getString("ERROR_WITH_MESSAGE", profile.optString("error"), var));
                return null;
            }
            String accountID = mcFirst.optString("username");
            JSONObject account = new JSONObject();
            account.put("id", accountID);
            account.put("loginMethod", 2);
            account.put("accessToken", accessToken);
            account.put("refreshToken", refreshToken);
            account.put("expiresIn", expiresIn);
            account.put("tokenType", tokenType);
            account.put("uuid", profile.optString("id"));
            account.put("playerName", profile.optString("name"));
            return account;
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE") + ": " + e);
            return null;
        }
    }

    public static JSONObject continueAuthentication(String refreshToken) throws IOException {
        JSONObject xstsResult;
        JSONObject firsta;
        JSONArray xui;
        String secondSecond = "client_id=" + Constants.CLIENT_ID + "&refresh_token=" + refreshToken + "&grant_type=refresh_token";
        String second = NetworkUtils.post(ACCESS_TOKEN_URL, secondSecond, "application/x-www-form-urlencoded", null);
        JSONObject result2 = JSONUtils.parseJSONObject(second);
        if (result2 == null) {
            System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE"));
            return null;
        }
        if (result2.has("error") || result2.has("error_description")) {
            String var = result2.optString("error_description");
            System.out.println(CMCL.getString("ERROR_WITH_MESSAGE", result2.optString("error"), var));
            return null;
        }
        String xboxLive = NetworkUtils.post("https://user.auth.xboxlive.com/user/authenticate", "{\"Properties\":{\"AuthMethod\":\"RPS\",\"SiteName\":\"user.auth.xboxlive.com\",\"RpsTicket\":\"d=" + result2.optString("access_token") + "\"},\"RelyingParty\":\"http://auth.xboxlive.com\",\"TokenType\":\"JWT\"}", "application/json", "application/json");
        JSONObject xboxLiveFirst = JSONUtils.parseJSONObject(xboxLive);
        if (xboxLiveFirst == null || xboxLiveFirst.has("error")) {
            System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE"));
            return null;
        }
        String Token = xboxLiveFirst.optString("Token");
        String uhs = "";
        JSONObject DisplayClaims = xboxLiveFirst.optJSONObject("DisplayClaims");
        if (DisplayClaims != null && (xui = DisplayClaims.optJSONArray("xui")) != null && xui.length() > 0 && (firsta = xui.optJSONObject(0)) != null) {
            uhs = firsta.optString("uhs");
        }
        if ((xstsResult = JSONUtils.parseJSONObject(NetworkUtils.post("https://xsts.auth.xboxlive.com/xsts/authorize", "{\"Properties\":{\"SandboxId\":\"RETAIL\",\"UserTokens\":[\"" + Token + "\"]},\"RelyingParty\":\"rp://api.minecraftservices.com/\",\"TokenType\":\"JWT\"}", "application/json", "application/json"))) == null || xstsResult.has("error")) {
            System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE"));
            return null;
        }
        String xstsToken = xstsResult.optString("Token");
        JSONObject mcFirst = JSONUtils.parseJSONObject(NetworkUtils.post("https://api.minecraftservices.com/authentication/login_with_xbox", "{\"identityToken\":\"XBL3.0 x=" + uhs + ";" + xstsToken + "\"}", "application/json", "application/json"));
        if (mcFirst == null || mcFirst.has("error")) {
            System.out.println(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_MESSAGE"));
            return null;
        }
        return mcFirst;
    }

    public static JSONObject getProfile(String tokenType, String accessToken) throws IOException {
        return JSONUtils.parseJSONObject(NetworkUtils.getWithToken("https://api.minecraftservices.com/minecraft/profile", !CMCL.isEmpty(tokenType) ? tokenType : "Bearer", accessToken));
    }

    private static MicrosoftAuthenticationServer getServer() throws IOException {
        IOException exception = null;
        for (int port : new int[]{29116, 29117, 29118, 29119, 29120, 29121, 29122, 29123, 29124, 29125, 29126}) {
            try {
                MicrosoftAuthenticationServer server = new MicrosoftAuthenticationServer(port);
                server.start(5000, true);
                return server;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        throw exception;
    }

    public static boolean refresh(JSONObject selectedAccount, JSONArray accounts) throws ExceptionWithDescription {
        boolean needRefresh;
        JSONObject profile = null;
        try {
            profile = MicrosoftAuthentication.getProfile(selectedAccount.optString("tokenType", "Bearer"), selectedAccount.optString("accessToken"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = needRefresh = selectedAccount.optString("accessToken").isEmpty() || selectedAccount.optString("uuid").isEmpty() || selectedAccount.optString("playerName").isEmpty() || selectedAccount.optString("id").isEmpty() || System.currentTimeMillis() > selectedAccount.optLong("expiresIn") || profile == null || profile.has("error") || profile.has("errorMessage");
        if (!needRefresh) {
            selectedAccount.put("uuid", profile.optString("id"));
            selectedAccount.put("playerName", profile.optString("name"));
            return true;
        }
        String refreshToken = selectedAccount.optString("refreshToken");
        boolean needReLogin = refreshToken.isEmpty();
        if (needReLogin) {
            System.out.println(CMCL.getString("MESSAGE_ACCOUNT_INFO_MISSING_NEED_RELOGIN"));
            JSONObject accountNew = MicrosoftAuthentication.loginMicrosoftAccount();
            if (accountNew == null) {
                throw new ExceptionWithDescription(null);
            }
            if (!accountNew.optString("id").equals(selectedAccount.optString("id"))) {
                throw new ExceptionWithDescription(CMCL.getString("ACCOUNT_MICROSOFT_REFRESH_NOT_SAME"));
            }
            accountNew.put("selected", true);
            for (int i = 0; i < accounts.length(); ++i) {
                JSONObject accountInFor = accounts.optJSONObject(i);
                if (!AccountUtils.isValidAccount(accountInFor) || !accountInFor.optBoolean("selected")) continue;
                accounts.put(i, accountNew);
                break;
            }
            return true;
        }
        try {
            JSONObject auth = MicrosoftAuthentication.continueAuthentication(refreshToken);
            if (auth == null) {
                throw new ExceptionWithDescription(null);
            }
            long expiresIn = (long)auth.optInt("expires_in") * 1000L + System.currentTimeMillis();
            String accessToken = auth.optString("access_token");
            JSONObject newProfile = MicrosoftAuthentication.getProfile(selectedAccount.optString("tokenType", "Bearer"), accessToken);
            if (newProfile == null) {
                throw new ExceptionWithDescription(CMCL.getString("MESSAGE_OFFICIAL_LOGIN_FAILED_TITLE"));
            }
            if (newProfile.has("error") || newProfile.has("errorMessage")) {
                String var = newProfile.optString("errorMessage");
                throw new ExceptionWithDescription(CMCL.getString("ERROR_WITH_MESSAGE", newProfile.optString("error"), var));
            }
            String accountID = auth.optString("username");
            selectedAccount.put("id", accountID);
            selectedAccount.put("accessToken", accessToken);
            selectedAccount.put("expiresIn", expiresIn);
            selectedAccount.put("uuid", newProfile.optString("id"));
            selectedAccount.put("playerName", newProfile.optString("name"));
            return true;
        }
        catch (Exception e) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_FAILED_REFRESH_TITLE") + (!Utils.isEmpty(Utils.valueOf(e)) ? ": " + e : ""));
        }
    }
}

