/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.account.authentication.yggdrasil;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.YggdrasilAuthenticationApiProvider;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public class YggdrasilAuthentication {
    public static void uploadSkin(YggdrasilAuthenticationApiProvider apiProvider, String uuid, String accessToken, String fileName, String suffix, byte[] skin, boolean slim) {
        if (Utils.isEmpty(uuid) || Utils.isEmpty(accessToken)) {
            System.out.println(CMCL.getString("CONSOLE_ACCOUNT_UN_OPERABLE_NEED_UUID_AND_URL_AND_TOKEN"));
            return;
        }
        try {
            String skinUploadURL = apiProvider.getSkinUploadURL(uuid);
            HttpURLConnection connection = (HttpURLConnection)new URL(skinUploadURL).openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Accept-Language", Locale.getDefault().toString());
            connection.setRequestProperty("Authorization", "Bearer " + accessToken);
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept", "*/*");
            String boundary = "~~~~~~~~~~~~~~~~~~~~~~~~~";
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.setDoOutput(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] sl = "\r\n".getBytes(StandardCharsets.UTF_8);
            byteArrayOutputStream.write(("--" + boundary).getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write("Content-Disposition: form-data; name=\"model\"".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(sl);
            String model = "";
            if (slim) {
                model = "slim";
            }
            byteArrayOutputStream.write(model.getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(("--" + boundary).getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"").getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(("Content-Type: image" + suffix).getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(skin);
            byteArrayOutputStream.write(sl);
            byteArrayOutputStream.write(sl);
            connection.setRequestProperty("Content-Length", String.valueOf(byteArrayOutputStream.size()));
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.close();
            String resultString = NetworkUtils.httpURLConnection2String(connection);
            if (!Utils.isEmpty(resultString) && resultString.startsWith("{")) {
                JSONObject result = new JSONObject(resultString);
                Utils.printfln(CMCL.getString("ERROR_WITH_MESSAGE"), result.optString("error"), result.optString("errorMessage"));
            } else {
                System.out.println(CMCL.getString("SUCCESSFULLY_SET_SKIN"));
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            e.printStackTrace();
            Utils.printfln(CMCL.getString("UNABLE_SET_SKIN"), new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            Utils.printfln(CMCL.getString("UNABLE_SET_SKIN"), new Object[0]);
        }
    }

    public static JSONObject selectCharacter(List<JSONObject> availableProfiles) {
        for (int i = 0; i < availableProfiles.size(); ++i) {
            JSONObject jsonObject = availableProfiles.get(i);
            System.out.println(i + 1 + "." + jsonObject.optString("name"));
        }
        int number = InteractionUtils.inputInt(Utils.getString("MESSAGE_YGGDRASIL_LOGIN_SELECT_PROFILE", 1, availableProfiles.size()), 1, availableProfiles.size());
        if (number != Integer.MAX_VALUE) {
            return availableProfiles.get(number - 1);
        }
        return null;
    }

    public static JSONObject validate(YggdrasilAuthenticationApiProvider provider, String accessToken, String clientToken) throws IOException {
        JSONObject request;
        String validationURL = provider.getValidationURL();
        String response = NetworkUtils.post(validationURL, (request = new JSONObject().put("accessToken", accessToken).put("clientToken", clientToken)).toString());
        if (CMCL.isEmpty(response)) {
            return null;
        }
        return JSONUtils.parseJSONObject(response);
    }

    public static JSONObject refresh(YggdrasilAuthenticationApiProvider provider, String accessToken, String clientToken) throws IOException {
        String refreshmentURL = provider.getRefreshmentURL();
        JSONObject request = new JSONObject().put("accessToken", accessToken).put("clientToken", clientToken);
        return new JSONObject(NetworkUtils.post(refreshmentURL, request.toString()));
    }
}

