/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.functions.AccountFunction;
import com.mrshiehx.cmcl.server.OfflineSkinServer;
import com.mrshiehx.cmcl.utils.BytesUtils;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import java.io.File;
import java.io.InputStream;
import org.json.JSONObject;

public class AuthlibInjectorInformation {
    public final String serverAddress;
    public final String serverName;
    public final String playerName;
    public final String token;
    public final String uuid;
    public final String metadataEncoded;
    public boolean forOfflineSkin;

    public AuthlibInjectorInformation(String serverAddress, String serverName, String playerName, String token, String uuid, String metadataEncoded) {
        serverAddress = NetworkUtils.addHttpsIfMissing(serverAddress);
        if (!serverAddress.endsWith("/")) {
            serverAddress = serverAddress + "/";
        }
        this.serverAddress = serverAddress;
        this.serverName = serverName;
        this.playerName = playerName;
        this.token = token;
        this.uuid = uuid;
        this.metadataEncoded = metadataEncoded;
    }

    public boolean isEmpty() {
        return Utils.isEmpty(this.serverAddress) || Utils.isEmpty(this.uuid) || Utils.isEmpty(this.token);
    }

    public static AuthlibInjectorInformation valuesOf(JSONObject account, String token, String uuid, boolean allowOfflineSkin) {
        if (account.optInt("loginMethod") == 1) {
            return new AuthlibInjectorInformation(account.optString("url"), account.optString("serverName"), account.optString("playerName", "XPlayer"), account.optString("accessToken"), account.optString("uuid"), account.optString("metadataEncoded"));
        }
        if (account.optInt("loginMethod") == 0 && allowOfflineSkin && (account.has("offlineSkin") || account.has("providedSkin") || account.has("cape"))) {
            String providedSkin;
            Pair<byte[], Pair<Boolean, String>> pair;
            byte[] cape = null;
            int capeLength = 0;
            String capeHash = null;
            String capeString = account.optString("cape");
            if (!Utils.isEmpty(capeString)) {
                File file = new File(capeString);
                if (file.exists()) {
                    try {
                        cape = FileUtils.getBytes(file);
                        capeLength = cape.length;
                        capeHash = BytesUtils.getBytesHashSHA256String(cape);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Utils.printflnErr(Utils.getString("CAPE_FILE_FAILED_LOAD"), file.getAbsolutePath());
                    }
                } else {
                    Utils.printflnErr(Utils.getString("CAPE_FILE_NOT_FOUND"), file.getAbsolutePath());
                }
            }
            boolean slim = false;
            byte[] skin = null;
            int skinLength = 0;
            String skinHash = null;
            if ((account.has("offlineSkin") || account.has("providedSkin")) && (pair = AuthlibInjectorInformation.getSkin(account, providedSkin = account.optString("providedSkin"))) != null) {
                skin = pair.getKey();
                slim = pair.getValue().getKey();
                skinLength = skin.length;
                try {
                    skinHash = BytesUtils.getBytesHashSHA256String(skin);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Utils.printflnErr(pair.getValue().getValue(), new Object[0]);
                    return null;
                }
            }
            try {
                OfflineSkinServer offlineSkinServer = new OfflineSkinServer(0, uuid, account.optString("playerName", "XPlayer"), skin, skinLength, skinHash, cape, capeLength, capeHash, slim);
                offlineSkinServer.start(5000, true);
                AuthlibInjectorInformation authlibInjectorInformation = new AuthlibInjectorInformation(offlineSkinServer.getRootUrl(), "CMCL", account.optString("playerName", "XPlayer"), token, uuid, null);
                authlibInjectorInformation.forOfflineSkin = true;
                return authlibInjectorInformation;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(CMCL.getString("UNABLE_TO_START_OFFLINE_SKIN_SERVER"));
            }
        }
        return null;
    }

    private static Pair<byte[], Pair<Boolean, String>> getSkin(JSONObject account, String providedSkin) {
        if ("steve".equals(providedSkin)) {
            try {
                InputStream is = AccountFunction.class.getResourceAsStream("/skin/steve.png");
                if (is == null) {
                    System.out.println(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_STEVE_NOT_FOUND"));
                    return null;
                }
                byte[] skin = FileUtils.inputStream2ByteArray(is);
                return new Pair<byte[], Pair<Boolean, String>>(skin, new Pair<Boolean, String>(false, CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_STEVE_UNABLE_LOAD")));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_STEVE_UNABLE_LOAD"));
                return null;
            }
        }
        if ("alex".equals(providedSkin)) {
            try {
                InputStream is = AccountFunction.class.getResourceAsStream("/skin/alex.png");
                if (is == null) {
                    System.out.println(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_ALEX_NOT_FOUND"));
                    return null;
                }
                byte[] skin = FileUtils.inputStream2ByteArray(is);
                return new Pair<byte[], Pair<Boolean, String>>(skin, new Pair<Boolean, String>(true, CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_ALEX_UNABLE_LOAD")));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_ALEX_UNABLE_LOAD"));
                return null;
            }
        }
        String offlineSkin = account.optString("offlineSkin");
        if (CMCL.isEmpty(offlineSkin)) {
            return null;
        }
        File file = new File(offlineSkin);
        if (!file.exists()) {
            Utils.printflnErr(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_FILE_NOT_FOUND"), file.getAbsolutePath());
            return null;
        }
        try {
            byte[] skin = FileUtils.getBytes(file);
            return new Pair<byte[], Pair<Boolean, String>>(skin, new Pair<Boolean, String>(account.optBoolean("slim"), String.format(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_FILE_FAILED_LOAD"), file.getAbsolutePath())));
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.printflnErr(CMCL.getString("UNABLE_OFFLINE_CUSTOM_SKIN_FILE_FAILED_LOAD"), file.getAbsolutePath());
            return null;
        }
    }
}

