/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.extra;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.modules.extra.ExtraMerger;
import com.mrshiehx.cmcl.modules.version.downloaders.LibrariesDownloader;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public abstract class ExtraInstaller {
    protected abstract String getExtraName();

    protected abstract ExtraMerger getExtraMerger();

    protected abstract boolean checkInstallable(JSONObject var1);

    public boolean install(File jsonFile, File jarFile, @Nullable String extraVersion) {
        XJSONObject gameJSON;
        String fileContent;
        try {
            fileContent = FileUtils.readFileContent(jsonFile);
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(Utils.getString("EXCEPTION_READ_FILE_WITH_PATH", jsonFile.getAbsoluteFile()));
            return false;
        }
        try {
            gameJSON = new XJSONObject(fileContent);
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(Utils.getString("EXCEPTION_PARSE_FILE_WITH_PATH", jsonFile.getAbsoluteFile()));
            return false;
        }
        if (!this.checkInstallable(gameJSON)) {
            return false;
        }
        String mcVersion = VersionUtils.getGameVersion((JSONObject)gameJSON, (File)jarFile).id;
        if (CMCL.isEmpty(mcVersion)) {
            System.out.println(CMCL.getString("INSTALL_MODLOADER_EMPTY_MC_VERSION", this.getExtraName()));
            return false;
        }
        Pair<Boolean, List<JSONObject>> pair = this.getExtraMerger().merge(mcVersion, gameJSON, jarFile, false, extraVersion);
        if (pair.getKey().booleanValue()) {
            List<JSONObject> list = pair.getValue();
            if (list != null && list.size() > 0) {
                for (JSONObject library : list) {
                    LibrariesDownloader.downloadSingleLibrary(library);
                }
            }
            try {
                FileUtils.writeFile(jsonFile, gameJSON.toString(2), false);
                System.out.println(CMCL.getString("INSTALLED_MODLOADER", this.getExtraName()));
                return true;
            }
            catch (Exception e) {
                if (Constants.isDebug()) {
                    e.printStackTrace();
                }
                System.out.println(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", this.getExtraName(), CMCL.getString("EXCEPTION_WRITE_FILE_WITH_PATH", jsonFile.getAbsolutePath())));
                return false;
            }
        }
        return false;
    }
}

