/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.extra.fabric;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.modules.extra.ExtraMerger;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractFabricMerger
implements ExtraMerger {
    protected abstract String getModLoaderName();

    protected abstract String getMetaUrl();

    protected abstract String getMavenUrl();

    protected abstract String getStorageName();

    protected boolean isQuilt() {
        return false;
    }

    @Override
    public Pair<Boolean, List<JSONObject>> merge(String minecraftVersion, JSONObject headJSONObject, File jarFile, boolean askContinue, @Nullable String extraVersion) {
        String fabricVersion;
        if (CMCL.isEmpty(extraVersion)) {
            JSONArray jsonArray;
            try {
                jsonArray = this.listFabricLoaderVersions(minecraftVersion);
            }
            catch (Exception e) {
                if (Constants.isDebug()) {
                    e.printStackTrace();
                }
                System.out.println(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_GET_INSTALLABLE_VERSION", this.getModLoaderName()));
                return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", this.getModLoaderName())), null);
            }
            if (jsonArray.length() == 0) {
                System.out.println(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", this.getModLoaderName()));
                return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", this.getModLoaderName())), null);
            }
            LinkedHashMap<String, JSONObject> fabrics = new LinkedHashMap<String, JSONObject>();
            for (Object object : jsonArray) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)object;
                fabrics.put(jsonObject.optJSONObject("loader", new JSONObject()).optString("version"), jsonObject);
            }
            ArrayList<String> fabricVersions = new ArrayList<String>(fabrics.keySet());
            PrintingUtils.printListItems(fabricVersions, true, 4, 2, true);
            fabricVersion = ExtraMerger.selectExtraVersion(CMCL.getString("INSTALL_MODLOADER_SELECT", this.getModLoaderName(), fabricVersions.get(0)), fabrics, (String)fabricVersions.get(0), this.getModLoaderName());
            if (fabricVersion == null) {
                return new Pair<Boolean, Object>(false, null);
            }
        } else {
            fabricVersion = extraVersion;
        }
        try {
            return this.installInternal(minecraftVersion, fabricVersion, headJSONObject);
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(e.getMessage());
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", this.getModLoaderName())), null);
        }
    }

    public Pair<Boolean, List<JSONObject>> installInternal(String minecraftVersion, String fabricVersion, JSONObject headJSONObject) throws ExceptionWithDescription {
        String maven;
        JSONArray libraries;
        String targetJSONString;
        String jsonUrl = this.getMetaUrl() + String.format("versions/loader/%s/%s", minecraftVersion, fabricVersion);
        try {
            targetJSONString = NetworkUtils.get(jsonUrl);
        }
        catch (IOException e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_GET_TARGET_JSON", this.getModLoaderName()));
        }
        if (targetJSONString.contains("no loader version found")) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_SELECT_NOT_FOUND_GAME_OR_TARGET_EXTRA").replace("${NAME}", this.getModLoaderName()));
        }
        JSONObject fabricJSONOrigin = JSONUtils.parseJSONObject(targetJSONString);
        if (fabricJSONOrigin == null) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_PARSE_TARGET_JSON", this.getModLoaderName()));
        }
        if (fabricJSONOrigin.optString("message").toLowerCase().contains("not found") || fabricJSONOrigin.optString("message").toLowerCase().contains("does not exist") || fabricJSONOrigin.optString("code").toLowerCase().contains("not_found")) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_SELECT_NOT_FOUND_GAME_OR_TARGET_EXTRA").replace("${NAME}", this.getModLoaderName()));
        }
        JSONObject fabricJSON = new JSONObject();
        JSONObject loader = fabricJSONOrigin.optJSONObject("loader");
        JSONObject intermediary = fabricJSONOrigin.optJSONObject("intermediary");
        JSONObject launcherMeta = fabricJSONOrigin.optJSONObject("launcherMeta");
        JSONObject hashed = fabricJSONOrigin.optJSONObject("hashed");
        if (launcherMeta != null) {
            JSONObject libraries2;
            JSONArray client;
            JSONObject tweakers;
            Object mainClassObject = launcherMeta.opt("mainClass");
            if (mainClassObject instanceof String) {
                fabricJSON.put("mainClass", mainClassObject);
            } else if (mainClassObject instanceof JSONObject) {
                fabricJSON.put("mainClass", ((JSONObject)mainClassObject).optString("client"));
            }
            JSONObject launchwrapper = launcherMeta.optJSONObject("launchwrapper");
            if (launchwrapper != null && (tweakers = launchwrapper.optJSONObject("tweakers")) != null && (client = tweakers.optJSONArray("client")) != null) {
                for (Object o : client) {
                    if (!(o instanceof String)) continue;
                    fabricJSON.put("arguments", new JSONObject().put("game", new JSONArray().put("--tweakClass").put(o)));
                    break;
                }
            }
            if ((libraries2 = launcherMeta.optJSONObject("libraries")) != null) {
                JSONArray common = libraries2.optJSONArray("common");
                JSONArray server = libraries2.optJSONArray("server");
                fabricJSON.put("libraries", common.putAll(server));
            }
        }
        if ((libraries = fabricJSON.optJSONArray("libraries")) == null) {
            libraries = new JSONArray();
            fabricJSON.put("libraries", libraries);
        }
        if (intermediary != null && !CMCL.isEmpty(maven = intermediary.optString("maven"))) {
            libraries.put(new JSONObject().put("name", maven).put("url", maven.startsWith("net.fabricmc:intermediary:") ? "https://maven.fabricmc.net/" : this.getMavenUrl()));
        }
        if (loader != null && !CMCL.isEmpty(maven = loader.optString("maven"))) {
            libraries.put(new JSONObject().put("name", maven).put("url", this.getMavenUrl()));
        }
        if (hashed != null && !CMCL.isEmpty(maven = hashed.optString("maven"))) {
            String mavenUrl = this.getMavenUrl();
            if (this.isQuilt() && maven.startsWith("org.quiltmc:hashed")) {
                maven = maven.replace("org.quiltmc:hashed", "net.fabricmc:intermediary");
                mavenUrl = "https://maven.fabricmc.net/";
            }
            libraries.put(new JSONObject().put("name", maven).put("url", mavenUrl));
        }
        return new Pair<Boolean, List<JSONObject>>(true, this.realMerge(headJSONObject, fabricJSON, fabricVersion, jsonUrl));
    }

    private List<JSONObject> realMerge(JSONObject headJSONObject, JSONObject fabricJSON, String fabricVersion, String jsonUrl) {
        JSONObject arguments;
        String mainClass = fabricJSON.optString("mainClass");
        if (!Utils.isEmpty(mainClass)) {
            headJSONObject.put("mainClass", mainClass);
        }
        JSONObject fabric = new JSONObject();
        fabric.put("version", fabricVersion);
        fabric.put("originJsonUrl", jsonUrl);
        headJSONObject.put(this.getStorageName(), fabric);
        JSONArray fabricLibraries = fabricJSON.optJSONArray("libraries");
        LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        if (fabricLibraries != null) {
            for (Object o : fabricLibraries) {
                if (!(o instanceof JSONObject)) continue;
                list.add((JSONObject)o);
            }
            headJSONObject.optJSONArray("libraries").putAll(fabricLibraries);
        }
        if ((arguments = fabricJSON.optJSONObject("arguments")) != null) {
            JSONObject argumentsMC = headJSONObject.optJSONObject("arguments");
            if (argumentsMC != null) {
                JSONArray jvm;
                JSONArray game = arguments.optJSONArray("game");
                if (game != null && game.length() > 0) {
                    argumentsMC.optJSONArray("game").putAll(game);
                }
                if ((jvm = arguments.optJSONArray("jvm")) != null && jvm.length() > 0) {
                    argumentsMC.optJSONArray("jvm").putAll(jvm);
                }
            } else {
                headJSONObject.put("arguments", arguments);
            }
        }
        return list;
    }

    private JSONArray listFabricLoaderVersions(String minecraftVersion) throws IOException {
        return new JSONArray(NetworkUtils.get(this.getMetaUrl() + "versions/loader/" + minecraftVersion));
    }
}

