/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.extra.forge;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.bean.SplitLibraryName;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.modules.extra.ExtraMerger;
import com.mrshiehx.cmcl.modules.version.downloaders.LibrariesDownloader;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionLibraryUtils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ForgeMerger
implements ExtraMerger {
    private static final String MODLOADER_NAME = "Forge";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static boolean clChecked = false;
    private static ClassLoader parentClassLoader = null;

    @Override
    public Pair<Boolean, List<JSONObject>> merge(String minecraftVersion, JSONObject headJSONObject, File minecraftJarFile, boolean askContinue, @Nullable String extraVersion) {
        JSONObject forge;
        Map<String, JSONObject> installableForges;
        try {
            installableForges = ForgeMerger.getInstallableForges(minecraftVersion);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
        }
        if (installableForges.size() == 0) {
            System.out.println(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION_2", MODLOADER_NAME));
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
        }
        if (CMCL.isEmpty(extraVersion)) {
            LinkedList<Map.Entry<String, JSONObject>> list = new LinkedList<Map.Entry<String, JSONObject>>(installableForges.entrySet());
            list.sort((o1, o2) -> {
                try {
                    Date dt1 = TIME_FORMAT.parse(((JSONObject)o1.getValue()).optString("modified").substring(0, 19) + "+0000");
                    Date dt2 = TIME_FORMAT.parse(((JSONObject)o2.getValue()).optString("modified").substring(0, 19) + "+0000");
                    return Long.compare(dt2.getTime(), dt1.getTime());
                }
                catch (Exception exception) {
                    return 0;
                }
            });
            PrintingUtils.printListItems(list.stream().map(Map.Entry::getKey).collect(Collectors.toList()), true, 4, 2, true);
            String forgeVersionInput = ExtraMerger.selectExtraVersion(CMCL.getString("INSTALL_MODLOADER_SELECT", MODLOADER_NAME, ((Map.Entry)list.get(0)).getKey()), installableForges, (String)((Map.Entry)list.get(0)).getKey(), MODLOADER_NAME);
            if (forgeVersionInput == null) {
                return new Pair<Boolean, Object>(false, null);
            }
            forge = installableForges.get(forgeVersionInput);
            if (forge == null) {
                return new Pair<Boolean, Object>(false, null);
            }
        } else {
            forge = installableForges.get(extraVersion);
            if (forge == null) {
                System.out.println(CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", extraVersion).replace("${NAME}", MODLOADER_NAME));
                return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
            }
        }
        try {
            return ForgeMerger.installInternal(forge, headJSONObject, minecraftVersion, minecraftJarFile);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
        }
    }

    public static Map<String, JSONObject> getInstallableForges(String minecraftVersion) throws ExceptionWithDescription {
        JSONArray jsonArray;
        try {
            jsonArray = ForgeMerger.listForgeLoaderVersions(minecraftVersion);
        }
        catch (Exception e) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_GET_INSTALLABLE_VERSION", MODLOADER_NAME));
        }
        if (jsonArray.length() == 0) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", MODLOADER_NAME));
        }
        String category = "installer";
        String format = "jar";
        LinkedHashMap<String, JSONObject> forges = new LinkedHashMap<String, JSONObject>();
        block2: for (Object object : jsonArray) {
            JSONObject jsonObject;
            JSONArray files;
            if (!(object instanceof JSONObject) || (files = (jsonObject = (JSONObject)object).optJSONArray("files")) == null || files.length() <= 0) continue;
            for (Object o : files) {
                JSONObject jsonObject2;
                if (!(o instanceof JSONObject) || !category.equals((jsonObject2 = (JSONObject)o).optString("category")) || !format.equals(jsonObject2.optString("format"))) continue;
                forges.put(jsonObject.optString("version"), jsonObject);
                continue block2;
            }
        }
        return forges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Pair<Boolean, List<JSONObject>> installInternal(JSONObject forge, JSONObject headJSONObject, String minecraftVersion, File minecraftJarFile) throws ExceptionWithDescription {
        String mainClass;
        JSONObject installProfile;
        ZipFile zipFile;
        String finalDownload;
        String category = "installer";
        String format = "jar";
        String forgeVersion = forge.optString("version");
        String branch = forge.optString("branch");
        String mcversion = forge.optString("mcversion");
        String s = minecraftVersion + "-" + forgeVersion + (!CMCL.isEmpty(branch) ? "-" + branch : "");
        String fileName1 = "forge-" + s + "-" + category + "." + format;
        String fileName2 = "forge-" + s + "-" + minecraftVersion + "-" + category + "." + format;
        String first = DownloadSource.getProvider().forgeMaven() + "net/minecraftforge/forge/" + s + "/" + fileName1;
        String second = DownloadSource.getProvider().forgeMaven() + "net/minecraftforge/forge/" + s + "-" + minecraftVersion + "/" + fileName2;
        File installer = new File(CMCL.getCMCLWorkingDirectory(), "forge-" + s + ".jar");
        System.out.println(CMCL.getString("INSTALL_MODLOADER_DOWNLOADING_FILE"));
        try {
            DownloadUtils.downloadFile(first, installer);
            finalDownload = first;
        }
        catch (Exception ignore) {
            try {
                DownloadUtils.downloadFile(second, installer);
                finalDownload = second;
            }
            catch (Exception ignored) {
                StringBuilder stringBuilder = new StringBuilder();
                char start = '?';
                if (!CMCL.isEmpty(mcversion)) {
                    stringBuilder.append(start).append("mcversion=").append(mcversion);
                    start = '&';
                }
                if (!CMCL.isEmpty(forgeVersion)) {
                    stringBuilder.append(start).append("version=").append(forgeVersion);
                    start = '&';
                }
                if (!CMCL.isEmpty(branch)) {
                    stringBuilder.append(start).append("branch=").append(branch);
                    start = '&';
                }
                stringBuilder.append(start).append("category=").append(category);
                start = '&';
                stringBuilder.append(start).append("format=").append(format);
                String third = DownloadSource.getProvider().thirdPartyForge() + stringBuilder;
                try {
                    byte[] byArray;
                    HttpURLConnection connection;
                    URL ConnectUrl = new URL(third);
                    try {
                        connection = (HttpURLConnection)ConnectUrl.openConnection();
                    }
                    catch (IOException iOException) {
                        if (Utils.getConfig().optBoolean("proxyEnabled")) {
                            System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
                        }
                        throw iOException;
                    }
                    connection.setDoInput(true);
                    connection.setUseCaches(false);
                    connection.setDoOutput(true);
                    connection.setRequestMethod("GET");
                    try {
                        byArray = NetworkUtils.httpURLConnection2Bytes(connection);
                    }
                    catch (IOException e) {
                        if (Utils.getConfig().optBoolean("proxyEnabled")) {
                            System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
                        }
                        throw e;
                    }
                    FileUtils.bytes2File(installer, byArray, false);
                    finalDownload = third;
                }
                catch (Exception e) {
                    throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_DOWNLOAD", MODLOADER_NAME) + ": " + e);
                }
            }
        }
        if (!installer.exists() || installer.length() == 0L) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_DOWNLOAD", MODLOADER_NAME));
        }
        try {
            zipFile = new ZipFile(installer);
            installProfile = new JSONObject(Utils.inputStream2String(zipFile.getInputStream(zipFile.getEntry("install_profile.json"))));
        }
        catch (IOException e) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, CMCL.getString("EXCEPTION_READ_FILE_WITH_PATH", installer.getAbsolutePath()) + ": " + e));
        }
        catch (JSONException e) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, CMCL.getString("EXCEPTION_PARSE_FILE")));
        }
        JSONObject version = null;
        if (installProfile.has("spec")) {
            SplitLibraryName nameSplit;
            String string;
            if (!installProfile.optString("minecraft").equals(minecraftVersion)) {
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_MC_VERSION_MISMATCH", MODLOADER_NAME));
            }
            String json = installProfile.optString("json");
            FileSystem installerFileSystem = null;
            for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
                if (!fileSystemProvider.getScheme().equalsIgnoreCase("jar")) continue;
                try {
                    installerFileSystem = fileSystemProvider.newFileSystem(installer.toPath(), new HashMap());
                    version = new JSONObject(new String(Files.readAllBytes(installerFileSystem.getPath(json, new String[0]))));
                    break;
                }
                catch (IOException e) {
                    throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, CMCL.getString("EXCEPTION_READ_FILE_WITH_PATH", json) + ": " + e));
                }
                catch (JSONException e) {
                    throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, CMCL.getString("EXCEPTION_PARSE_FILE_WITH_PATH", json)));
                }
            }
            if (version == null) {
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, CMCL.getString("EXCEPTION_READ_FILE_WITH_PATH", json)));
            }
            JSONArray installProfileLibraries = installProfile.optJSONArray("libraries");
            if (installProfileLibraries != null && installProfileLibraries.length() > 0) {
                for (Object object : installProfileLibraries) {
                    if (!(object instanceof JSONObject)) continue;
                    JSONObject library = (JSONObject)object;
                    Pair<String, String> pair = VersionLibraryUtils.getLibraryDownloadURLAndStoragePath(library);
                    if (pair == null) {
                        System.out.println(CMCL.getString("MESSAGE_NOT_FOUND_LIBRARY_DOWNLOAD_URL", library.optString("name")));
                        continue;
                    }
                    String string2 = pair.getKey();
                    if (CMCL.isEmpty(string2)) {
                        String path = pair.getValue();
                        File file = new File(CMCL.librariesDir, path);
                        if (file.length() > 0L) continue;
                        String path2 = "/maven" + (!path.startsWith("/") ? "/" + path : path);
                        try {
                            System.out.println(CMCL.getString("MESSAGE_UNZIPPING_FILE", path2));
                            FileUtils.createFile(file, true);
                            FileUtils.bytes2File(file, Files.readAllBytes(installerFileSystem.getPath(path2, new String[0])), false);
                        }
                        catch (Exception e) {
                            System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", path2, e));
                        }
                        continue;
                    }
                    LibrariesDownloader.downloadSingleLibrary(library);
                }
            }
            if (!CMCL.isEmpty(string = installProfile.optString("path")) && (nameSplit = VersionLibraryUtils.splitLibraryName(string)) != null) {
                String fileName = nameSplit.getFileName();
                String path = Utils.getPathFromLibraryName(nameSplit) + "/" + fileName;
                File file = new File(CMCL.librariesDir, path);
                if (file.length() <= 0L) {
                    String path2 = "/maven" + (String)(!path.startsWith("/") ? "/" + (String)path : path);
                    try {
                        System.out.println(CMCL.getString("MESSAGE_UNZIPPING_FILE", path2));
                        FileUtils.createFile(file, true);
                        FileUtils.bytes2File(file, Files.readAllBytes(installerFileSystem.getPath(path2, new String[0])), false);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", path2, e));
                    }
                }
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            File temp = new File(CMCL.getCMCLWorkingDirectory(), "forge" + System.currentTimeMillis());
            temp.mkdirs();
            JSONObject dataJSON = installProfile.optJSONObject("data");
            for (Map.Entry entry : dataJSON.toMap().entrySet()) {
                String inside;
                String client;
                Object clientObject;
                if (!(entry.getValue() instanceof Map) || !((clientObject = ((Map)entry.getValue()).get("client")) instanceof String) || Utils.isEmpty(client = (String)clientObject)) continue;
                String key = (String)entry.getKey();
                if (client.charAt(0) == '[' && client.charAt(client.length() - 1) == ']') {
                    inside = client.substring(1, client.length() - 1);
                    SplitLibraryName nameSplit2 = SplitLibraryName.valueOf(inside);
                    if (nameSplit2 == null) continue;
                    File libraryFile = nameSplit2.getPhysicalFile();
                    hashMap.put(key, libraryFile.getAbsolutePath());
                    continue;
                }
                if (client.charAt(0) == '\'' && client.charAt(client.length() - 1) == '\'') {
                    inside = client.substring(1, client.length() - 1);
                    hashMap.put(key, inside);
                    continue;
                }
                File target = new File(temp, client);
                try {
                    if (target.exists()) {
                        target.delete();
                    }
                    FileUtils.bytes2File(target, Files.readAllBytes(installerFileSystem.getPath(client, new String[0])), false);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", client, e));
                }
                hashMap.put(key, target.getAbsolutePath());
            }
            hashMap.put("SIDE", "client");
            hashMap.put("MINECRAFT_JAR", minecraftJarFile.getAbsolutePath());
            hashMap.put("MINECRAFT_VERSION", installProfile.optString("minecraft"));
            hashMap.put("ROOT", CMCL.gameDir.getAbsolutePath());
            hashMap.put("INSTALLER", installer.getAbsolutePath());
            hashMap.put("LIBRARY_DIR", CMCL.librariesDir.getAbsolutePath());
            JSONArray processorsJSON = installProfile.optJSONArray("processors");
            List<JSONObject> list = JSONUtils.jsonArrayToJSONObjectList(processorsJSON, jsonObject -> {
                JSONArray sides = jsonObject.optJSONArray("sides");
                boolean contains = false;
                if (sides != null && sides.length() > 0) {
                    for (Object side : sides) {
                        if (!"client".equals(side)) continue;
                        contains = true;
                        break;
                    }
                } else {
                    contains = true;
                }
                return contains;
            });
            for (JSONObject processor : list) {
                File processorJarPhysicalFile;
                SplitLibraryName splitLibraryName = SplitLibraryName.valueOf(processor.optString("jar"));
                if (splitLibraryName == null || !(processorJarPhysicalFile = splitLibraryName.getPhysicalFile()).exists() || !processorJarPhysicalFile.isFile()) continue;
                try {
                    JarFile jarFile = new JarFile(processorJarPhysicalFile);
                    Throwable throwable = null;
                    try {
                        Iterator<Object> o22;
                        String mainClass2 = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        ArrayList<URL> classpath = new ArrayList<URL>();
                        classpath.add(processorJarPhysicalFile.toURI().toURL());
                        for (Iterator<Object> o22 : processor.optJSONArray("classpath")) {
                            SplitLibraryName splitLibraryName1;
                            if (!(o22 instanceof String) || (splitLibraryName1 = SplitLibraryName.valueOf((String)((Object)o22))) == null) continue;
                            classpath.add(splitLibraryName1.getPhysicalFile().toURI().toURL());
                        }
                        ArrayList<String> args = new ArrayList<String>();
                        o22 = processor.optJSONArray("args").iterator();
                        while (o22.hasNext()) {
                            Object o3 = o22.next();
                            if (!(o3 instanceof String)) continue;
                            String arg = (String)o3;
                            char start = arg.charAt(0);
                            char end = arg.charAt(arg.length() - 1);
                            if (start == '[' && end == ']') {
                                SplitLibraryName splitLibraryName1 = SplitLibraryName.valueOf(arg.substring(1, arg.length() - 1));
                                if (splitLibraryName1 == null) continue;
                                args.add(splitLibraryName1.getPhysicalFile().getAbsolutePath());
                                continue;
                            }
                            args.add(ForgeMerger.replaceTokens(hashMap, arg));
                        }
                        URLClassLoader cl = new URLClassLoader(classpath.toArray(new URL[0]), ForgeMerger.getParentClassloader());
                        Thread currentThread = Thread.currentThread();
                        ClassLoader threadClassloader = currentThread.getContextClassLoader();
                        currentThread.setContextClassLoader(cl);
                        try {
                            Class<?> cls = Class.forName(mainClass2, true, cl);
                            Method main = cls.getDeclaredMethod("main", String[].class);
                            main.invoke(null, new Object[]{args.toArray(new String[0])});
                        }
                        catch (InvocationTargetException ite) {
                            Throwable e = ite.getCause();
                            e.printStackTrace();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            currentThread.setContextClassLoader(threadClassloader);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jarFile == null) continue;
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jarFile.close();
                    }
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("MESSAGE_INSTALL_FORGE_FAILED_EXECUTE_PROCESSOR", e));
                }
            }
            Utils.close(zipFile);
            installer.delete();
            FileUtils.deleteDirectory(temp);
        } else if (installProfile.optJSONObject("install") != null && installProfile.optJSONObject("versionInfo") != null) {
            if (!installProfile.optJSONObject("install", new JSONObject()).optString("minecraft").equals(minecraftVersion)) {
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_MC_VERSION_MISMATCH", MODLOADER_NAME));
            }
            version = installProfile.optJSONObject("versionInfo");
            JSONObject installJSONObject = installProfile.optJSONObject("install");
            String path = installJSONObject.optString("path");
            String filePath = installJSONObject.optString("filePath");
            SplitLibraryName splitLibraryName = VersionLibraryUtils.splitLibraryName(path);
            File libraryFile = splitLibraryName.getPhysicalFile();
            try {
                FileUtils.inputStream2File(zipFile.getInputStream(zipFile.getEntry(filePath)), libraryFile);
                zipFile.close();
                installer.delete();
            }
            catch (IOException e) {
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", filePath, e)));
            }
        } else {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_UNKNOWN_TYPE", MODLOADER_NAME));
        }
        JSONArray forgeLibraries = version.optJSONArray("libraries");
        LinkedList<JSONObject> librariesNeedToInstall = new LinkedList<JSONObject>();
        if (forgeLibraries != null) {
            for (Object o : forgeLibraries) {
                File file;
                SplitLibraryName nameSplit2;
                JSONObject jSONObject;
                String name;
                if (!(o instanceof JSONObject) || (name = (jSONObject = (JSONObject)o).optString("name")).startsWith("net.minecraftforge:forge:") || (nameSplit2 = VersionLibraryUtils.splitLibraryName(name)) == null || (file = nameSplit2.getPhysicalFile()).exists() || file.length() != 0L) continue;
                librariesNeedToInstall.add(jSONObject);
            }
            JSONArray mcLibraries = headJSONObject.optJSONArray("libraries");
            headJSONObject.put("libraries", VersionLibraryUtils.mergeLibraries(JSONUtils.jsonArrayToJSONObjectList(mcLibraries), JSONUtils.jsonArrayToJSONObjectList(forgeLibraries)));
        }
        if (!Utils.isEmpty(mainClass = version.optString("mainClass"))) {
            headJSONObject.put("mainClass", mainClass);
        }
        JSONObject forgeInHead = new JSONObject();
        forgeInHead.put("version", forgeVersion);
        forgeInHead.put("jarUrl", finalDownload);
        headJSONObject.put("forge", forgeInHead);
        String string = version.optString("minecraftArguments");
        JSONObject arguments = version.optJSONObject("arguments");
        if (!CMCL.isEmpty(string)) {
            String hmca = headJSONObject.optString("minecraftArguments");
            if (hmca.isEmpty()) {
                headJSONObject.put("minecraftArguments", string);
            } else {
                Arguments arguments1 = new Arguments(hmca, false);
                Arguments arguments2 = new Arguments(string, false);
                arguments1.merge(arguments2);
                String string3 = arguments1.toString("--");
                headJSONObject.put("minecraftArguments", string3);
            }
        }
        if (arguments != null) {
            JSONObject argumentsMC = headJSONObject.optJSONObject("arguments");
            if (argumentsMC != null) {
                JSONArray jvm;
                JSONArray gameMC = argumentsMC.optJSONArray("game");
                JSONArray jSONArray = argumentsMC.optJSONArray("jvm");
                JSONArray game = arguments.optJSONArray("game");
                if (game != null && game.length() > 0) {
                    if (gameMC == null) {
                        gameMC = new JSONArray();
                        argumentsMC.put("game", gameMC);
                    }
                    gameMC.putAll(game);
                }
                if ((jvm = arguments.optJSONArray("jvm")) != null && jvm.length() > 0) {
                    void var27_60;
                    if (jSONArray == null) {
                        JSONArray jSONArray2 = new JSONArray();
                        argumentsMC.put("jvm", jSONArray2);
                    }
                    var27_60.putAll(jvm);
                }
            } else {
                headJSONObject.put("arguments", arguments);
            }
        }
        return new Pair<Boolean, List<JSONObject>>(true, librariesNeedToInstall);
    }

    private static JSONArray listForgeLoaderVersions(String minecraftVersion) throws IOException {
        return new JSONArray(NetworkUtils.get(DownloadSource.getProvider().forge() + "minecraft/" + minecraftVersion));
    }

    public static String replaceTokens(Map<String, String> tokens, String value) {
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '\\') {
                if (x == value.length() - 1) {
                    throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                }
                buf.append(value.charAt(++x));
                continue;
            }
            if (c == '{' || c == '\'') {
                StringBuilder key = new StringBuilder();
                for (int y = x + 1; y <= value.length(); ++y) {
                    if (y == value.length()) {
                        throw new IllegalArgumentException("Illegal pattern (Unclosed " + c + "): " + value);
                    }
                    char d = value.charAt(y);
                    if (d == '\\') {
                        if (y == value.length() - 1) {
                            throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                        }
                        key.append(value.charAt(++y));
                        continue;
                    }
                    if (c == '{' && d == '}') {
                        x = y;
                        break;
                    }
                    if (c == '\'' && d == '\'') {
                        x = y;
                        break;
                    }
                    key.append(d);
                }
                if (c == '\'') {
                    buf.append((CharSequence)key);
                    continue;
                }
                if (!tokens.containsKey(key.toString())) {
                    throw new IllegalArgumentException("Illegal pattern: " + value + " Missing Key: " + key);
                }
                buf.append(tokens.get(key.toString()));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static synchronized ClassLoader getParentClassloader() {
        if (!clChecked) {
            clChecked = true;
            if (!System.getProperty("java.version").startsWith("1.")) {
                try {
                    Method getPlatform = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
                    parentClassLoader = (ClassLoader)getPlatform.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return parentClassLoader;
    }
}

