/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.extra.liteloader;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DefaultApiProvider;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.bean.SplitLibraryName;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.modules.extra.ExtraMerger;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class LiteloaderMerger
implements ExtraMerger {
    private static final String MODLOADER_NAME = "LiteLoader";

    public static Pair<Boolean, List<JSONObject>> installInternal(String minecraftVersion, String liteloaderVersionString, JSONObject headJSONObject) throws ExceptionWithDescription {
        Map<String, LiteloaderVersion> versionsOfLiteLoader = LiteloaderMerger.getVersionList(minecraftVersion);
        LiteloaderVersion liteloaderVersion = versionsOfLiteLoader.get(liteloaderVersionString);
        if (liteloaderVersion == null) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", liteloaderVersionString).replace("${NAME}", MODLOADER_NAME));
        }
        return LiteloaderMerger.installInternal(liteloaderVersion, headJSONObject);
    }

    @Override
    public Pair<Boolean, List<JSONObject>> merge(String minecraftVersion, JSONObject headJSONObject, File jarFile, boolean askContinue, @Nullable String extraVersion) {
        LiteloaderVersion liteloaderVersion;
        Map<String, LiteloaderVersion> versionsOfLiteLoader;
        try {
            versionsOfLiteLoader = LiteloaderMerger.getVersionList(minecraftVersion);
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(e.getMessage());
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
        }
        if (CMCL.isEmpty(extraVersion)) {
            if (versionsOfLiteLoader.size() == 0) {
                System.out.println(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", MODLOADER_NAME));
                return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
            }
            ArrayList<String> liteloaderVersions = new ArrayList<String>(versionsOfLiteLoader.keySet());
            PrintingUtils.printListItems(liteloaderVersions, true, 4, 3);
            String inputLLVersion = ExtraMerger.selectExtraVersion(CMCL.getString("INSTALL_MODLOADER_SELECT", MODLOADER_NAME, liteloaderVersions.get(0)), versionsOfLiteLoader, (String)liteloaderVersions.get(0), MODLOADER_NAME);
            if (inputLLVersion == null) {
                return new Pair<Boolean, Object>(false, null);
            }
            liteloaderVersion = versionsOfLiteLoader.get(inputLLVersion);
            if (liteloaderVersion == null) {
                return new Pair<Boolean, Object>(false, null);
            }
        } else {
            liteloaderVersion = versionsOfLiteLoader.get(extraVersion);
            if (liteloaderVersion == null) {
                System.out.println(CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", extraVersion).replace("${NAME}", MODLOADER_NAME));
                return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
            }
        }
        try {
            return LiteloaderMerger.installInternal(liteloaderVersion, headJSONObject);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", MODLOADER_NAME)), null);
        }
    }

    private static Map<String, LiteloaderVersion> getVersionList(String minecraftVersion) throws ExceptionWithDescription {
        JSONObject snapshots;
        JSONObject versions;
        try {
            versions = new JSONObject(NetworkUtils.get(DownloadSource.getProvider().liteLoaderVersion())).optJSONObject("versions");
        }
        catch (Exception e) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_GET_INSTALLABLE_VERSION", MODLOADER_NAME));
        }
        JSONObject version = versions.optJSONObject(minecraftVersion);
        if (version == null) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", MODLOADER_NAME));
        }
        JSONObject repository = version.optJSONObject("repo");
        String repoUrl = null;
        if (repository != null) {
            repoUrl = repository.optString("url");
        }
        if (CMCL.isEmpty(repoUrl)) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", MODLOADER_NAME, "'url' in 'repo' is empty"));
        }
        HashMap<String, LiteloaderVersion> versionsOfLiteLoader = new HashMap<String, LiteloaderVersion>();
        JSONObject artefacts = version.optJSONObject("artefacts");
        if (artefacts != null) {
            JSONObject liteloader = artefacts.optJSONObject("com.mumfrey:liteloader");
            LiteloaderMerger.executeBranch(minecraftVersion, repoUrl, liteloader, versionsOfLiteLoader, false);
        }
        if ((snapshots = version.optJSONObject("snapshots")) != null) {
            JSONObject liteloader = snapshots.optJSONObject("com.mumfrey:liteloader");
            LiteloaderMerger.executeBranch(minecraftVersion, repoUrl, liteloader, versionsOfLiteLoader, true);
        }
        return versionsOfLiteLoader;
    }

    private static Pair<Boolean, List<JSONObject>> installInternal(LiteloaderVersion liteloaderVersion, JSONObject headJSONObject) throws ExceptionWithDescription {
        String libraryName = "com.mumfrey:liteloader:" + liteloaderVersion.version;
        File libraryFile = new SplitLibraryName("com.mumfrey", "liteloader", liteloaderVersion.version).getPhysicalFile();
        JSONObject library = new JSONObject().put("name", libraryName).put("url", "http://dl.liteloader.com/versions/").put("downloads", new JSONObject().put("artifact", new JSONObject().put("url", liteloaderVersion.url)));
        if (libraryFile.length() <= 0L) {
            try {
                System.out.print(CMCL.getString("MESSAGE_DOWNLOADING_FILE", libraryFile.getName()));
                DownloadUtils.downloadFile(liteloaderVersion.url, libraryFile, new PercentageTextProgress());
            }
            catch (Exception e) {
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_DOWNLOAD", MODLOADER_NAME));
            }
        }
        String minecraftArguments = headJSONObject.optString("minecraftArguments");
        headJSONObject.put("minecraftArguments", "--tweakClass " + liteloaderVersion.tweakClass + " " + minecraftArguments);
        headJSONObject.put("mainClass", "net.minecraft.launchwrapper.Launch");
        JSONObject liteloader = new JSONObject();
        liteloader.put("version", liteloaderVersion.version);
        liteloader.put("jarUrl", liteloaderVersion.url);
        headJSONObject.put("liteloader", liteloader);
        List<JSONObject> libraries = liteloaderVersion.libraries;
        libraries.add(library);
        JSONArray headLibraries = headJSONObject.optJSONArray("libraries");
        if (headLibraries == null) {
            headLibraries = new JSONArray();
            headJSONObject.put("libraries", headLibraries);
        }
        for (JSONObject library2 : libraries) {
            headLibraries.put(library2);
        }
        return new Pair<Boolean, List<JSONObject>>(true, libraries);
    }

    private static void executeBranch(String gameVersion, String repoUrl, JSONObject liteloader, Map<String, LiteloaderVersion> versions, boolean snapshotBool) {
        for (Map.Entry<String, Object> entry : liteloader.toMap().entrySet()) {
            String url;
            String branchName = entry.getKey();
            Object versionO = entry.getValue();
            if (!(versionO instanceof Map) || "latest".equals(branchName)) continue;
            JSONObject versionJO = new JSONObject((Map)versionO);
            String tweakClass = versionJO.optString("tweakClass");
            String version = versionJO.optString("version");
            String file = versionJO.optString("file");
            String string = url = DownloadSource.getProvider() instanceof DefaultApiProvider ? repoUrl + "com/mumfrey/liteloader/" + gameVersion + "/" + file : DownloadSource.getProvider().thirdPartyLiteLoaderDownload() + "?version=" + version;
            if (snapshotBool) {
                try {
                    Element snapshot = (Element)DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(NetworkUtils.get(NetworkUtils.addSlashIfMissing(repoUrl) + "com/mumfrey/liteloader/" + versionJO.optString("version") + "/maven-metadata.xml").getBytes())).getDocumentElement().getElementsByTagName("snapshot").item(0);
                    version = version.replace("SNAPSHOT", snapshot.getElementsByTagName("timestamp").item(0).getTextContent() + "-" + snapshot.getElementsByTagName("buildNumber").item(0).getTextContent());
                    url = repoUrl + "com/mumfrey/liteloader/" + versionJO.optString("version") + "/liteloader-" + version + "-release.jar";
                }
                catch (Exception snapshot) {
                    // empty catch block
                }
            }
            List<JSONObject> libraries = JSONUtils.jsonArrayToJSONObjectList(versionJO.optJSONArray("libraries"));
            versions.put(version, new LiteloaderVersion(tweakClass, file, version, libraries, url));
        }
    }

    private static class LiteloaderVersion {
        public final String tweakClass;
        public final String file;
        public final String version;
        public final List<JSONObject> libraries;
        public final String url;

        private LiteloaderVersion(String tweakClass, String file, String version, List<JSONObject> libraries, String url) {
            this.tweakClass = tweakClass;
            this.file = file;
            this.version = version;
            this.libraries = libraries;
            this.url = url;
        }
    }
}

