/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.extra.optifine;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.bean.SplitLibraryName;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.modules.extra.ExtraMerger;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.system.JavaUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class OptiFineMerger
implements ExtraMerger {
    private static final String EXTRA_NAME = "OptiFine";

    @Override
    public Pair<Boolean, List<JSONObject>> merge(String minecraftVersion, JSONObject headJSONObject, File jarFile, boolean askContinue, @Nullable String extraVersion) {
        JSONObject optifineVersion;
        String optifineVersionString;
        JSONArray versions;
        try {
            versions = new JSONArray(NetworkUtils.get(NetworkUtils.addSlashIfMissing(DownloadSource.getProvider().thirdPartyOptiFine()) + minecraftVersion));
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            System.out.println(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_GET_INSTALLABLE_VERSION", EXTRA_NAME));
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", EXTRA_NAME)), null);
        }
        if (versions.length() == 0) {
            System.out.println(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", EXTRA_NAME));
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", EXTRA_NAME)), null);
        }
        HashMap<String, JSONObject> versionsMap = new HashMap<String, JSONObject>();
        for (Object o : versions) {
            if (!(o instanceof JSONObject)) continue;
            JSONObject version = (JSONObject)o;
            String type = version.optString("type");
            String patch = version.optString("patch");
            versionsMap.put(type + (CMCL.isEmpty(patch) ? "" : "_" + patch), version);
        }
        if (versionsMap.size() == 0) {
            System.out.println(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", EXTRA_NAME));
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", EXTRA_NAME)), null);
        }
        if (CMCL.isEmpty(extraVersion)) {
            ArrayList<String> optifineVersionNames = new ArrayList<String>(versionsMap.keySet());
            PrintingUtils.printListItems(optifineVersionNames, true, 4, 3, true);
            String inputOFVersion = ExtraMerger.selectExtraVersion(CMCL.getString("INSTALL_MODLOADER_SELECT", EXTRA_NAME, optifineVersionNames.get(0)), versionsMap, (String)optifineVersionNames.get(0), EXTRA_NAME);
            if (inputOFVersion == null) {
                return new Pair<Boolean, Object>(false, null);
            }
            optifineVersionString = inputOFVersion;
            optifineVersion = (JSONObject)versionsMap.get(inputOFVersion);
            if (optifineVersion == null) {
                return new Pair<Boolean, Object>(false, null);
            }
        } else {
            optifineVersionString = extraVersion;
            optifineVersion = (JSONObject)versionsMap.get(extraVersion);
            if (optifineVersion == null) {
                System.out.println(CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", extraVersion).replace("${NAME}", EXTRA_NAME));
                return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", EXTRA_NAME)), null);
            }
        }
        try {
            return OptiFineMerger.installInternal(headJSONObject, optifineVersion, jarFile, optifineVersionString);
        }
        catch (ExceptionWithDescription e) {
            System.out.println(e.getMessage());
            return new Pair<Boolean, Object>(askContinue && InteractionUtils.yesOrNo(CMCL.getString("INSTALL_MODLOADER_UNABLE_DO_YOU_WANT_TO_CONTINUE", EXTRA_NAME)), null);
        }
    }

    public static Pair<Boolean, List<JSONObject>> installInternal(String minecraftVersion, String optiFineVersionString, JSONObject headJSONObject, File jarFile) throws ExceptionWithDescription {
        JSONArray versions;
        try {
            versions = new JSONArray(NetworkUtils.get(NetworkUtils.addSlashIfMissing(DownloadSource.getProvider().thirdPartyOptiFine()) + minecraftVersion));
        }
        catch (Exception e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_TO_GET_INSTALLABLE_VERSION", EXTRA_NAME));
        }
        if (versions.length() == 0) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_NO_INSTALLABLE_VERSION", EXTRA_NAME));
        }
        HashMap<String, JSONObject> versionsMap = new HashMap<String, JSONObject>();
        for (Object o : versions) {
            if (!(o instanceof JSONObject)) continue;
            JSONObject version = (JSONObject)o;
            String type = version.optString("type");
            String patch = version.optString("patch");
            versionsMap.put(type + (CMCL.isEmpty(patch) ? "" : "_" + patch), version);
        }
        JSONObject optifineVersion = (JSONObject)versionsMap.get(optiFineVersionString);
        if (optifineVersion == null) {
            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", optiFineVersionString).replace("${NAME}", EXTRA_NAME));
        }
        return OptiFineMerger.installInternal(headJSONObject, optifineVersion, jarFile, optiFineVersionString);
    }

    private static Pair<Boolean, List<JSONObject>> installInternal(JSONObject headJSONObject, JSONObject optiFineVersionJSONObject, File jarFile, String optiFineVersion) throws ExceptionWithDescription {
        String minecraftArguments;
        boolean containsLW;
        JSONArray librariesArray;
        String url;
        block35: {
            String patch = optiFineVersionJSONObject.optString("patch");
            String type = optiFineVersionJSONObject.optString("type");
            String mcversion = optiFineVersionJSONObject.optString("mcversion");
            url = DownloadSource.getProvider().thirdPartyOptiFine() + mcversion + "/" + type + "/" + patch;
            File installer = new SplitLibraryName("optifine", EXTRA_NAME, mcversion + "_" + type + "_" + patch, "installer").getPhysicalFile();
            System.out.print(CMCL.getString("INSTALL_MODLOADER_DOWNLOADING_FILE"));
            try {
                DownloadUtils.downloadFile(url, installer, new PercentageTextProgress());
            }
            catch (Exception e) {
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_DOWNLOAD", EXTRA_NAME) + ": " + e);
            }
            librariesArray = headJSONObject.optJSONArray("libraries");
            if (librariesArray == null) {
                librariesArray = new JSONArray();
                headJSONObject.put("libraries", librariesArray);
            }
            SplitLibraryName optifineFileName = new SplitLibraryName("optifine", EXTRA_NAME, mcversion + "_" + type + "_" + patch);
            librariesArray.put(new JSONObject().put("name", optifineFileName.toString()));
            File optifineFile = optifineFileName.getPhysicalFile();
            containsLW = false;
            try (JarFile installerJar = new JarFile(installer);){
                ZipEntry buildofText;
                Object s;
                ZipEntry lwOfTxt;
                block34: {
                    if (installerJar.getEntry("optifine/Patcher.class") != null) {
                        ArrayList<String> command = new ArrayList<String>(7);
                        command.add(JavaUtils.getDefaultJavaPath());
                        command.add("-cp");
                        command.add(installer.getAbsolutePath());
                        command.add("optifine.Patcher");
                        command.add(jarFile.getAbsolutePath());
                        command.add(installer.getAbsolutePath());
                        command.add(optifineFile.getAbsolutePath());
                        ProcessBuilder processBuilder = new ProcessBuilder(command);
                        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
                        try {
                            int waitFor = processBuilder.start().waitFor();
                            if (waitFor != 0) {
                                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", EXTRA_NAME, CMCL.getString("EXCEPTION_EXECUTE_COMMAND")));
                            }
                            break block34;
                        }
                        catch (Exception e) {
                            throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", EXTRA_NAME, e));
                        }
                    }
                    FileUtils.copyFile(installer, optifineFile);
                }
                ZipEntry lw2_0 = installerJar.getEntry("launchwrapper-2.0.jar");
                if (lw2_0 != null) {
                    SplitLibraryName s2 = new SplitLibraryName("optifine", "launchwrapper", "2.0");
                    librariesArray.put(new JSONObject().put("name", s2.toString()));
                    FileUtils.inputStream2File(installerJar.getInputStream(lw2_0), s2.getPhysicalFile());
                    containsLW = true;
                }
                if ((lwOfTxt = installerJar.getEntry("launchwrapper-of.txt")) != null) {
                    String launchWrapperVersion = Utils.inputStream2String(installerJar.getInputStream(lwOfTxt)).trim();
                    ZipEntry launchWrapperJar = installerJar.getEntry("launchwrapper-of-" + launchWrapperVersion + ".jar");
                    if (launchWrapperJar != null) {
                        s = new SplitLibraryName("optifine", "launchwrapper-of", launchWrapperVersion);
                        librariesArray.put(new JSONObject().put("name", ((SplitLibraryName)s).toString()));
                        FileUtils.inputStream2File(installerJar.getInputStream(launchWrapperJar), ((SplitLibraryName)s).getPhysicalFile());
                        containsLW = true;
                    }
                }
                if ((buildofText = installerJar.getEntry("buildof.txt")) == null) break block35;
                String buildof = Utils.inputStream2String(installerJar.getInputStream(buildofText)).trim();
                if (!"cpw.mods.bootstraplauncher.BootstrapLauncher".equals(headJSONObject.optString("mainClass"))) break block35;
                try {
                    s = buildof.split("-");
                    if (((String[])s).length >= 2 && (Integer.parseInt(s[0]) < 20210924 || Integer.parseInt((String)s[0]) == 20210924 && Integer.parseInt((String)s[1]) < 190833)) {
                        throw new ExceptionWithDescription(CMCL.getString("INSTALL_OPTIFINE_INCOMPATIBLE_WITH_FORGE_17"));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ExceptionWithDescription(CMCL.getString("INSTALL_MODLOADER_FAILED_WITH_REASON", EXTRA_NAME, e));
            }
        }
        LinkedList<JSONObject> returns = new LinkedList<JSONObject>();
        if (!containsLW) {
            SplitLibraryName s = new SplitLibraryName("net.minecraft", "launchwrapper", "1.12");
            JSONObject library = new JSONObject().put("name", s.toString());
            librariesArray.put(library);
            if (s.getPhysicalFile().length() == 0L) {
                returns.add(library);
            }
        }
        if (!CMCL.isEmpty(minecraftArguments = headJSONObject.optString("minecraftArguments"))) {
            headJSONObject.put("minecraftArguments", "--tweakClass optifine.OptiFineTweaker " + minecraftArguments);
        } else {
            JSONArray game;
            JSONObject arguments = headJSONObject.optJSONObject("arguments");
            if (arguments == null) {
                arguments = new JSONObject();
                headJSONObject.put("arguments", arguments);
            }
            if ((game = arguments.optJSONArray("game")) == null) {
                game = new JSONArray();
                arguments.put("game", game);
            }
            game.put("--tweakClass").put("optifine.OptiFineTweaker");
        }
        String mainClass = headJSONObject.optString("mainClass");
        if (!"cpw.mods.bootstraplauncher.BootstrapLauncher".equals(mainClass) && !"cpw.mods.modlauncher.Launcher".equals(mainClass)) {
            headJSONObject.put("mainClass", "net.minecraft.launchwrapper.Launch");
        }
        JSONObject optifine = new JSONObject();
        optifine.put("version", optiFineVersion);
        optifine.put("jarUrl", url);
        headJSONObject.put("optifine", optifine);
        return new Pair<Boolean, List<JSONObject>>(true, returns);
    }
}

