/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.modpack;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.exceptions.MissingElementException;
import com.mrshiehx.cmcl.functions.mod.ModpackFunction;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.modules.extra.fabric.FabricMerger;
import com.mrshiehx.cmcl.modules.extra.forge.ForgeMerger;
import com.mrshiehx.cmcl.modules.extra.quilt.QuiltMerger;
import com.mrshiehx.cmcl.modules.version.VersionInstaller;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.TextProgress;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.internet.ThreadsDownloader;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONObject;

public class CurseForgeModpackInstaller {
    public static void installCurseForgeModpack(JSONObject manifest, ZipFile zipFile, File modPackFile, File versionDir, boolean keepFile, boolean installAssets, boolean installNatives, boolean installLibraries, int threadCount) throws ExceptionWithDescription, IOException, ModpackFunction.NotValidModPackFormat {
        String overrides = NetworkUtils.addSlashIfMissing(manifest.optString("overrides"));
        zipFile.stream().forEach(zipEntry -> {
            if (!zipEntry.getName().startsWith(overrides)) {
                return;
            }
            File to = new File(versionDir, zipEntry.getName().substring(overrides.length()));
            if (zipEntry.isDirectory()) {
                to.mkdirs();
            } else {
                try {
                    FileUtils.inputStream2File(zipFile.getInputStream((ZipEntry)zipEntry), to);
                }
                catch (IOException e) {
                    System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", zipEntry.getName(), e));
                }
            }
        });
        JSONObject minecraft = manifest.optJSONObject("minecraft");
        if (minecraft == null) {
            throw new ModpackFunction.NotValidModPackFormat(new MissingElementException("minecraft", "JSONObject").getMessage());
        }
        String minecraftVersion = minecraft.optString("version");
        if (CMCL.isEmpty(minecraftVersion)) {
            throw new ModpackFunction.NotValidModPackFormat(new MissingElementException("version", "String").getMessage());
        }
        String modLoader = null;
        JSONArray modLoaders = minecraft.optJSONArray("modLoaders");
        if (modLoaders != null && modLoaders.length() > 0) {
            for (Object m : modLoaders) {
                if (!(m instanceof JSONObject)) continue;
                modLoader = ((JSONObject)m).optString("id");
            }
        }
        VersionInstaller.InstallForgeOrFabricOrQuilt installForgeOrFabricOrQuilt = null;
        VersionInstaller.Merger mergerForFabric = null;
        VersionInstaller.Merger mergerForQuilt = null;
        VersionInstaller.Merger mergerForForge = null;
        if (!CMCL.isEmpty(modLoader)) {
            String finalModLoaderVersion;
            String modLoaderVersion;
            if (modLoader.startsWith("forge-") && modLoader.length() > 6) {
                installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.FORGE;
                String finalModLoaderVersion1 = modLoaderVersion = modLoader.substring(6);
                mergerForForge = (minecraftVersion12, headJSONObject, minecraftJarFile, askContinue) -> {
                    Map<String, JSONObject> forges;
                    try {
                        forges = ForgeMerger.getInstallableForges(minecraftVersion12);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                        FileUtils.deleteDirectory(versionDir);
                        return new Pair<Boolean, Object>(false, null);
                    }
                    JSONObject forge = forges.get(finalModLoaderVersion1);
                    if (forge == null) {
                        System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", finalModLoaderVersion1).replace("${NAME}", "Forge")));
                        FileUtils.deleteDirectory(versionDir);
                        return new Pair<Boolean, Object>(false, null);
                    }
                    try {
                        return ForgeMerger.installInternal(forge, headJSONObject, minecraftVersion12, minecraftJarFile);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                        FileUtils.deleteDirectory(versionDir);
                        return new Pair<Boolean, Object>(false, null);
                    }
                };
            } else if (modLoader.startsWith("fabric-") && modLoader.length() > 7) {
                installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.FABRIC;
                finalModLoaderVersion = modLoaderVersion = modLoader.substring(7);
                mergerForFabric = (minecraftVersion1, headJSONObject, minecraftJarFile, askContinue) -> {
                    try {
                        return new FabricMerger().installInternal(minecraftVersion1, finalModLoaderVersion, headJSONObject);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                        FileUtils.deleteDirectory(versionDir);
                        return new Pair<Boolean, Object>(false, null);
                    }
                };
            } else if (modLoader.startsWith("quilt-") && modLoader.length() > 6) {
                installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.QUILT;
                finalModLoaderVersion = modLoaderVersion = modLoader.substring(6);
                mergerForQuilt = (minecraftVersion1, headJSONObject, minecraftJarFile, askContinue) -> {
                    try {
                        return new QuiltMerger().installInternal(minecraftVersion1, finalModLoaderVersion, headJSONObject);
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                        FileUtils.deleteDirectory(versionDir);
                        return new Pair<Boolean, Object>(false, null);
                    }
                };
            } else if (modLoader.startsWith("neoforge-") && modLoader.length() > 9) {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_NOT_SUPPORTED_NEOFORGE"));
                return;
            }
        }
        Void onFinished = () -> {
            JSONArray filesArray = manifest.optJSONArray("files");
            LinkedList<Pair<String, File>> files = new LinkedList<Pair<String, File>>();
            if (filesArray != null && filesArray.length() > 0) {
                System.out.print(CMCL.getString("INSTALL_MODPACK_EACH_MOD_GET_URL"));
                TextProgress textProgress = new TextProgress();
                textProgress.setMaximum(filesArray.length());
                for (int i = 0; i < filesArray.length(); ++i) {
                    Object o = filesArray.get(i);
                    if (!(o instanceof JSONObject)) continue;
                    JSONObject file = (JSONObject)o;
                    int fileID = file.optInt("fileID");
                    int projectID = file.optInt("projectID");
                    if (fileID == 0 || projectID == 0) continue;
                    try {
                        String fileDownloadUrl;
                        String fileName;
                        block10: {
                            try {
                                String url = "https://api.curseforge.com/v1/mods/" + projectID + "/files/" + fileID;
                                JSONObject jsonObject = new JSONObject(NetworkUtils.curseForgeGet(url)).optJSONObject("data");
                                fileName = jsonObject.optString("fileName");
                                fileDownloadUrl = jsonObject.optString("downloadUrl");
                                if (!CMCL.isEmpty(fileDownloadUrl)) break block10;
                                fileDownloadUrl = String.format("https://edge.forgecdn.net/files/%d/%d/%s", fileID / 1000, fileID % 1000, fileName);
                            }
                            catch (Exception e2) {
                                System.out.println(CMCL.getString("INSTALL_MODPACK_FAILED_DOWNLOAD_MOD", projectID, e2));
                                continue;
                            }
                        }
                        file.put("fileName", fileName);
                        file.put("url", fileDownloadUrl);
                        files.add(new Pair<String, File>(fileDownloadUrl, new File(versionDir, "mods/" + fileName)));
                        textProgress.setValue(i + 1);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(CMCL.getString("INSTALL_MODPACK_FAILED_DOWNLOAD_MOD", projectID, e));
                    }
                }
                textProgress.setValue(filesArray.length());
            }
            try {
                FileUtils.writeFile(new File(versionDir, "modpack.json"), manifest.toString(2), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Void onDownloaded = () -> {
                if (!keepFile) {
                    modPackFile.delete();
                }
                System.out.println(CMCL.getString("INSTALL_MODPACK_COMPLETE"));
            };
            Utils.close(zipFile);
            if (files.size() > 0) {
                ThreadsDownloader threadsDownloader = new ThreadsDownloader(files, onDownloaded, true);
                threadsDownloader.start();
            } else {
                onDownloaded.execute();
            }
        };
        File versionsFile = Utils.downloadVersionsFile();
        JSONArray versions = new JSONObject(FileUtils.readFileContent(versionsFile)).optJSONArray("versions");
        VersionInstaller.start(minecraftVersion, versionDir.getName(), versions, installAssets, installNatives, installLibraries, installForgeOrFabricOrQuilt, threadCount, mergerForFabric, mergerForForge, mergerForQuilt, null, null, onFinished, null, null);
    }

    public static int tryToInstallCurseForgeModpack(ZipFile zipFile, File file, File versionDir, boolean keepFile, boolean installAssets, boolean installNatives, boolean installLibraries, int threadCount) throws ModpackFunction.NotValidModPackFormat {
        ZipEntry entry = zipFile.getEntry("manifest.json");
        if (entry == null) {
            throw new ModpackFunction.NotValidModPackFormat("not a CurseForge modpack");
        }
        try {
            InputStream i = zipFile.getInputStream(entry);
            XJSONObject manifest = new XJSONObject(Utils.inputStream2String(i));
            CurseForgeModpackInstaller.installCurseForgeModpack(manifest, zipFile, file, versionDir, keepFile, installAssets, installNatives, installLibraries, threadCount);
        }
        catch (ModpackFunction.NotValidModPackFormat e) {
            FileUtils.deleteDirectory(versionDir);
            throw e;
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e));
            FileUtils.deleteDirectory(versionDir);
        }
        return 0;
    }
}

