/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.modpack;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.exceptions.MissingElementException;
import com.mrshiehx.cmcl.functions.mod.ModpackFunction;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.modules.extra.fabric.FabricMerger;
import com.mrshiehx.cmcl.modules.extra.forge.ForgeMerger;
import com.mrshiehx.cmcl.modules.extra.quilt.QuiltMerger;
import com.mrshiehx.cmcl.modules.version.VersionInstaller;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.ThreadsDownloader;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModrinthModpackInstaller {
    public static int installModrinthModpack(JSONObject manifest, ZipFile zipFile, File modPackFile, File versionDir, boolean keepFile, boolean installAssets, boolean installNatives, boolean installLibraries, int threadCount) throws ModpackFunction.NotValidModPackFormat, ExceptionWithDescription, IOException {
        String modLoaderVersion;
        zipFile.stream().forEach(zipEntry -> {
            String overrides;
            if (zipEntry.getName().startsWith("overrides")) {
                overrides = "overrides";
            } else if (zipEntry.getName().startsWith("client-overrides")) {
                overrides = "client-overrides";
            } else {
                return;
            }
            File to = new File(versionDir, zipEntry.getName().substring(overrides.length()));
            if (zipEntry.isDirectory()) {
                to.mkdirs();
            } else {
                try {
                    FileUtils.inputStream2File(zipFile.getInputStream((ZipEntry)zipEntry), to);
                }
                catch (IOException e) {
                    System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", zipEntry.getName(), e));
                }
            }
        });
        JSONObject dependencies = manifest.optJSONObject("dependencies");
        if (dependencies == null) {
            throw new ModpackFunction.NotValidModPackFormat(new MissingElementException("dependencies", "JSONObject").getMessage());
        }
        String gameVersion = null;
        String forgeVersion = null;
        String fabricVersion = null;
        String quiltVersion = null;
        String neoforgeVersion = null;
        block14: for (Map.Entry<String, Object> entry : dependencies.toMap().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String key = entry.getKey();
            String value = (String)entry.getValue();
            switch (key) {
                case "minecraft": {
                    gameVersion = value;
                    continue block14;
                }
                case "forge": {
                    forgeVersion = value;
                    continue block14;
                }
                case "fabric-loader": {
                    fabricVersion = value;
                    continue block14;
                }
                case "quilt-loader": {
                    quiltVersion = value;
                    continue block14;
                }
                case "neoforge": {
                    neoforgeVersion = value;
                    continue block14;
                }
            }
            System.out.println(CMCL.getString("INSTALL_MODPACK_MODRINTH_UNKNOWN_MODLOADER", key));
        }
        if (CMCL.isEmpty(gameVersion)) {
            throw new ModpackFunction.NotValidModPackFormat(CMCL.getString("MESSAGE_INSTALL_MODPACK_NOT_FOUND_GAME_VERSION"));
        }
        if (!Utils.isEmpty(neoforgeVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_NOT_SUPPORTED_NEOFORGE"));
            return -1;
        }
        if (!CMCL.isEmpty(forgeVersion) && !CMCL.isEmpty(fabricVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "Forge", "Fabric"));
            return -1;
        }
        if (!CMCL.isEmpty(quiltVersion) && !CMCL.isEmpty(fabricVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "Quilt", "Fabric"));
            return -1;
        }
        if (!CMCL.isEmpty(forgeVersion) && !CMCL.isEmpty(quiltVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "Forge", "Quilt"));
            return -1;
        }
        VersionInstaller.InstallForgeOrFabricOrQuilt installForgeOrFabricOrQuilt = null;
        VersionInstaller.Merger mergerForFabric = null;
        VersionInstaller.Merger mergerForForge = null;
        VersionInstaller.Merger mergerForQuilt = null;
        if (!CMCL.isEmpty(forgeVersion)) {
            installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.FORGE;
            String finalModLoaderVersion1 = modLoaderVersion = forgeVersion;
            mergerForForge = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                Map<String, JSONObject> forges;
                try {
                    forges = ForgeMerger.getInstallableForges(minecraftVersion);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
                JSONObject forge = forges.get(finalModLoaderVersion1);
                if (forge == null) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", finalModLoaderVersion1).replace("${NAME}", "Forge")));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
                try {
                    return ForgeMerger.installInternal(forge, headJSONObject, minecraftVersion, minecraftJarFile);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        } else if (!CMCL.isEmpty(fabricVersion)) {
            installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.FABRIC;
            String finalModLoaderVersion = modLoaderVersion = fabricVersion;
            mergerForFabric = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                try {
                    return new FabricMerger().installInternal(minecraftVersion, finalModLoaderVersion, headJSONObject);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        } else if (!CMCL.isEmpty(quiltVersion)) {
            installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.QUILT;
            String finalModLoaderVersion = modLoaderVersion = quiltVersion;
            mergerForQuilt = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                try {
                    return new QuiltMerger().installInternal(minecraftVersion, finalModLoaderVersion, headJSONObject);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        }
        Void onFinished = () -> {
            JSONArray files = manifest.optJSONArray("files");
            if (files != null && files.length() > 0) {
                LinkedList<Pair<String, File>> filess = new LinkedList<Pair<String, File>>();
                for (int i = 0; i < files.length(); ++i) {
                    Object o = files.get(i);
                    if (!(o instanceof JSONObject)) continue;
                    JSONObject file = (JSONObject)o;
                    String path = file.optString("path");
                    JSONArray downloads = file.optJSONArray("downloads");
                    String url = null;
                    if (downloads != null) {
                        for (Object download : downloads) {
                            if (!(download instanceof String)) continue;
                            url = (String)download;
                        }
                    }
                    if (CMCL.isEmpty(url) || CMCL.isEmpty(path)) continue;
                    filess.add(new Pair<String, File>(url, new File(versionDir, path)));
                }
                if (filess.size() > 0) {
                    ThreadsDownloader threadsDownloader = new ThreadsDownloader(filess, true);
                    threadsDownloader.start();
                }
            }
            try {
                FileUtils.writeFile(new File(versionDir, "modpack.json"), manifest.toString(2), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!keepFile) {
                Utils.close(zipFile);
                modPackFile.delete();
            }
            System.out.println(CMCL.getString("INSTALL_MODPACK_COMPLETE"));
        };
        File versionsFile = Utils.downloadVersionsFile();
        JSONArray versions = new JSONObject(FileUtils.readFileContent(versionsFile)).optJSONArray("versions");
        VersionInstaller.start(gameVersion, versionDir.getName(), versions, installAssets, installNatives, installLibraries, installForgeOrFabricOrQuilt, threadCount, mergerForFabric, mergerForForge, mergerForQuilt, null, null, onFinished, null, null);
        return 0;
    }

    public static int tryToInstallModrinthModpack(ZipFile zipFile, File file, File versionDir, boolean keepFile, boolean installAssets, boolean installNatives, boolean installLibraries, int threadCount) throws ModpackFunction.NotValidModPackFormat {
        ZipEntry entry = zipFile.getEntry("modrinth.index.json");
        if (entry == null) {
            throw new ModpackFunction.NotValidModPackFormat("not a Modrinth modpack");
        }
        try {
            InputStream i = zipFile.getInputStream(entry);
            XJSONObject manifest = new XJSONObject(Utils.inputStream2String(i));
            return ModrinthModpackInstaller.installModrinthModpack(manifest, zipFile, file, versionDir, keepFile, installAssets, installNatives, installLibraries, threadCount);
        }
        catch (ModpackFunction.NotValidModPackFormat e) {
            FileUtils.deleteDirectory(versionDir);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e));
            FileUtils.deleteDirectory(versionDir);
            return 0;
        }
    }
}

