/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.modpack;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.functions.mod.ModpackFunction;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.modules.extra.fabric.FabricMerger;
import com.mrshiehx.cmcl.modules.extra.forge.ForgeMerger;
import com.mrshiehx.cmcl.modules.extra.liteloader.LiteloaderMerger;
import com.mrshiehx.cmcl.modules.extra.quilt.QuiltMerger;
import com.mrshiehx.cmcl.modules.version.VersionInstaller;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONObject;

public class MultiMCModpackInstaller {
    public static int tryToInstallMultiMCModpack(ZipFile zipFile, File file, File versionDir, boolean keepFile, boolean installAssets, boolean installNatives, boolean installLibraries, int threadCount) throws ModpackFunction.NotValidModPackFormat {
        String finalModLoaderVersion;
        JSONObject mmcPackJSON;
        String instanceFileName = "instance.cfg";
        String modpackName = null;
        ZipEntry instanceCFGEntry = zipFile.getEntry(instanceFileName);
        if (instanceCFGEntry != null) {
            modpackName = "";
        } else {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry a;
                String entryName;
                int idx;
                ZipEntry entry = entries.nextElement();
                if (!(entry instanceof ZipEntry) || (idx = (entryName = (a = entry).getName()).indexOf(47)) < 0 || entryName.length() != idx + instanceFileName.length() + 1 || !entryName.startsWith(instanceFileName, idx + 1)) continue;
                modpackName = entryName.substring(0, idx + 1);
                instanceCFGEntry = a;
                break;
            }
        }
        if (modpackName == null) {
            throw new ModpackFunction.NotValidModPackFormat("not a MultiMC modpack");
        }
        ZipEntry mmcPack = zipFile.getEntry(modpackName + "mmc-pack.json");
        if (mmcPack == null) {
            throw new ModpackFunction.NotValidModPackFormat("not a MultiMC modpack");
        }
        try {
            mmcPackJSON = new JSONObject(Utils.inputStream2String(zipFile.getInputStream(mmcPack)));
        }
        catch (Exception e) {
            throw new ModpackFunction.NotValidModPackFormat(e.getMessage());
        }
        Properties instanceCFG = new Properties();
        try {
            instanceCFG.load(new InputStreamReader(zipFile.getInputStream(instanceCFGEntry), StandardCharsets.UTF_8));
        }
        catch (Exception entryName) {
            // empty catch block
        }
        JSONArray components = mmcPackJSON.optJSONArray("components");
        String gameVersion = null;
        String forgeVersion = null;
        String liteloaderVersion = null;
        String fabricVersion = null;
        String quiltVersion = null;
        String neoforgeVersion = null;
        if (components != null) {
            for (Object o : components) {
                JSONObject jsonObject;
                String version;
                if (!(o instanceof JSONObject) || CMCL.isEmpty(version = (jsonObject = (JSONObject)o).optString("version"))) continue;
                switch (jsonObject.optString("uid")) {
                    case "net.minecraft": {
                        gameVersion = version;
                        break;
                    }
                    case "net.minecraftforge": {
                        forgeVersion = version;
                        break;
                    }
                    case "com.mumfrey.liteloader": {
                        liteloaderVersion = version;
                        break;
                    }
                    case "net.fabricmc.fabric-loader": {
                        fabricVersion = version;
                        break;
                    }
                    case "org.quiltmc.quilt-loader": {
                        quiltVersion = version;
                        break;
                    }
                    case "net.neoforged": {
                        neoforgeVersion = version;
                    }
                }
            }
        }
        if (CMCL.isEmpty(gameVersion)) {
            throw new ModpackFunction.NotValidModPackFormat(CMCL.getString("MESSAGE_INSTALL_MODPACK_NOT_FOUND_GAME_VERSION"));
        }
        if (!Utils.isEmpty(neoforgeVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_NOT_SUPPORTED_NEOFORGE"));
            return -1;
        }
        if (!CMCL.isEmpty(forgeVersion) && !CMCL.isEmpty(fabricVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "Forge", "Fabric"));
            return -1;
        }
        if (!CMCL.isEmpty(liteloaderVersion) && !CMCL.isEmpty(fabricVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "LiteLoader", "Fabric"));
            return -1;
        }
        if (!CMCL.isEmpty(forgeVersion) && !CMCL.isEmpty(quiltVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "Forge", "Quilt"));
            return -1;
        }
        if (!CMCL.isEmpty(liteloaderVersion) && !CMCL.isEmpty(quiltVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "LiteLoader", "Quilt"));
            return -1;
        }
        if (!CMCL.isEmpty(fabricVersion) && !CMCL.isEmpty(quiltVersion)) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_MODPACK_COEXIST", "Fabric", "Quilt"));
            return -1;
        }
        String finalModpackName = modpackName;
        zipFile.stream().forEach(zipEntry -> {
            int start;
            if (zipEntry.getName().startsWith(finalModpackName + ".minecraft/")) {
                start = (finalModpackName + ".minecraft/").length();
            } else if (zipEntry.getName().startsWith(finalModpackName + "minecraft/")) {
                start = (finalModpackName + "minecraft/").length();
            } else {
                return;
            }
            File to = new File(versionDir, zipEntry.getName().substring(start));
            if (zipEntry.isDirectory()) {
                to.mkdirs();
            } else {
                try {
                    FileUtils.inputStream2File(zipFile.getInputStream((ZipEntry)zipEntry), to);
                }
                catch (IOException e) {
                    System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", zipEntry.getName(), e));
                }
            }
        });
        VersionInstaller.InstallForgeOrFabricOrQuilt installForgeOrFabricOrQuilt = null;
        VersionInstaller.Merger mergerForFabric = null;
        VersionInstaller.Merger mergerForForge = null;
        VersionInstaller.Merger mergerForQuilt = null;
        VersionInstaller.Merger mergerForLiteLoader = null;
        if (!CMCL.isEmpty(forgeVersion)) {
            installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.FORGE;
            String finalForgeVersion = forgeVersion;
            mergerForForge = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                Map<String, JSONObject> forges;
                try {
                    forges = ForgeMerger.getInstallableForges(minecraftVersion);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
                JSONObject forge = forges.get(finalForgeVersion);
                if (forge == null) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", CMCL.getString("INSTALL_MODLOADER_FAILED_NOT_FOUND_TARGET_VERSION", finalForgeVersion).replace("${NAME}", "Forge")));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
                try {
                    return ForgeMerger.installInternal(forge, headJSONObject, minecraftVersion, minecraftJarFile);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        } else if (!CMCL.isEmpty(fabricVersion)) {
            installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.FABRIC;
            finalModLoaderVersion = fabricVersion;
            mergerForFabric = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                try {
                    return new FabricMerger().installInternal(minecraftVersion, finalModLoaderVersion, headJSONObject);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        } else if (!CMCL.isEmpty(quiltVersion)) {
            installForgeOrFabricOrQuilt = VersionInstaller.InstallForgeOrFabricOrQuilt.QUILT;
            finalModLoaderVersion = quiltVersion;
            mergerForQuilt = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                try {
                    return new QuiltMerger().installInternal(minecraftVersion, finalModLoaderVersion, headJSONObject);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        }
        if (!CMCL.isEmpty(liteloaderVersion)) {
            finalModLoaderVersion = liteloaderVersion;
            mergerForLiteLoader = (minecraftVersion, headJSONObject, minecraftJarFile, askContinue) -> {
                try {
                    return LiteloaderMerger.installInternal(minecraftVersion, finalModLoaderVersion, headJSONObject);
                }
                catch (Exception e) {
                    System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e.getMessage()));
                    FileUtils.deleteDirectory(versionDir);
                    return new Pair<Boolean, Object>(false, null);
                }
            };
        }
        Void onFinished = () -> {
            try {
                FileUtils.writeFile(new File(versionDir, "modpack.json"), new XJSONObject().put("type", "MultiMC").put("mmcPack", mmcPackJSON).put("instanceConfig", instanceCFG).toString(2), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!keepFile) {
                Utils.close(zipFile);
                file.delete();
            }
            System.out.println(CMCL.getString("INSTALL_MODPACK_COMPLETE"));
        };
        try {
            File versionsFile = Utils.downloadVersionsFile();
            JSONArray versions = new JSONObject(FileUtils.readFileContent(versionsFile)).optJSONArray("versions");
            VersionInstaller.start(gameVersion, versionDir.getName(), versions, installAssets, installNatives, installLibraries, installForgeOrFabricOrQuilt, threadCount, mergerForFabric, mergerForForge, mergerForQuilt, mergerForLiteLoader, null, onFinished, null, null);
        }
        catch (Exception e) {
            System.out.println(CMCL.getString("EXCEPTION_INSTALL_MODPACK", e));
            FileUtils.deleteDirectory(versionDir);
            return -1;
        }
        return 0;
    }
}

