/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.version;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.GameVersion;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionModuleUtils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONObject;

public class PrintVersionInfo {
    public static void execute(File jsonFile, File jarFile, File versionDir, String versionName) {
        try {
            String neoForgeVersion;
            String quiltVersion;
            String optiFineVersion;
            String liteloaderVersion;
            String forgeVersion;
            String fabricVersion;
            JSONObject javaVersion;
            String releaseTime;
            String assets;
            JSONObject head = new JSONObject(FileUtils.readFileContent(jsonFile));
            LinkedHashMap<String, String> information = new LinkedHashMap<String, String>();
            GameVersion gameVersion = VersionUtils.getGameVersion(head, jarFile);
            if (!Utils.isEmpty(gameVersion.id) && Utils.isEmpty(gameVersion.name)) {
                information.put(CMCL.getString("VERSION_INFORMATION_GAME_VERSION"), gameVersion.id);
            } else if (Utils.isEmpty(gameVersion.id) && !Utils.isEmpty(gameVersion.name)) {
                information.put(CMCL.getString("VERSION_INFORMATION_GAME_VERSION"), gameVersion.name);
            } else if (!Utils.isEmpty(gameVersion.id) && !Utils.isEmpty(gameVersion.name)) {
                if (gameVersion.name.equals(gameVersion.id)) {
                    information.put(CMCL.getString("VERSION_INFORMATION_GAME_VERSION"), gameVersion.name);
                } else {
                    information.put(CMCL.getString("VERSION_INFORMATION_GAME_VERSION"), gameVersion.name + " (" + gameVersion.id + ")");
                }
            } else {
                information.put(CMCL.getString("VERSION_INFORMATION_GAME_VERSION"), CMCL.getString("VERSION_INFORMATION_GAME_VERSION_FAILED_GET"));
            }
            information.put(CMCL.getString("VERSION_INFORMATION_VERSION_PATH"), versionDir.getAbsolutePath());
            String type = head.optString("type");
            if (!CMCL.isEmpty(type)) {
                switch (type) {
                    case "release": {
                        information.put(CMCL.getString("VERSION_INFORMATION_VERSION_TYPE"), CMCL.getString("VERSION_INFORMATION_VERSION_TYPE_RELEASE"));
                        break;
                    }
                    case "snapshot": {
                        information.put(CMCL.getString("VERSION_INFORMATION_VERSION_TYPE"), CMCL.getString("VERSION_INFORMATION_VERSION_TYPE_SNAPSHOT"));
                        break;
                    }
                    case "old_beta": {
                        information.put(CMCL.getString("VERSION_INFORMATION_VERSION_TYPE"), CMCL.getString("VERSION_INFORMATION_VERSION_TYPE_OLD_BETA"));
                        break;
                    }
                    case "old_alpha": {
                        information.put(CMCL.getString("VERSION_INFORMATION_VERSION_TYPE"), CMCL.getString("VERSION_INFORMATION_VERSION_TYPE_OLD_ALPHA"));
                    }
                }
            }
            if (!CMCL.isEmpty(assets = head.optString("assets"))) {
                information.put(CMCL.getString("VERSION_INFORMATION_ASSETS_VERSION"), assets);
            }
            if (!CMCL.isEmpty(releaseTime = head.optString("releaseTime"))) {
                SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                Date parse = null;
                try {
                    parse = iso8601.parse(releaseTime);
                }
                catch (Exception e) {
                    try {
                        releaseTime = releaseTime.substring(0, 22) + releaseTime.substring(23);
                        parse = iso8601.parse(releaseTime);
                    }
                    catch (Exception e1) {
                        information.put(CMCL.getString("VERSION_INFORMATION_RELEASE_TIME"), CMCL.getString("EXCEPTION_UNABLE_PARSE"));
                    }
                }
                if (parse != null) {
                    SimpleDateFormat format = new SimpleDateFormat(CMCL.getString("TIME_FORMAT"), CMCL.getLocale());
                    information.put(CMCL.getString("VERSION_INFORMATION_RELEASE_TIME"), format.format(parse) + " (" + TimeZone.getDefault().getDisplayName() + ")");
                }
            }
            if ((javaVersion = head.optJSONObject("javaVersion")) != null) {
                String majorVersion;
                String component = javaVersion.optString("component");
                if (!CMCL.isEmpty(component)) {
                    information.put(CMCL.getString("VERSION_INFORMATION_JAVA_COMPONENT"), component);
                }
                if (!CMCL.isEmpty(majorVersion = javaVersion.optString("majorVersion"))) {
                    information.put(CMCL.getString("VERSION_INFORMATION_JAVA_VERSION"), majorVersion);
                }
            }
            if (!CMCL.isEmpty(fabricVersion = VersionModuleUtils.getFabricVersion(head))) {
                information.put(CMCL.getString("VERSION_INFORMATION_FABRIC_VERSION"), fabricVersion);
            }
            if (!CMCL.isEmpty(forgeVersion = VersionModuleUtils.getForgeVersion(head))) {
                information.put(CMCL.getString("VERSION_INFORMATION_FORGE_VERSION"), forgeVersion);
            }
            if (!CMCL.isEmpty(liteloaderVersion = VersionModuleUtils.getLiteloaderVersion(head))) {
                information.put(CMCL.getString("VERSION_INFORMATION_LITELOADER_VERSION"), liteloaderVersion);
            }
            if (!CMCL.isEmpty(optiFineVersion = VersionModuleUtils.getOptifineVersion(head))) {
                information.put(CMCL.getString("VERSION_INFORMATION_OPTIFINE_VERSION"), optiFineVersion);
            }
            if (!CMCL.isEmpty(quiltVersion = VersionModuleUtils.getQuiltVersion(head))) {
                information.put(CMCL.getString("VERSION_INFORMATION_QUILT_VERSION"), quiltVersion);
            }
            if (!CMCL.isEmpty(neoForgeVersion = VersionModuleUtils.getNeoForgeVersion(head))) {
                information.put(CMCL.getString("VERSION_INFORMATION_NEOFORGE_VERSION"), neoForgeVersion);
            }
            System.out.println(versionName + ":");
            for (Map.Entry entry : information.entrySet()) {
                System.out.print((String)entry.getKey());
                System.out.println((String)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(CMCL.getString("UNABLE_GET_VERSION_INFORMATION"));
        }
    }
}

