/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.version;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.arguments.Arguments;
import com.mrshiehx.cmcl.modules.version.VersionInstaller;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionModuleUtils;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionCompleter {
    public static void execute(File jsonFile, File jarFile, String versionName) {
        JSONObject headJSONObjectIC;
        String headJSONObjectICContent;
        try {
            headJSONObjectICContent = FileUtils.readFileContent(jsonFile);
            headJSONObjectIC = new JSONObject(headJSONObjectICContent);
        }
        catch (IOException e) {
            System.out.println(CMCL.getString("EXCEPTION_READ_FILE_WITH_PATH", jsonFile.getAbsolutePath()));
            return;
        }
        String inheritsFrom = headJSONObjectIC.optString("inheritsFrom");
        if (CMCL.isEmpty(inheritsFrom)) {
            System.out.println(CMCL.getString("MESSAGE_COMPLETE_VERSION_IS_COMPLETE"));
            return;
        }
        byte[] jarFileContent = null;
        if (jarFile.exists()) {
            try {
                jarFileContent = FileUtils.getBytes(jarFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            VersionInstaller.start(inheritsFrom, versionName, new JSONObject(FileUtils.readFileContent(Utils.downloadVersionsFile())).optJSONArray("versions"), true, true, true, null, 64, null, null, null, null, null, () -> System.out.println(CMCL.getString("MESSAGE_COMPLETED_VERSION")), headJSONObject -> {
                String neoForgeVersion;
                String quiltVersion;
                String optifineVersion;
                String liteloaderVersion;
                String forgeVersion;
                JSONArray libraries;
                String mainClass = headJSONObjectIC.optString("mainClass");
                if (!CMCL.isEmpty(mainClass)) {
                    headJSONObject.put("mainClass", mainClass);
                }
                String minecraftArguments = headJSONObjectIC.optString("minecraftArguments");
                JSONObject arguments3 = headJSONObjectIC.optJSONObject("arguments");
                if (!CMCL.isEmpty(minecraftArguments)) {
                    String hmca = headJSONObject.optString("minecraftArguments");
                    if (hmca.isEmpty()) {
                        headJSONObject.put("minecraftArguments", minecraftArguments);
                    } else {
                        Arguments arguments1 = new Arguments(hmca, false);
                        Arguments arguments2 = new Arguments(minecraftArguments, false);
                        arguments1.merge(arguments2);
                        minecraftArguments = arguments1.toString("--");
                        headJSONObject.put("minecraftArguments", minecraftArguments);
                    }
                }
                if (arguments3 != null) {
                    JSONObject argumentsMC = headJSONObject.optJSONObject("arguments");
                    if (argumentsMC != null) {
                        JSONArray jvm;
                        JSONArray gameMC = argumentsMC.optJSONArray("game");
                        JSONArray jvmMC = argumentsMC.optJSONArray("jvm");
                        JSONArray game = arguments3.optJSONArray("game");
                        if (game != null && game.length() > 0) {
                            if (gameMC == null) {
                                gameMC = new JSONArray();
                                argumentsMC.put("game", gameMC);
                            }
                            gameMC.putAll(game);
                        }
                        if ((jvm = arguments3.optJSONArray("jvm")) != null && jvm.length() > 0) {
                            if (jvmMC == null) {
                                jvmMC = new JSONArray();
                                argumentsMC.put("jvm", jvmMC);
                            }
                            jvmMC.putAll(jvm);
                        }
                    } else {
                        headJSONObject.put("arguments", arguments3);
                    }
                }
                if ((libraries = headJSONObject.optJSONArray("libraries")) == null) {
                    libraries = new JSONArray();
                    headJSONObject.put("libraries", libraries);
                }
                libraries.putAll(headJSONObjectIC.optJSONArray("libraries"));
                String fabricVersion = VersionModuleUtils.getFabricVersion(headJSONObject);
                if (!CMCL.isEmpty(fabricVersion)) {
                    headJSONObject.put("fabric", new JSONObject().put("version", fabricVersion));
                }
                if (!CMCL.isEmpty(forgeVersion = VersionModuleUtils.getForgeVersion(headJSONObject))) {
                    headJSONObject.put("forge", new JSONObject().put("version", forgeVersion));
                }
                if (!CMCL.isEmpty(liteloaderVersion = VersionModuleUtils.getLiteloaderVersion(headJSONObject))) {
                    headJSONObject.put("liteloader", new JSONObject().put("version", liteloaderVersion));
                }
                if (!CMCL.isEmpty(optifineVersion = VersionModuleUtils.getOptifineVersion(headJSONObject))) {
                    headJSONObject.put("optifine", new JSONObject().put("version", optifineVersion));
                }
                if (!CMCL.isEmpty(quiltVersion = VersionModuleUtils.getQuiltVersion(headJSONObject))) {
                    headJSONObject.put("quilt", new JSONObject().put("version", quiltVersion));
                }
                if (!CMCL.isEmpty(neoForgeVersion = VersionModuleUtils.getNeoForgeVersion(headJSONObject))) {
                    headJSONObject.put("neoforge", new JSONObject().put("version", neoForgeVersion));
                }
            }, null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            try {
                FileUtils.writeFile(jsonFile, headJSONObjectICContent, false);
                if (jarFileContent == null) {
                    jarFile.delete();
                } else {
                    FileUtils.bytes2File(jarFile, jarFileContent, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

