/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.version;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.modules.MinecraftLauncher;
import com.mrshiehx.cmcl.modules.version.downloaders.AssetsDownloader;
import com.mrshiehx.cmcl.modules.version.downloaders.NativesDownloader;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionLibraryUtils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import com.mrshiehx.cmcl.utils.json.XJSONObject;
import com.mrshiehx.cmcl.utils.system.OperatingSystem;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionInstaller {
    public static void start(String versionName, String storage, JSONArray versions, boolean installAssets, boolean installNatives, boolean installLibraries, InstallForgeOrFabricOrQuilt installForgeOrFabricOrQuilt, int threadCount, Merger fabricMerger, Merger forgeMerger, Merger quiltMerger, Merger liteLoaderMerger, Merger optiFineMerger, @Nullable Void onFinished, @Nullable VersionJSONMerger versionJSONMerger, JSONArray librariesToBeMerged) throws ExceptionWithDescription {
        JSONObject downloadsJo;
        JSONObject clientJo;
        XJSONObject headVersionFile;
        File cmcl = CMCL.getCMCLWorkingDirectory();
        cmcl.mkdirs();
        if (versions == null || versions.length() == 0) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_VERSIONS_LIST_IS_EMPTY"));
        }
        String url = null;
        for (Object o : versions) {
            JSONObject j;
            if (!(o instanceof JSONObject) || !Objects.equals(versionName, (j = (JSONObject)o).optString("id"))) continue;
            url = j.optString("url");
            break;
        }
        if (CMCL.isEmpty(url)) {
            throw new ExceptionWithDescription(CMCL.getString("EXCEPTION_VERSION_NOT_FOUND", versionName));
        }
        url = url.replace("https://launchermeta.mojang.com/", DownloadSource.getProvider().versionJSON()).replace("https://piston-meta.mojang.com/", DownloadSource.getProvider().versionJSON());
        File versionDir = new File(CMCL.versionsDir, storage);
        versionDir.mkdirs();
        File jsonFile = new File(versionDir, storage + ".json");
        File jarFile = new File(versionDir, storage + ".jar");
        if (jsonFile.exists()) {
            jsonFile.delete();
        }
        try {
            byte[] versionJSONBytes = DownloadUtils.downloadBytes(url);
            headVersionFile = new XJSONObject(new String(versionJSONBytes));
            headVersionFile.put("gameVersion", headVersionFile.optString("id"));
            headVersionFile.put("id", storage);
        }
        catch (IOException e) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_FAILED_TO_CONTROL_VERSION_JSON_FILE", e));
        }
        if (installForgeOrFabricOrQuilt == InstallForgeOrFabricOrQuilt.FABRIC ? fabricMerger.merge(versionName, headVersionFile, jarFile, true).getKey() == false : installForgeOrFabricOrQuilt == InstallForgeOrFabricOrQuilt.QUILT && quiltMerger.merge(versionName, headVersionFile, jarFile, true).getKey() == false) {
            return;
        }
        if (versionJSONMerger != null) {
            versionJSONMerger.merge(headVersionFile);
        }
        JSONObject jSONObject = clientJo = (downloadsJo = headVersionFile.optJSONObject("downloads")) != null ? downloadsJo.optJSONObject("client") : null;
        if (downloadsJo == null) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_INSTALL_NOT_FOUND_JAR_FILE_DOWNLOAD_INFO"));
        }
        if (clientJo == null) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_INSTALL_NOT_FOUND_JAR_FILE_DOWNLOAD_INFO"));
        }
        String urlClient = clientJo.optString("url").replace("https://launcher.mojang.com/", DownloadSource.getProvider().versionClient());
        if (CMCL.isEmpty(urlClient)) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_INSTALL_JAR_FILE_DOWNLOAD_URL_EMPTY"));
        }
        try {
            System.out.print(CMCL.getString("MESSAGE_INSTALL_DOWNLOADING_JAR_FILE"));
            jarFile.createNewFile();
            try {
                DownloadUtils.downloadFile(urlClient, jarFile, new PercentageTextProgress());
            }
            catch (Exception e) {
                FileUtils.deleteDirectory(versionDir);
                throw new ExceptionWithDescription(CMCL.getString("MESSAGE_FAILED_DOWNLOAD_FILE", urlClient));
            }
            System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADED_JAR_FILE"));
            if (installForgeOrFabricOrQuilt == InstallForgeOrFabricOrQuilt.FORGE) {
                System.out.println(CMCL.getString("MESSAGE_START_INSTALLING_FORGE"));
                if (!forgeMerger.merge(versionName, headVersionFile, jarFile, true).getKey().booleanValue()) {
                    return;
                }
                System.out.println(CMCL.getString("MESSAGE_INSTALLED_FORGE"));
            }
            if (liteLoaderMerger != null) {
                System.out.println(CMCL.getString("MESSAGE_START_INSTALLING_LITELOADER"));
                if (!liteLoaderMerger.merge(versionName, headVersionFile, jarFile, true).getKey().booleanValue()) {
                    return;
                }
                System.out.println(CMCL.getString("MESSAGE_INSTALLED_LITELOADER"));
            }
            if (optiFineMerger != null) {
                System.out.println(CMCL.getString("MESSAGE_START_INSTALLING_OPTIFINE"));
                if (!optiFineMerger.merge(versionName, headVersionFile, jarFile, true).getKey().booleanValue()) {
                    return;
                }
                System.out.println(CMCL.getString("MESSAGE_INSTALLED_OPTIFINE"));
            }
            jsonFile.createNewFile();
            List<JSONObject> toBeMerged = JSONUtils.jsonArrayToJSONObjectList(librariesToBeMerged);
            if (toBeMerged.size() > 0) {
                headVersionFile.put("libraries", VersionLibraryUtils.mergeLibraries(JSONUtils.jsonArrayToJSONObjectList(headVersionFile.optJSONArray("libraries")), toBeMerged));
            }
            try {
                FileUtils.writeFile(jsonFile, headVersionFile.toString(2), false);
            }
            catch (Exception e) {
                FileUtils.deleteDirectory(versionDir);
                throw e;
            }
            File librariesDir = new File(CMCL.gameDir, "libraries");
            File nativesDir = new File(versionDir, VersionUtils.getNativesDirName());
            File tempNatives = new File(cmcl, "temp_natives");
            CMCL.createLauncherProfiles();
            if (installLibraries || installNatives) {
                VersionInstaller.downloadLibrariesAndNatives(installNatives, installLibraries, tempNatives, librariesDir, nativesDir, headVersionFile);
            }
            if (installAssets) {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADING_ASSETS"));
                AssetsDownloader.start(headVersionFile, threadCount, () -> {
                    System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADED_ASSETS"));
                    if (onFinished != null) {
                        onFinished.execute();
                    }
                });
            } else if (onFinished != null) {
                onFinished.execute();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_FAILED_TO_INSTALL_NEW_VERSION", ex));
        }
    }

    private static void downloadLibrariesAndNatives(boolean installNatives, boolean installLibraries, File tempNatives, File librariesDir, File nativesDir, JSONObject headVersionFile) {
        System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADING_LIBRARIES"));
        try {
            JSONArray librariesJa = headVersionFile.optJSONArray("libraries");
            if (librariesJa == null || librariesJa.length() == 0) {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_LIBRARIES_LIST_EMPTY"));
                return;
            }
            ArrayList<String> nativesNames = new ArrayList<String>();
            for (int i = 0; i < librariesJa.length(); ++i) {
                JSONObject nativesJo;
                JSONObject nativesNamesJO;
                JSONObject classifiersJo;
                JSONObject downloadsJo1;
                Pair<String, String> pair;
                JSONObject jsonObject = librariesJa.optJSONObject(i);
                if (jsonObject == null) continue;
                boolean meet = true;
                JSONArray rules = jsonObject.optJSONArray("rules");
                if (rules != null) {
                    meet = MinecraftLauncher.isMeetConditions(rules, Collections.emptyMap());
                }
                if (!meet) continue;
                if (installLibraries && (pair = VersionLibraryUtils.getLibraryDownloadURLAndStoragePath(jsonObject)) != null) {
                    String path = pair.getValue();
                    String url1 = pair.getKey();
                    if (!CMCL.isEmpty(url1)) {
                        File file = new File(librariesDir, path);
                        try {
                            file.getParentFile().mkdirs();
                            if (!file.exists()) {
                                file.createNewFile();
                            }
                            if (file.length() == 0L) {
                                System.out.print(CMCL.getString("MESSAGE_DOWNLOADING_FILE", url1.substring(url1.lastIndexOf("/") + 1)));
                                DownloadUtils.downloadFile(url1, file, new PercentageTextProgress());
                            }
                        }
                        catch (Exception e1) {
                            Utils.downloadFileFailed(url1, file, e1);
                        }
                    } else if (!jsonObject.optString("name").startsWith("net.minecraftforge:forge:")) {
                        System.out.println(CMCL.getString("MESSAGE_NOT_FOUND_LIBRARY_DOWNLOAD_URL", jsonObject.optString("name")));
                    }
                }
                if (!installNatives || (downloadsJo1 = jsonObject.optJSONObject("downloads")) == null || (classifiersJo = downloadsJo1.optJSONObject("classifiers")) == null || (nativesNamesJO = jsonObject.optJSONObject("natives")) == null || (nativesJo = classifiersJo.optJSONObject(nativesNamesJO.optString(OperatingSystem.CURRENT_OS.getCheckedName().replace("${arch}", SystemUtils.getArchInt())))) == null) continue;
                NativesDownloader.downloadSingleNative(tempNatives, nativesJo, nativesNames);
            }
            System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADED_LIBRARIES"));
        }
        catch (Exception e1) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_FAILED_TO_DOWNLOAD_LIBRARIES", e1));
        }
        if (installNatives) {
            NativesDownloader.unzip(tempNatives, nativesDir);
        }
    }

    private static boolean checkNetwork(String urla) {
        try {
            URL url = new URL(urla);
            try {
                URLConnection co = url.openConnection();
                co.setConnectTimeout(12000);
                co.connect();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static interface VersionJSONMerger {
        public void merge(JSONObject var1);
    }

    public static interface Merger {
        public Pair<Boolean, List<JSONObject>> merge(String var1, JSONObject var2, File var3, boolean var4);
    }

    public static enum InstallForgeOrFabricOrQuilt {
        FORGE,
        FABRIC,
        QUILT;

    }
}

