/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.version.downloaders;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.ExceptionWithDescription;
import com.mrshiehx.cmcl.interfaces.Void;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.internet.ThreadsDownloader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssetsDownloader {
    public static void start(JSONObject headVersionFile, int threadCount, Void onDownloaded) throws ExceptionWithDescription {
        String assetIndexUrl;
        String assetsDirPath = Utils.getConfig().optString("assetsPath");
        File assetsDir = !Utils.isEmpty(assetsDirPath) ? new File(assetsDirPath) : new File(CMCL.gameDir, "assets");
        File indexesDir = new File(assetsDir, "indexes");
        File objectsDir = new File(assetsDir, "objects");
        assetsDir.mkdirs();
        indexesDir.mkdirs();
        objectsDir.mkdirs();
        String assetsIndex = headVersionFile.optString("assets");
        if (CMCL.isEmpty(assetsIndex)) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_INSTALL_DOWNLOAD_ASSETS_NO_INDEX"));
        }
        File assetsIndexFile = new File(indexesDir, assetsIndex + ".json");
        JSONObject assetIndexObject = headVersionFile.optJSONObject("assetIndex");
        String string = assetIndexUrl = assetIndexObject != null ? assetIndexObject.optString("url").replace("https://launchermeta.mojang.com/", DownloadSource.getProvider().versionAssetsIndex()).replace("https://piston-meta.mojang.com/", DownloadSource.getProvider().versionAssetsIndex()) : null;
        if (CMCL.isEmpty(assetIndexUrl)) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_INSTALL_FAILED_TO_DOWNLOAD_ASSETS", CMCL.getString("MESSAGE_EXCEPTION_DETAIL_NOT_FOUND_URL")));
        }
        try {
            DownloadUtils.downloadFile(assetIndexUrl, assetsIndexFile);
            JSONObject assetsJo = new JSONObject(FileUtils.readFileContent(assetsIndexFile));
            JSONObject objectsJo = assetsJo.optJSONObject("objects");
            Map<String, Object> map = objectsJo.toMap();
            ArrayList<String> nameList = new ArrayList<String>(map.keySet());
            JSONArray names = new JSONArray((Collection<?>)nameList);
            JSONArray objectsJa = objectsJo.toJSONArray(names);
            LinkedList<Pair<String, File>> list = new LinkedList<Pair<String, File>>();
            for (int i = 0; i < objectsJa.length(); ++i) {
                JSONObject object = objectsJa.optJSONObject(i);
                if (object == null) continue;
                String hash = object.optString("hash");
                try {
                    File file;
                    if (CMCL.isEmpty(hash)) continue;
                    if (!assetsIndex.equals("legacy")) {
                        File dir = new File(objectsDir, hash.substring(0, 2));
                        dir.mkdirs();
                        file = new File(dir, hash);
                    } else {
                        file = new File(assetsDir, "virtual/legacy/" + (String)nameList.get(i));
                        file.getParentFile().mkdirs();
                    }
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    if (file.length() != 0L) continue;
                    list.add(new Pair<String, File>(DownloadSource.getProvider().assets() + hash.substring(0, 2) + "/" + hash, file));
                    continue;
                }
                catch (Exception e1) {
                    throw new ExceptionWithDescription(CMCL.getString("MESSAGE_FAILED_DOWNLOAD_FILE", hash));
                }
            }
            if (Constants.isDebug()) {
                System.out.println("threadCount: " + threadCount);
            }
            ThreadsDownloader threadsDownloader = new ThreadsDownloader(list, onDownloaded, threadCount > 0 ? threadCount : 64, false);
            threadsDownloader.start();
        }
        catch (Exception e1) {
            throw new ExceptionWithDescription(CMCL.getString("MESSAGE_INSTALL_FAILED_TO_DOWNLOAD_ASSETS", e1));
        }
    }
}

