/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.version.downloaders;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.bean.Library;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.modules.MinecraftLauncher;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionLibraryUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class LibrariesDownloader {
    public static void downloadLibraries(List<Library> list) {
        try {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADING_LIBRARIES"));
            if (list != null && list.size() > 0) {
                for (Library library : list) {
                    JSONObject jsonObject = library.libraryJSONObject;
                    LibrariesDownloader.downloadSingleLibrary(jsonObject);
                }
                System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADED_LIBRARIES"));
            } else {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_LIBRARIES_LIST_EMPTY"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(CMCL.getString("MESSAGE_INSTALL_FAILED_TO_DOWNLOAD_LIBRARIES", ex));
        }
    }

    public static void downloadSingleLibrary(JSONObject library) {
        if (library == null) {
            return;
        }
        boolean meet = true;
        JSONArray rules = library.optJSONArray("rules");
        if (rules != null) {
            meet = MinecraftLauncher.isMeetConditions(rules, Collections.emptyMap());
        }
        if (!meet) {
            return;
        }
        Pair<String, String> pair = VersionLibraryUtils.getLibraryDownloadURLAndStoragePath(library);
        if (pair == null || CMCL.isEmpty(pair.getKey())) {
            System.out.println(CMCL.getString("MESSAGE_NOT_FOUND_LIBRARY_DOWNLOAD_URL", library.optString("name")));
            return;
        }
        String pairValue = pair.getValue();
        File file = new File(CMCL.librariesDir, pairValue);
        try {
            FileUtils.createFile(file, false);
            if (file.length() == 0L) {
                System.out.print(CMCL.getString("MESSAGE_DOWNLOADING_FILE", pairValue.substring(pairValue.lastIndexOf("/") + 1)));
                DownloadUtils.downloadFile(pair.getKey(), file, new PercentageTextProgress());
            }
        }
        catch (Exception e) {
            Utils.downloadFileFailed(pair.getKey(), file, e);
        }
    }
}

