/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.modules.version.downloaders;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.modules.MinecraftLauncher;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.cmcl.version.VersionUtils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import com.mrshiehx.cmcl.utils.system.OperatingSystem;
import com.mrshiehx.cmcl.utils.system.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class NativesDownloader {
    public static void download(File versionDir, List<JSONObject> librariesJa) {
        File tempNatives = new File(CMCL.getCMCLWorkingDirectory(), "temp_natives");
        tempNatives.mkdirs();
        try {
            if (librariesJa != null) {
                ArrayList<String> nativesNames = new ArrayList<String>();
                for (JSONObject jsonObject : librariesJa) {
                    JSONObject nativesNamesJO;
                    JSONObject classifiersJo;
                    boolean meet = true;
                    JSONArray rules = jsonObject.optJSONArray("rules");
                    if (rules != null) {
                        meet = MinecraftLauncher.isMeetConditions(rules, Collections.emptyMap());
                    }
                    JSONObject downloadsJo1 = jsonObject.optJSONObject("downloads");
                    if (!meet || downloadsJo1 == null || (classifiersJo = downloadsJo1.optJSONObject("classifiers")) == null || (nativesNamesJO = jsonObject.optJSONObject("natives")) == null) continue;
                    JSONObject nativesJo = classifiersJo.optJSONObject(nativesNamesJO.optString(OperatingSystem.CURRENT_OS.getCheckedName()).replace("${arch}", SystemUtils.getArchInt()));
                    NativesDownloader.downloadSingleNative(tempNatives, nativesJo, nativesNames);
                }
            } else {
                System.out.println(CMCL.getString("MESSAGE_INSTALL_LIBRARIES_LIST_EMPTY"));
                return;
            }
            System.out.println(CMCL.getString("MESSAGE_INSTALL_DOWNLOADED_LIBRARIES"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.out.println(CMCL.getString("MESSAGE_INSTALL_FAILED_TO_DOWNLOAD_LIBRARIES", e1));
        }
        File nativesDir = new File(versionDir, VersionUtils.getNativesDirName());
        NativesDownloader.unzip(tempNatives, nativesDir);
    }

    public static void unzip(File tempNatives, File nativesDir) {
        File[] natives = tempNatives.listFiles((dir, name1) -> name1.endsWith(".jar"));
        if (natives == null || natives.length == 0) {
            System.out.println(CMCL.getString("MESSAGE_INSTALL_NATIVES_EMPTY_JAR"));
            return;
        }
        System.out.println(CMCL.getString("MESSAGE_INSTALL_DECOMPRESSING_NATIVE_LIBRARIES"));
        nativesDir.mkdirs();
        for (File file : natives) {
            try {
                System.out.print(CMCL.getString("MESSAGE_UNZIPPING_FILE", file.getName()));
                FileUtils.unZip(file, nativesDir, new PercentageTextProgress(), string -> {
                    String s = Utils.getExtension(string);
                    return CMCL.isEmpty(s) || !CMCL.isEmpty(s) && !s.equals("sha1") && !s.equals("git");
                });
            }
            catch (Exception e1) {
                e1.printStackTrace();
                System.out.println(CMCL.getString("MESSAGE_FAILED_TO_DECOMPRESS_FILE", file.getAbsolutePath(), e1));
            }
        }
        System.out.println(CMCL.getString("MESSAGE_INSTALL_DECOMPRESSED_NATIVE_LIBRARIES"));
        FileUtils.deleteDirectory(tempNatives);
    }

    public static void downloadSingleNative(File tempNatives, JSONObject nativesJo, List<String> nativesNames) {
        String url1;
        String name12;
        if (nativesJo != null && !nativesNames.contains(name12 = VersionUtils.getNativeLibraryName(nativesJo.optString("path"))) && !CMCL.isEmpty(url1 = nativesJo.optString("url"))) {
            url1 = url1.replace("https://libraries.minecraft.net/", DownloadSource.getProvider().libraries());
            File nativeFile = new File(tempNatives, url1.substring(url1.lastIndexOf("/") + 1));
            try {
                System.out.print(CMCL.getString("MESSAGE_DOWNLOADING_FILE", url1.substring(url1.lastIndexOf("/") + 1)));
                DownloadUtils.downloadFile(url1, nativeFile, new PercentageTextProgress());
                nativesNames.add(name12);
            }
            catch (Exception e1) {
                System.out.println(CMCL.getString("MESSAGE_FAILED_DOWNLOAD_FILE_WITH_REASON", url1, e1));
            }
        }
    }
}

