/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.server;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.exceptions.AuthenticationException;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import fi.iki.elonen.NanoHTTPD;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class MicrosoftAuthenticationServer
extends NanoHTTPD {
    private final int port;
    private final CompletableFuture<String> future = new CompletableFuture();

    public MicrosoftAuthenticationServer(int port) {
        super(port);
        this.port = port;
    }

    public String getRedirectURI() {
        return "http%3A%2F%2Flocalhost%3A" + this.port + "%2Fauthentication-response";
    }

    public String getCode() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        if (session.getMethod() != NanoHTTPD.Method.GET || !"/authentication-response".equals(session.getUri())) {
            return MicrosoftAuthenticationServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/html", "");
        }
        String s = session.getQueryParameterString();
        if (CMCL.isEmpty(s)) {
            return MicrosoftAuthenticationServer.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/html", "");
        }
        Map query = Utils.mapOf(NetworkUtils.parseQuery(s));
        if (query.containsKey("code")) {
            String c = (String)query.get("code");
            this.future.complete(c);
        } else {
            this.future.completeExceptionally(new AuthenticationException("failed to authenticate"));
        }
        String html = "<!DOCTYPE html>\n<html lang=\"en-US\">\n<head>\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n    <title>" + CMCL.getString("WEB_TITLE_LOGIN_MICROSOFT_ACCOUNT_RESPONSE") + "</title>\n</head>\n\n<body>\n    <div>" + CMCL.getString("ON_AUTHENTICATED_PAGE_TEXT") + "</div>\n\n    <script>\n        setTimeout(function() {open(\"about:blank\",\"_self\").close();}, 10000);\n    </script>\n</body>\n\n</html>";
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.stop();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
        return MicrosoftAuthenticationServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/html; charset=UTF-8", html);
    }
}

