/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.server;

import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.server.HttpServer;
import com.mrshiehx.cmcl.server.ServerUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import com.mrshiehx.cmcl.utils.json.JSONUtils;
import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class OfflineSkinServer
extends HttpServer {
    public static final KeyPair keyPair;
    public final String uuid;
    public final String playerName;
    public final byte[] skin;
    public final String skinHash;
    public final byte[] cape;
    public final String capeHash;
    public final boolean isSlim;
    public final int skinLength;
    public final int capeLength;

    public OfflineSkinServer(int port, String uuid, String playerName, byte[] skin, int skinLength, String skinHash, byte[] cape, int capeLength, String capeHash, boolean isSlim) {
        super(port);
        this.uuid = uuid;
        this.playerName = playerName;
        this.skin = skin;
        this.skinHash = skinHash;
        this.cape = cape;
        this.capeHash = capeHash;
        this.isSlim = isSlim;
        this.skinLength = skinLength;
        this.capeLength = capeLength;
        if (Utils.isEmpty(uuid)) {
            throw new RuntimeException(Utils.getString("EMPTY_UUID"));
        }
        if (Utils.isEmpty(playerName)) {
            throw new RuntimeException(Utils.getString("EMPTY_PLAYERNAME"));
        }
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Method method = session.getMethod();
        String uri = session.getUri();
        if (method.equals((Object)NanoHTTPD.Method.GET)) {
            Matcher matcherForProfile = Pattern.compile("/sessionserver/session/minecraft/profile/(?<uuid>[a-f0-9]{32})").matcher(uri);
            Matcher matcherForTextures = Pattern.compile("/textures/(?<hash>[a-f0-9]{64})").matcher(uri);
            if (Pattern.compile("^/$").matcher(uri).find()) {
                return this.root(session);
            }
            if (Pattern.compile("/status").matcher(uri).find()) {
                return this.status(session);
            }
            if (Pattern.compile("/sessionserver/session/minecraft/hasJoined").matcher(uri).find()) {
                Map<String, String> query = Utils.mapOf(NetworkUtils.parseQuery(session.getQueryParameterString()));
                return this.hasJoined(session, query);
            }
            if (matcherForProfile.find()) {
                return this.profile(session, matcherForProfile);
            }
            if (matcherForTextures.find()) {
                return this.textures(session, matcherForTextures);
            }
            if (Pattern.compile("/sessionserver/session/minecraft/join").matcher(uri).find()) {
                return ServerUtils.badRequest();
            }
            if (Pattern.compile("/api/profiles/minecraft").matcher(uri).find()) {
                return ServerUtils.badRequest();
            }
        }
        if (method.equals((Object)NanoHTTPD.Method.POST)) {
            if (Pattern.compile("/sessionserver/session/minecraft/join").matcher(uri).find()) {
                return ServerUtils.noContent();
            }
            if (Pattern.compile("/api/profiles/minecraft").matcher(uri).find()) {
                try {
                    return this.profiles(session);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ServerUtils.notFound();
    }

    private NanoHTTPD.Response profiles(NanoHTTPD.IHTTPSession session) throws IOException {
        InputStream i = session.getInputStream();
        String s = Utils.inputStream2String(i, i.available());
        JSONArray jsonArray = JSONUtils.parseJSONArray(s);
        if (jsonArray == null) {
            return ServerUtils.badRequest();
        }
        boolean contains = false;
        for (Object obj : jsonArray) {
            if (!Objects.equals(obj, this.playerName)) continue;
            contains = true;
            break;
        }
        JSONArray result = new JSONArray();
        if (contains) {
            result.put(new JSONObject().put("id", this.uuid).put("name", this.playerName));
        }
        return ServerUtils.ok(result);
    }

    private NanoHTTPD.Response textures(NanoHTTPD.IHTTPSession session, Matcher matcher) {
        String hash = matcher.group("hash");
        ByteArrayInputStream inputStream = null;
        int inputStreamLength = 0;
        if (Objects.equals(hash, this.skinHash) && this.skin != null) {
            inputStream = new ByteArrayInputStream(this.skin);
            inputStreamLength = this.skinLength;
        } else if (Objects.equals(hash, this.capeHash) && this.cape != null) {
            inputStream = new ByteArrayInputStream(this.cape);
            inputStreamLength = this.capeLength;
        }
        if (inputStream != null && inputStreamLength > 0) {
            NanoHTTPD.Response response = OfflineSkinServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "image/png", inputStream, inputStreamLength);
            response.addHeader("Etag", String.format("\"%s\"", hash));
            response.addHeader("Cache-Control", "max-age=2592000, public");
            return response;
        }
        return ServerUtils.notFound();
    }

    private NanoHTTPD.Response profile(NanoHTTPD.IHTTPSession session, Matcher matcher) {
        String uuid = matcher.group("uuid");
        if (Objects.equals(this.uuid, uuid)) {
            return this.getProfile();
        }
        return ServerUtils.noContent();
    }

    private NanoHTTPD.Response getProfile() {
        JSONObject textures = new JSONObject();
        if (this.skin != null && !Utils.isEmpty(this.skinHash)) {
            JSONObject skinJSONObject = new JSONObject().put("url", this.getRootUrl() + "textures/" + this.skinHash);
            if (this.isSlim) {
                skinJSONObject.put("metadata", new JSONObject().put("model", "slim"));
            }
            textures.put("SKIN", skinJSONObject);
        }
        if (this.cape != null && !Utils.isEmpty(this.capeHash)) {
            textures.put("CAPE", new JSONObject().put("url", this.getRootUrl() + "textures/" + this.capeHash));
        }
        JSONObject texturesBase64 = new JSONObject();
        texturesBase64.put("timestamp", System.currentTimeMillis());
        texturesBase64.put("profileId", this.uuid);
        texturesBase64.put("profileName", this.playerName);
        texturesBase64.put("textures", textures);
        String value = Base64.getEncoder().encodeToString(texturesBase64.toString(2).getBytes(StandardCharsets.UTF_8));
        JSONArray properties = new JSONArray();
        JSONObject texturesProperty = new JSONObject();
        texturesProperty.put("name", "textures");
        texturesProperty.put("value", value);
        texturesProperty.put("signature", OfflineSkinServer.sign(value));
        properties.put(texturesProperty);
        JSONObject main = new JSONObject();
        main.put("id", this.uuid);
        main.put("name", this.playerName);
        main.put("properties", properties);
        return ServerUtils.ok(main);
    }

    private static String sign(String data) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(keyPair.getPrivate(), new SecureRandom());
            signature.update(data.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private NanoHTTPD.Response hasJoined(NanoHTTPD.IHTTPSession session, Map<String, String> query) {
        String username = query.get("username");
        if (Utils.isEmpty(username)) {
            return ServerUtils.badRequest();
        }
        if (Objects.equals(this.playerName, username)) {
            return this.getProfile();
        }
        return ServerUtils.noContent();
    }

    private NanoHTTPD.Response status(NanoHTTPD.IHTTPSession session) {
        JSONObject main = new JSONObject();
        main.put("user.count", 1);
        main.put("token.count", 0);
        main.put("pendingAuthentication.count", 0);
        return ServerUtils.ok(main);
    }

    private NanoHTTPD.Response root(NanoHTTPD.IHTTPSession session) {
        if (keyPair == null) {
            return ServerUtils.internalError();
        }
        byte[] encoded = keyPair.getPublic().getEncoded();
        String key = "-----BEGIN PUBLIC KEY-----\n" + Base64.getMimeEncoder(76, new byte[]{10}).encodeToString(encoded) + "\n-----END PUBLIC KEY-----\n";
        JSONObject main = new JSONObject();
        main.put("signaturePublickey", key);
        JSONObject meta = new JSONObject();
        meta.put("serverName", "CMCL");
        meta.put("implementationName", "CMCL");
        meta.put("implementationVersion", "1.0");
        meta.put("feature.non_email_login", true);
        main.put("meta", meta);
        JSONArray skinDomains = new JSONArray();
        skinDomains.put("127.0.0.1");
        skinDomains.put("localhost");
        main.put("skinDomains", skinDomains);
        return ServerUtils.ok(main);
    }

    static {
        KeyPair keyPair1;
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            gen.initialize(4096, new SecureRandom());
            keyPair1 = gen.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            if (Constants.isDebug()) {
                e.printStackTrace();
            }
            keyPair1 = null;
        }
        keyPair = keyPair1;
    }
}

