/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.bean.SplitLibraryName;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.internet.DownloadUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class Utils {
    public static String getString(String name) {
        return CMCL.getString(name);
    }

    public static String getString(String name, Object ... objects) {
        return CMCL.getString(name, objects);
    }

    public static <K, V> Map<K, V> mapOf(Iterable<Pair<K, V>> pairs) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public static boolean isEmpty(CharSequence c) {
        return c == null || c.length() == 0;
    }

    public static String valueOf(Object value) {
        return value == null ? "" : value.toString();
    }

    public static void saveConfig(JSONObject config) {
        CMCL.saveConfig(config);
    }

    public static JSONObject getConfig() {
        return CMCL.getConfig();
    }

    public static <X> List<X> removeDuplicate(List<X> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = list.size() - 1; j > i; --j) {
                if (!Objects.equals(list.get(j), list.get(i))) continue;
                list.remove(j);
            }
        }
        return list;
    }

    public static void printfln(String str, Object ... object) {
        System.out.printf(str, object);
        System.out.println();
    }

    public static void printflnErr(String str, Object ... object) {
        System.out.printf(str, object);
        System.out.println();
    }

    public static String inputStream2String(InputStream stream) throws IOException {
        try (InputStream is = stream;){
            int len;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((len = is.read(buf)) != -1) {
                result.write(buf, 0, len);
            }
            String string = result.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    public static String inputStream2String(InputStream stream, int length) throws IOException {
        try (InputStream is = stream;){
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[length];
            int len = is.read(buf, 0, length);
            result.write(buf, 0, len);
            String string = result.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    public static File downloadVersionsFile() throws IOException {
        File cmcl = CMCL.getCMCLWorkingDirectory();
        cmcl.mkdirs();
        File versionsFile = new File(cmcl, "versions.json");
        FileUtils.createFile(versionsFile, true);
        DownloadUtils.downloadFile(DownloadSource.getProvider().versionManifest(), versionsFile);
        return versionsFile;
    }

    public static String getTypeText(String simpleName) {
        if ("String".equals(simpleName)) {
            return Utils.getString("DATATYPE_STRING");
        }
        if ("Boolean".equals(simpleName)) {
            return Utils.getString("DATATYPE_BOOLEAN");
        }
        if ("Integer".equals(simpleName)) {
            return Utils.getString("DATATYPE_INTEGER");
        }
        if ("Double".equals(simpleName) || "Float".equals(simpleName) || "BigDecimal".equals(simpleName)) {
            return Utils.getString("DATATYPE_FRACTION");
        }
        if ("ArrayList".equals(simpleName)) {
            return Utils.getString("DATATYPE_JSON_ARRAY");
        }
        if ("HashMap".equals(simpleName)) {
            return Utils.getString("DATATYPE_JSON_OBJECT");
        }
        return simpleName;
    }

    public static int parseWithPrompting(String value) throws Exception {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            System.out.println(Utils.getString("CONSOLE_UNSUPPORTED_VALUE", value));
            throw new Exception();
        }
    }

    public static String randomUUIDNoSymbol() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getPathFromLibraryName(SplitLibraryName nameSplit) {
        return nameSplit.first.replace(".", "/") + "/" + nameSplit.second + "/" + nameSplit.version;
    }

    public static String getExtension(String string) {
        if (Utils.isEmpty(string)) {
            return null;
        }
        int indexOf = string.lastIndexOf(46);
        if (indexOf < 0 || indexOf == string.length() - 1) {
            return null;
        }
        return string.substring(indexOf + 1);
    }

    public static void close(Closeable t) {
        try {
            t.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String downloadFileFailedText(String url, File file, Exception e) {
        return url.endsWith("/" + file.getName()) ? Utils.getString("MESSAGE_FAILED_DOWNLOAD_FILE_WITH_REASON_WITH_URL", e, url, file.getParentFile().getAbsolutePath()) : Utils.getString("MESSAGE_FAILED_DOWNLOAD_FILE_WITH_REASON_WITH_URL_WITH_NAME", e, url, file.getParentFile().getAbsolutePath(), file.getName());
    }

    public static void downloadFileFailed(String url, File file, Exception e) {
        System.out.println(Utils.downloadFileFailedText(url, file, e));
    }

    public static String[] xsplit(String s, String regex) {
        String[] ss = s.split(regex);
        if (ss[0].equals(s)) {
            return new String[0];
        }
        return ss;
    }

    public static <T> Stream<T> iteratorToStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static String getExecutableFilePath() {
        try {
            return URLDecoder.decode(Utils.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int stringOccupiedSpacesLength(@NotNull String str) {
        if (str == null) {
            Utils.$$$reportNull$$$0(0);
        }
        char[] chars = str.toCharArray();
        int length = 0;
        for (char aChar : chars) {
            if (Utils.isFullWidth(aChar)) {
                ++length;
            }
            ++length;
        }
        return length;
    }

    public static boolean isFullWidth(char aChar) {
        return String.valueOf(aChar).matches("[^\\x00-\\xff]");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/mrshiehx/cmcl/utils/Utils", "stringOccupiedSpacesLength"));
    }
}

