/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.cmcl;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.exceptions.NotSelectedException;
import com.mrshiehx.cmcl.functions.AccountFunction;
import com.mrshiehx.cmcl.modules.account.authentication.microsoft.MicrosoftAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.authlib.AuthlibInjectorAuthentication;
import com.mrshiehx.cmcl.modules.account.authentication.yggdrasil.nide8auth.Nide8AuthAuthentication;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.InteractionUtils;
import com.mrshiehx.cmcl.utils.console.PrintingUtils;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class AccountUtils {
    public static JSONObject getSelectedAccount(JSONObject config, boolean prompt) throws NotSelectedException {
        JSONArray accounts = config.optJSONArray("accounts");
        if (accounts == null || accounts.length() == 0) {
            if (prompt) {
                System.out.println(Utils.getString("NOT_SELECTED_AN_ACCOUNT"));
            }
            throw new NotSelectedException();
        }
        for (Object o : accounts) {
            JSONObject jsonObject;
            if (!AccountUtils.isValidAccount(o) || !(jsonObject = (JSONObject)o).optBoolean("selected")) continue;
            return jsonObject;
        }
        if (prompt) {
            System.out.println(Utils.getString("NOT_SELECTED_AN_ACCOUNT"));
        }
        throw new NotSelectedException();
    }

    public static JSONObject getSelectedAccountIfNotLoginNow(JSONObject config) {
        JSONArray accounts = config.optJSONArray("accounts");
        int valid = 0;
        if (accounts != null) {
            for (Object o : accounts) {
                if (!AccountUtils.isValidAccount(o)) continue;
                ++valid;
                if (!((JSONObject)o).optBoolean("selected")) continue;
                return (JSONObject)o;
            }
        }
        if (accounts != null && valid > 0) {
            AtomicInteger i1 = new AtomicInteger();
            PrintingUtils.printTable(new String[]{CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_ORDER"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_NAME"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_TYPE"), CMCL.getString("TABLE_ACCOUNTS_LIST_HEADER_OTHER_INFORMATION")}, new int[]{6, 20, 24, 50}, false, (String[][])AccountFunction.getAllAccounts(accounts).stream().map(account -> AccountFunction.accountInfoToTableItem(account, i1.getAndIncrement(), false)).collect(Collectors.toList()).toArray((T[])new String[0][0]));
            int order = InteractionUtils.inputInt(Utils.getString("MESSAGE_SELECT_ACCOUNT", 0, valid - 1), 0, valid - 1);
            if (order == Integer.MAX_VALUE) {
                return null;
            }
            JSONObject account2 = accounts.optJSONObject(order);
            if (!AccountUtils.isValidAccount(account2)) {
                Utils.printfln(Utils.getString("ACCOUNT_INVALID"), order);
                return null;
            }
            account2.put("selected", true);
            for (int i = 0; i < accounts.length(); ++i) {
                JSONObject accountInFor;
                if (i == order || (accountInFor = accounts.optJSONObject(i)) == null) continue;
                accountInFor.put("selected", false);
            }
            Utils.saveConfig(config);
            return account2;
        }
        System.out.println("[0]" + Utils.getString("ACCOUNT_TYPE_OFFLINE"));
        System.out.println("[1]" + Utils.getString("ACCOUNT_TYPE_MICROSOFT"));
        System.out.println("[2]" + Utils.getString("ACCOUNT_TYPE_OAS"));
        System.out.println("[3]" + Utils.getString("ACCOUNT_TYPE_NIDE8AUTH"));
        int sel = InteractionUtils.inputInt(Utils.getString("MESSAGE_SELECT_ACCOUNT_TYPE", 0, 3), 0, 3);
        if (accounts == null) {
            accounts = new JSONArray();
            config.put("accounts", accounts);
        }
        switch (sel) {
            case 0: {
                JSONObject account3 = new JSONObject().put("playerName", InteractionUtils.inputString(Utils.getString("ACCOUNT_TIP_LOGIN_OFFLINE_PLAYERNAME"))).put("selected", true).put("loginMethod", 0);
                accounts.put(account3);
                Utils.saveConfig(config);
                return account3;
            }
            case 1: {
                JSONObject account3;
                try {
                    account3 = MicrosoftAuthentication.loginMicrosoftAccount();
                    if (account3 == null) {
                        return null;
                    }
                    accounts.put(account3.put("selected", true));
                    Utils.saveConfig(config);
                    return account3;
                }
                catch (Exception e) {
                    if (Constants.isDebug()) {
                        e.printStackTrace();
                    }
                    System.out.println(e.getMessage());
                    return null;
                }
            }
            case 2: {
                JSONObject account3;
                try {
                    account3 = AuthlibInjectorAuthentication.authlibInjectorLogin(InteractionUtils.inputString(Utils.getString("ACCOUNT_TIP_LOGIN_OAS_ADDRESS")), null, true);
                    if (account3 == null) {
                        return null;
                    }
                    accounts.put(account3);
                    Utils.saveConfig(config);
                    return account3;
                }
                catch (Exception e) {
                    if (Constants.isDebug()) {
                        e.printStackTrace();
                    }
                    System.out.println(e.getMessage());
                    return null;
                }
            }
            case 3: {
                JSONObject account3;
                try {
                    account3 = Nide8AuthAuthentication.nide8authLogin(InteractionUtils.inputString(Utils.getString("ACCOUNT_TIP_LOGIN_NIDE8AUTH_SERVER_ID")), null, true);
                    if (account3 == null) {
                        return null;
                    }
                    accounts.put(account3);
                    Utils.saveConfig(config);
                    return account3;
                }
                catch (Exception e) {
                    if (Constants.isDebug()) {
                        e.printStackTrace();
                    }
                    System.out.println(e.getMessage());
                    return null;
                }
            }
        }
        return null;
    }

    public static String getUUIDByName(String playerName) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + playerName).getBytes(StandardCharsets.UTF_8)).toString().replace("-", "");
    }

    public static boolean isValidAccount(Object object) {
        return object instanceof JSONObject && AccountUtils.isValidAccount((JSONObject)object);
    }

    public static boolean isValidAccount(JSONObject account) {
        return account != null && !Utils.isEmpty(account.optString("playerName")) && account.has("loginMethod");
    }
}

