/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.cmcl;

import com.mrshiehx.cmcl.utils.Utils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArgumentsUtils {
    public static List<String> parseJVMArgs(JSONArray jvmArgs) {
        LinkedList<String> result = new LinkedList<String>();
        if (jvmArgs == null) {
            return result;
        }
        List<Object> objs = jvmArgs.toList();
        for (Object obj : objs) {
            String v = Utils.valueOf(obj);
            if (Utils.isEmpty(v) || v.contains("-Dminecraft.launcher.brand") || v.contains("-Dminecraft.launcher.version") || result.contains(v)) continue;
            result.add(v);
        }
        return result;
    }

    public static List<String> parseJVMArgs(String[] jvmArgs) {
        LinkedList<String> result = new LinkedList<String>();
        if (jvmArgs == null || jvmArgs.length == 0) {
            return result;
        }
        for (String v : jvmArgs) {
            if (Utils.isEmpty(v) || v.contains("-Dminecraft.launcher.brand") || v.contains("-Dminecraft.launcher.version") || result.contains(v)) continue;
            result.add(v);
        }
        return result;
    }

    public static Map<String, String> parseGameArgs(JSONObject gameArgs) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (gameArgs == null) {
            return result;
        }
        Map<String, Object> map = gameArgs.toMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String va = Utils.valueOf(entry.getValue());
            String key = entry.getKey();
            if (Utils.isEmpty(key) || entry.getKey().equals("version") || entry.getKey().equals("versionType") || result.containsKey(key)) continue;
            result.put(key, va);
        }
        return result;
    }
}

