/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.cmcl.version;

import com.mrshiehx.cmcl.api.download.DefaultApiProvider;
import com.mrshiehx.cmcl.api.download.DownloadSource;
import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.bean.SplitLibraryName;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionLibraryUtils {
    public static SplitLibraryName splitLibraryName(String name) {
        return SplitLibraryName.valueOf(name);
    }

    public static Pair<String, String> getLibraryDownloadURLAndStoragePath(JSONObject library) {
        JSONObject downloads = library.optJSONObject("downloads");
        if (downloads != null) {
            JSONObject artifactJo = downloads.optJSONObject("artifact");
            if (artifactJo != null) {
                String name;
                SplitLibraryName nameSplit;
                String path = artifactJo.optString("path");
                String url = artifactJo.optString("url");
                if (Utils.isEmpty(path) && !Utils.isEmpty(library.optString("name")) && (nameSplit = VersionLibraryUtils.splitLibraryName(name = library.optString("name"))) != null) {
                    String fileName = nameSplit.getFileName();
                    path = Utils.getPathFromLibraryName(nameSplit) + "/" + fileName;
                }
                if (!Utils.isEmpty(path) || !Utils.isEmpty(url)) {
                    String url2 = null;
                    if (!Utils.isEmpty(url)) {
                        url2 = VersionLibraryUtils.replaceUrl(url);
                    }
                    return new Pair<String, String>(url2, path);
                }
                return null;
            }
            return null;
        }
        String name = library.optString("name");
        String url = library.optString("url", DownloadSource.getProvider().libraries());
        url = VersionLibraryUtils.replaceUrl(url);
        if (Utils.isEmpty(name)) {
            return null;
        }
        SplitLibraryName nameSplit = VersionLibraryUtils.splitLibraryName(name);
        if (nameSplit == null) {
            return null;
        }
        String fileName = nameSplit.getFileName();
        String path = Utils.getPathFromLibraryName(nameSplit) + "/" + fileName;
        return new Pair<String, String>(NetworkUtils.addSlashIfMissing(url) + (name.startsWith("net.minecraftforge:forge:") ? path.substring(0, path.length() - 4) + "-universal.jar" : path), path);
    }

    public static JSONArray mergeLibraries(List<JSONObject> source, List<JSONObject> target) {
        JSONArray jsonArray = new JSONArray();
        source = source != null ? source : Collections.emptyList();
        target = target != null ? target : Collections.emptyList();
        jsonArray.putAll((Collection<?>)source);
        for (JSONObject jsonObject : target) {
            String targetName = jsonObject.optString("name");
            int indexOf = -1;
            for (int j = 0; j < source.size(); ++j) {
                String[] sourceNameSplit;
                JSONObject jsonObject1 = source.get(j);
                String sourceName = jsonObject1.optString("name");
                if (sourceName.equals(targetName)) {
                    indexOf = j;
                    break;
                }
                String[] targetNameSplit = targetName.split(":");
                if (targetNameSplit.length != (sourceNameSplit = sourceName.split(":")).length || sourceNameSplit.length < 3 || !Objects.equals(targetNameSplit[0], sourceNameSplit[0]) || !Objects.equals(targetNameSplit[1], sourceNameSplit[1])) continue;
                indexOf = j;
                break;
            }
            jsonObject.remove("clientreq");
            jsonObject.remove("serverreq");
            if (indexOf < 0) {
                jsonArray.put(jsonObject);
                continue;
            }
            jsonArray.put(indexOf, jsonObject);
        }
        return jsonArray;
    }

    public static String replaceUrl(String url) {
        if (Utils.isEmpty(url)) {
            return url;
        }
        String a = "https://libraries.minecraft.net/";
        if (url.contains("https://libraries.minecraft.net/")) {
            url = url.replace(a, DownloadSource.getProvider().libraries());
        }
        a = "https://maven.fabricmc.net/";
        if (url.contains("https://maven.fabricmc.net/")) {
            url = url.replace(a, DownloadSource.getProvider().fabricMaven());
        }
        a = "http://repo.maven.apache.org/maven2/";
        if (url.contains("http://repo.maven.apache.org/maven2/")) {
            url = url.replace(a, "https://repo.maven.apache.org/maven2/");
        }
        a = "https://maven.minecraftforge.net/";
        if (url.contains("https://maven.minecraftforge.net/") && !(DownloadSource.getProvider() instanceof DefaultApiProvider)) {
            url = url.replace(a, DownloadSource.getProvider().forgeMaven());
        }
        a = "https://files.minecraftforge.net/maven/";
        if (url.contains("https://files.minecraftforge.net/maven/") && !(DownloadSource.getProvider() instanceof DefaultApiProvider)) {
            url = url.replace(a, DownloadSource.getProvider().forgeMaven());
        }
        a = "http://repo.liteloader.com/";
        if (url.contains("http://repo.liteloader.com/")) {
            url = url.replace(a, "https://repo.liteloader.com/");
        }
        return url;
    }
}

