/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.cmcl.version;

import com.mrshiehx.cmcl.utils.Utils;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionModuleUtils {
    public static String getModuleVersion(JSONObject head, String mainClass, String libraryFirstAndSecond) {
        if (!Utils.isEmpty(mainClass) && !head.optString("mainClass").equals(mainClass)) {
            return null;
        }
        JSONArray libraries = head.optJSONArray("libraries");
        if (libraries == null || libraries.length() == 0) {
            return null;
        }
        for (Object o : libraries) {
            JSONObject library;
            String name;
            if (!(o instanceof JSONObject) || !(name = (library = (JSONObject)o).optString("name")).startsWith(libraryFirstAndSecond) || name.length() <= libraryFirstAndSecond.length()) continue;
            return name.substring(libraryFirstAndSecond.length());
        }
        return null;
    }

    public static String getModuleVersion(JSONObject head, String moduleName) {
        String version;
        JSONObject module = head.optJSONObject(moduleName);
        if (module != null && !Utils.isEmpty(version = module.optString("version"))) {
            return version;
        }
        JSONArray patches = head.optJSONArray("patches");
        if (patches != null && patches.length() > 0) {
            for (Object o : patches) {
                String version2;
                JSONObject jsonObject;
                if (!(o instanceof JSONObject) || !(jsonObject = (JSONObject)o).optString("id").equals(moduleName) || Utils.isEmpty(version2 = jsonObject.optString("version"))) continue;
                return version2;
            }
        }
        return null;
    }

    public static String getFabricVersion(JSONObject head) {
        String first = VersionModuleUtils.getModuleVersion(head, "fabric");
        if (!Utils.isEmpty(first)) {
            return first;
        }
        return VersionModuleUtils.getModuleVersion(head, "net.fabricmc.loader.impl.launch.knot.KnotClient", "net.fabricmc:fabric-loader:");
    }

    public static String getLiteloaderVersion(JSONObject head) {
        String first = VersionModuleUtils.getModuleVersion(head, "liteloader");
        if (!Utils.isEmpty(first)) {
            return first;
        }
        return VersionModuleUtils.getModuleVersion(head, null, "com.mumfrey:liteloader:");
    }

    public static String getForgeVersion(JSONObject head) {
        String[] split;
        int indexOf;
        JSONArray game;
        String first = VersionModuleUtils.getModuleVersion(head, "forge");
        if (!Utils.isEmpty(first)) {
            return first;
        }
        JSONObject arguments = head.optJSONObject("arguments");
        if (arguments != null && (game = arguments.optJSONArray("game")) != null && (indexOf = game.toList().indexOf("--fml.forgeVersion")) >= 0 && indexOf + 1 < game.length()) {
            return game.optString(indexOf + 1);
        }
        String version = null;
        String second = VersionModuleUtils.getModuleVersion(head, null, "net.minecraftforge:forge:");
        if (Utils.isEmpty(second)) {
            second = VersionModuleUtils.getModuleVersion(head, null, "net.minecraftforge:fmlloader:");
        }
        if (!Utils.isEmpty(second) && (split = second.split("-")).length >= 2) {
            version = split[1];
        }
        return version;
    }

    public static String getOptifineVersion(JSONObject head) {
        String first = VersionModuleUtils.getModuleVersion(head, "optifine");
        if (!Utils.isEmpty(first)) {
            return first;
        }
        String version = null;
        String origin = VersionModuleUtils.getModuleVersion(head, null, "optifine:OptiFine:");
        if (!Utils.isEmpty(origin)) {
            int indexOf = origin.indexOf(95);
            version = origin.substring(indexOf + 1);
        }
        return version;
    }

    public static String getQuiltVersion(JSONObject head) {
        String first = VersionModuleUtils.getModuleVersion(head, "quilt");
        if (!Utils.isEmpty(first)) {
            return first;
        }
        return VersionModuleUtils.getModuleVersion(head, "org.quiltmc.loader.impl.launch.knot.KnotClient", "org.quiltmc:quilt-loader:");
    }

    public static String getNeoForgeVersion(JSONObject head) {
        int indexOf;
        JSONArray game;
        String first = VersionModuleUtils.getModuleVersion(head, "neoforge");
        if (!Utils.isEmpty(first)) {
            return first;
        }
        JSONObject arguments = head.optJSONObject("arguments");
        if (arguments != null && (game = arguments.optJSONArray("game")) != null && (indexOf = game.toList().indexOf("--fml.neoForgeVersion")) >= 0 && indexOf + 1 < game.length()) {
            return game.optString(indexOf + 1);
        }
        return null;
    }
}

