/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.console;

import com.mrshiehx.cmcl.CMCL;
import com.mrshiehx.cmcl.interfaces.filters.StringFilter;
import com.mrshiehx.cmcl.utils.Utils;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class InteractionUtils {
    public static boolean yesOrNo(String tip) {
        String text = tip + "(Y/N) ";
        return InteractionUtils.internalYesOrNo(text);
    }

    private static boolean internalYesOrNo(String text) {
        String input;
        System.out.print(text);
        Scanner scanner = new Scanner(System.in);
        try {
            input = scanner.nextLine();
        }
        catch (NoSuchElementException ignore) {
            return false;
        }
        if (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes")) {
            return true;
        }
        if (input.equalsIgnoreCase("n") || input.equalsIgnoreCase("no")) {
            return false;
        }
        return InteractionUtils.internalYesOrNo(text);
    }

    public static int inputInt(String tip, int smallest, int biggest) {
        return InteractionUtils.inputInt(tip, smallest, biggest, false, 0);
    }

    public static int inputInt(String tip, int smallest, int biggest, boolean exitWithSpecialValue, int specialValue) {
        return InteractionUtils.internalInputInt(tip, "", smallest, biggest, exitWithSpecialValue, specialValue);
    }

    private static int internalInputInt(String origin, String text, int smallest, int biggest, boolean exitWithSpecialValue, int specialValue) {
        int value;
        String input;
        System.out.print(text + origin);
        Scanner scanner = new Scanner(System.in);
        try {
            input = scanner.nextLine();
        }
        catch (NoSuchElementException ignore) {
            return Integer.MAX_VALUE;
        }
        try {
            value = Integer.parseInt(input);
        }
        catch (Exception e) {
            return InteractionUtils.internalInputInt(origin, Utils.getString("CONSOLE_INPUT_INT_WRONG"), smallest, biggest, exitWithSpecialValue, specialValue);
        }
        if (exitWithSpecialValue && value == specialValue) {
            return specialValue;
        }
        if (value < smallest || value > biggest) {
            return InteractionUtils.internalInputInt(origin, Utils.getString("CONSOLE_INPUT_INT_WRONG"), smallest, biggest, exitWithSpecialValue, specialValue);
        }
        return value;
    }

    public static String inputStringInFilter(String tip, String wrongTip, StringFilter filter) {
        return InteractionUtils.internalInputStringInFilter(tip, tip, wrongTip, filter);
    }

    private static String internalInputStringInFilter(String text, String origin, String wrongTip, StringFilter filter) {
        String input;
        System.out.print(text);
        Scanner scanner = new Scanner(System.in);
        try {
            input = scanner.nextLine();
        }
        catch (NoSuchElementException ignore) {
            return null;
        }
        if (filter.accept(input)) {
            return input;
        }
        if (CMCL.isEmpty(input)) {
            return InteractionUtils.internalInputStringInFilter(text, origin, wrongTip, filter);
        }
        return InteractionUtils.internalInputStringInFilter(String.format(wrongTip, input) + origin, origin, wrongTip, filter);
    }

    public static String inputString(String tip) {
        return InteractionUtils.internalInputString(tip, tip);
    }

    private static String internalInputString(String text, String origin) {
        String input;
        System.out.print(text);
        Scanner scanner = new Scanner(System.in);
        try {
            input = scanner.nextLine();
        }
        catch (NoSuchElementException ignore) {
            return null;
        }
        if (CMCL.isEmpty(input)) {
            return InteractionUtils.internalInputString(text, origin);
        }
        return input;
    }
}

