/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.console;

import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.TableUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class PrintingUtils {
    public static String oldNormalizeListItemsToText(List<String> list, boolean reverse) {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = i = reverse ? list.size() - 1 : 0;
        while (reverse ? i >= 0 : i < list.size()) {
            String item = list.get(i);
            if (item.contains(" ")) {
                item = "\"" + item + "\"";
            }
            stringBuilder.append(item);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (reverse) {
                --i;
                continue;
            }
            ++i;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String normalizeListItemsToText(List<String> items, boolean reverse, int columnsNumIfFullLineCannot, int separatingSpaceLength, boolean tryFullLine) {
        int windowWidth = 0;
        if (tryFullLine) {
            try (Terminal terminal = TerminalBuilder.terminal();){
                windowWidth = terminal.getWidth();
                if (windowWidth <= 0) {
                    tryFullLine = false;
                }
            }
            catch (IOException ignore) {
                tryFullLine = false;
            }
        }
        if (!tryFullLine) {
            return PrintingUtils.normalizeListItemsToText(items, reverse, columnsNumIfFullLineCannot, separatingSpaceLength);
        }
        int i = 1;
        String previous = null;
        String now = null;
        int max = 0;
        while (max <= windowWidth) {
            String[] split;
            previous = now;
            if ((split = (now = PrintingUtils.normalizeListItemsToText(items, reverse, i++, separatingSpaceLength)).split("\n")).length == 1) {
                return now;
            }
            max = 0;
            for (String a : split) {
                int length = Utils.stringOccupiedSpacesLength(a);
                if (length <= max) continue;
                max = length;
            }
        }
        return previous != null ? previous : PrintingUtils.normalizeListItemsToText(items, reverse, columnsNumIfFullLineCannot, separatingSpaceLength);
    }

    public static String normalizeListItemsToText(List<String> items, boolean reverse, int columnsNum, int separatingSpaceLength) {
        int[] maxLength = new int[columnsNum];
        items = items.stream().map(item -> item.contains(" ") ? "\"" + item + "\"" : item).collect(Collectors.toList());
        if (reverse) {
            Collections.reverse(items);
        }
        for (int i = 0; i < items.size(); ++i) {
            int columnIndex = i % columnsNum;
            int itemLength = Utils.stringOccupiedSpacesLength(items.get(i));
            if (maxLength[columnIndex] >= itemLength) continue;
            maxLength[columnIndex] = itemLength;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            String item2 = items.get(i);
            stringBuilder.append(item2);
            if ((i + 1) % columnsNum != 0) {
                for (int j = 0; j < maxLength[i % columnsNum] - Utils.stringOccupiedSpacesLength(item2) + separatingSpaceLength; ++j) {
                    stringBuilder.append(" ");
                }
                continue;
            }
            if (i + 1 == items.size()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static void printListItems(List<String> list, boolean reversed, int columnsNum, int separatingSpaceLength) {
        System.out.println(PrintingUtils.normalizeListItemsToText(list, reversed, columnsNum, separatingSpaceLength));
    }

    public static void printListItems(List<String> list, boolean reversed, int columnsNum, int separatingSpaceLength, boolean tryFullLine) {
        System.out.println(PrintingUtils.normalizeListItemsToText(list, reversed, columnsNum, separatingSpaceLength, tryFullLine));
    }

    public static void printTable(@Nullable String[] headers, int @NotNull [] lengthsRatio, boolean splitSymbolForItems, String[] ... items) {
        if (lengthsRatio == null) {
            PrintingUtils.$$$reportNull$$$0(0);
        }
        System.out.println(TableUtils.toTable(headers, lengthsRatio, splitSymbolForItems, items));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengthsRatio", "com/mrshiehx/cmcl/utils/console/PrintingUtils", "printTable"));
    }
}

