/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.console;

import com.mrshiehx.cmcl.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class TableUtils {
    /*
     * WARNING - void declaration
     */
    public static String toTable(@Nullable String[] headersStringArray, int @NotNull [] lengthsRatio, boolean splitSymbolForItems, String[] ... itemsStringArray) {
        void var10_24;
        if (lengthsRatio == null) {
            TableUtils.$$$reportNull$$$0(0);
        }
        int[] actualMaxLengths = new int[lengthsRatio.length];
        int windowWidth = 71;
        try {
            Terminal terminal = TerminalBuilder.terminal();
            Object object = null;
            try {
                windowWidth = terminal.getWidth();
                if (windowWidth == 0) {
                    windowWidth = 71;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (terminal != null) {
                    if (object != null) {
                        try {
                            terminal.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        terminal.close();
                    }
                }
            }
        }
        catch (IOException terminal) {
            // empty catch block
        }
        int maximumLengthsRatioSum = 0;
        for (int n : lengthsRatio) {
            maximumLengthsRatioSum += n;
        }
        int[] maxLengths = new int[lengthsRatio.length];
        for (int i3 = 0; i3 < maxLengths.length; ++i3) {
            maxLengths[i3] = Math.max((int)((float)(windowWidth - 1) * ((float)lengthsRatio[i3] / (float)maximumLengthsRatioSum)) - 3, 2);
        }
        TableString[] headers = null;
        TableString[][] items = null;
        if (headersStringArray != null) {
            void var10_20;
            headers = new TableString[headersStringArray.length];
            boolean bl = false;
            while (var10_20 < headersStringArray.length) {
                headers[var10_20] = new TableString(headersStringArray[var10_20]);
                ++var10_20;
            }
        }
        if (itemsStringArray != null) {
            void var10_22;
            items = new TableString[itemsStringArray.length][];
            boolean bl = false;
            while (var10_22 < itemsStringArray.length) {
                String[] itemStringArray = itemsStringArray[var10_22];
                if (items[var10_22] == null) {
                    items[var10_22] = new TableString[itemStringArray.length];
                }
                for (int j = 0; j < itemStringArray.length; ++j) {
                    String value = itemStringArray[j];
                    items[var10_22][j] = new TableString(value);
                }
                ++var10_22;
            }
        }
        boolean bl = false;
        while (var10_24 < lengthsRatio.length) {
            int maxLength = 0;
            if (headers != null) {
                maxLength = headers[var10_24].maxLengthForLines;
            }
            if (items != null) {
                for (TableString[] item : items) {
                    int length = item[var10_24].maxLengthForLines;
                    if (length <= maxLength) continue;
                    maxLength = length;
                }
            }
            actualMaxLengths[var10_24] = Math.min(maxLength, maxLengths[var10_24]);
            ++var10_24;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('+');
        for (int i4 = 0; i4 < lengthsRatio.length; ++i4) {
            for (int j = 0; j < actualMaxLengths[i4] + 2; ++j) {
                stringBuilder.append('-');
            }
            stringBuilder.append('+');
        }
        String split = stringBuilder.toString();
        stringBuilder.append('\n');
        if (headers != null) {
            TableUtils.printTableItem(stringBuilder, actualMaxLengths, headers);
            stringBuilder.append(split).append('\n');
        }
        if (items != null) {
            for (int i5 = 0; i5 < items.length; ++i5) {
                TableString[] item = items[i5];
                TableUtils.printTableItem(stringBuilder, actualMaxLengths, item);
                if (!splitSymbolForItems) continue;
                stringBuilder.append(split);
                if (i5 + 1 == items.length) continue;
                stringBuilder.append('\n');
            }
        }
        if (!splitSymbolForItems) {
            stringBuilder.append(split);
        }
        return stringBuilder.toString();
    }

    private static void printTableItem(StringBuilder stringBuilder, int[] actualMaxLengths, TableString[] item) {
        stringBuilder.append('|');
        TableString[] rests = new TableString[actualMaxLengths.length];
        boolean shouldPrintNext = false;
        for (int i = 0; i < actualMaxLengths.length; ++i) {
            TableChar[] tableCharsTemp2;
            int printedLength;
            int stringOccupiedSpacesLength;
            boolean multiLines;
            stringBuilder.append(' ');
            TableString value = item[i];
            boolean bl = multiLines = value.lines.size() > 1;
            if (multiLines) {
                value = new TableString(value.lines.get(0).toArray(new TableChar[0]));
            }
            if ((stringOccupiedSpacesLength = value.length) <= actualMaxLengths[i]) {
                stringBuilder.append(value);
                rests[i] = null;
                printedLength = stringOccupiedSpacesLength;
            } else if (value.tableChars[actualMaxLengths[i] - 1] instanceof TableHalfChar || value.tableChars[actualMaxLengths[i] - 1] instanceof TableFullCharRight) {
                TableChar[] tableCharsTemp = new TableChar[actualMaxLengths[i]];
                if (actualMaxLengths[i] >= 0) {
                    System.arraycopy(value.tableChars, 0, tableCharsTemp, 0, actualMaxLengths[i]);
                }
                stringBuilder.append(new TableString(tableCharsTemp));
                tableCharsTemp2 = new TableChar[value.length - actualMaxLengths[i]];
                if (value.length - actualMaxLengths[i] >= 0) {
                    System.arraycopy(value.tableChars, actualMaxLengths[i], tableCharsTemp2, 0, value.length - actualMaxLengths[i]);
                }
                rests[i] = new TableString(tableCharsTemp2);
                printedLength = actualMaxLengths[i];
                shouldPrintNext = true;
            } else if (value.tableChars[actualMaxLengths[i] - 1] instanceof TableFullCharLeft) {
                TableChar[] tableCharsTemp = new TableChar[actualMaxLengths[i] - 1];
                if (actualMaxLengths[i] - 1 >= 0) {
                    System.arraycopy(value.tableChars, 0, tableCharsTemp, 0, actualMaxLengths[i] - 1);
                }
                stringBuilder.append(new TableString(tableCharsTemp));
                tableCharsTemp2 = new TableChar[value.length - (actualMaxLengths[i] - 1)];
                if (value.length - (actualMaxLengths[i] - 1) >= 0) {
                    System.arraycopy(value.tableChars, actualMaxLengths[i] - 1, tableCharsTemp2, 0, value.length - (actualMaxLengths[i] - 1));
                }
                rests[i] = new TableString(tableCharsTemp2);
                printedLength = actualMaxLengths[i] - 1;
                shouldPrintNext = true;
            } else {
                printedLength = 0;
            }
            if (multiLines) {
                shouldPrintNext = true;
                LinkedList<List<TableChar>> list = new LinkedList<List<TableChar>>(item[i].lines);
                if (rests[i] == null) {
                    list.remove(0);
                } else {
                    list.set(0, Arrays.asList(rests[i].tableChars));
                }
                rests[i] = new TableString(list);
            }
            if (rests[i] == null) {
                rests[i] = new TableString("");
            }
            for (int j = 0; j < actualMaxLengths[i] - printedLength + 1; ++j) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('|');
        }
        stringBuilder.append('\n');
        if (shouldPrintNext) {
            TableUtils.printTableItem(stringBuilder, actualMaxLengths, rests);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengthsRatio", "com/mrshiehx/cmcl/utils/console/TableUtils", "toTable"));
    }

    static class TableFullCharRight
    extends TableChar {
        TableFullCharRight(char c) {
            super(c);
        }
    }

    static class TableFullCharLeft
    extends TableChar {
        TableFullCharLeft(char c) {
            super(c);
        }
    }

    static class TableHalfChar
    extends TableChar {
        TableHalfChar(char c) {
            super(c);
        }
    }

    static abstract class TableChar {
        final char c;

        TableChar(char c) {
            this.c = c;
        }

        public String toString() {
            return String.valueOf(this.c);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableChar tableChar = (TableChar)o;
            return this.c == tableChar.c;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.c));
        }
    }

    static class TableString {
        static final TableChar LINE_SEPARATOR = new TableChar('\n'){};
        final TableChar[] tableChars;
        final int length;
        final List<List<TableChar>> lines;
        final List<Integer> lengthsForLines;
        final int maxLengthForLines;

        TableString(List<List<TableChar>> lines) {
            LinkedList<TableChar> tableCharsList = new LinkedList<TableChar>();
            for (int i = 0; i < lines.size(); ++i) {
                List<TableChar> line = lines.get(i);
                tableCharsList.addAll(line);
                if (i + 1 == lines.size()) continue;
                tableCharsList.add(LINE_SEPARATOR);
            }
            this.tableChars = tableCharsList.toArray(new TableChar[0]);
            this.length = this.tableChars.length;
            this.lines = lines;
            this.lengthsForLines = Collections.unmodifiableList(this.lines.stream().map(List::size).collect(Collectors.toList()));
            this.maxLengthForLines = Collections.max(this.lengthsForLines);
        }

        TableString(TableChar[] tableChars) {
            this.tableChars = tableChars;
            this.length = tableChars.length;
            LinkedList lines = new LinkedList();
            lines.add(new LinkedList());
            for (TableChar tableChar : tableChars) {
                if (tableChar == LINE_SEPARATOR) {
                    lines.add(new LinkedList());
                    continue;
                }
                ((List)lines.get(lines.size() - 1)).add(tableChar);
            }
            this.lines = Collections.unmodifiableList(lines);
            this.lengthsForLines = Collections.unmodifiableList(this.lines.stream().map(List::size).collect(Collectors.toList()));
            this.maxLengthForLines = Collections.max(this.lengthsForLines);
        }

        TableString(String string) {
            string = String.valueOf(string).replace("\r\n", "\n").replace('\r', '\n');
            char[] charArray = string.toCharArray();
            LinkedList<TableChar> list = new LinkedList<TableChar>();
            for (char c : charArray) {
                if (c == '\n') {
                    list.add(LINE_SEPARATOR);
                    continue;
                }
                if (Utils.isFullWidth(c)) {
                    list.add(new TableFullCharLeft(c));
                    list.add(new TableFullCharRight(c));
                    continue;
                }
                list.add(new TableHalfChar(c));
            }
            this.tableChars = list.toArray(new TableChar[0]);
            this.length = list.size();
            LinkedList lines = new LinkedList();
            lines.add(new LinkedList());
            for (TableChar tableChar : this.tableChars) {
                if (tableChar == LINE_SEPARATOR) {
                    lines.add(new LinkedList());
                    continue;
                }
                ((List)lines.get(lines.size() - 1)).add(tableChar);
            }
            this.lines = Collections.unmodifiableList(lines);
            this.lengthsForLines = Collections.unmodifiableList(this.lines.stream().map(List::size).collect(Collectors.toList()));
            this.maxLengthForLines = Collections.max(this.lengthsForLines);
        }

        public String toString() {
            LinkedList<Character> list = new LinkedList<Character>();
            for (int i = 0; i < this.tableChars.length; ++i) {
                TableChar tableChar = this.tableChars[i];
                if (tableChar instanceof TableHalfChar || tableChar == LINE_SEPARATOR) {
                    list.add(Character.valueOf(tableChar.c));
                    continue;
                }
                if (tableChar instanceof TableFullCharLeft) {
                    list.add(Character.valueOf(tableChar.c));
                    ++i;
                    continue;
                }
                if (!(tableChar instanceof TableFullCharRight)) continue;
            }
            char[] chars = new char[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                chars[i] = ((Character)list.get(i)).charValue();
            }
            return new String(chars);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableString that = (TableString)o;
            return Arrays.equals(this.tableChars, that.tableChars);
        }

        public int hashCode() {
            return Arrays.hashCode(this.tableChars);
        }
    }
}

