/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.internet;

import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import com.mrshiehx.cmcl.utils.console.PercentageTextProgress;
import com.mrshiehx.cmcl.utils.internet.NetworkUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

public class DownloadUtils {
    public static void downloadFile(String url, File to) throws IOException {
        DownloadUtils.downloadFile(url, to, null);
    }

    public static void downloadFile(String urlString, File to, @Nullable PercentageTextProgress progressBar) throws IOException {
        DownloadUtils.downloadFile(urlString, to, progressBar, true);
    }

    public static void downloadFile(String urlString, File to, @Nullable PercentageTextProgress progressBar, boolean deleteIfExist) throws IOException {
        FileUtils.createFile(to, deleteIfExist || to.length() == 0L);
        try {
            URL url = new URL(NetworkUtils.encodeURL(urlString));
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            int completeFileSize = httpConnection.getContentLength();
            if (progressBar != null) {
                progressBar.setMaximum(completeFileSize);
            }
            httpConnection.setConnectTimeout(5000);
            httpConnection.setReadTimeout(5000);
            BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
            FileOutputStream fos = new FileOutputStream(to);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            long downloadedFileSize = 0L;
            int x = 0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                downloadedFileSize += (long)x;
                if (progressBar != null) {
                    progressBar.setValue((int)downloadedFileSize);
                }
                bout.write(data, 0, x);
            }
            if (progressBar != null) {
                progressBar.setValue(completeFileSize);
            }
            bout.close();
            fos.close();
            in.close();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            if (progressBar != null && !progressBar.done) {
                System.out.println();
            }
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            to.delete();
            throw e;
        }
    }

    public static byte[] downloadBytes(String url) throws IOException {
        try {
            int bytesRead;
            BufferedInputStream in = new BufferedInputStream(new URL(NetworkUtils.encodeURL(url)).openStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                byteArrayOutputStream.write(dataBuffer, 0, bytesRead);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static byte[] downloadBytes(String urlString, @Nullable PercentageTextProgress progressBar) throws IOException {
        try {
            URL url = new URL(NetworkUtils.encodeURL(urlString));
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            int completeFileSize = httpConnection.getContentLength();
            if (progressBar != null) {
                progressBar.setMaximum(completeFileSize);
            }
            BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] data = new byte[1024];
            long downloadedFileSize = 0L;
            int x = 0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                downloadedFileSize += (long)x;
                if (progressBar != null) {
                    progressBar.setValue((int)downloadedFileSize);
                }
                byteArrayOutputStream.write(data, 0, x);
            }
            if (progressBar != null) {
                progressBar.setValue(completeFileSize);
            }
            in.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            if (progressBar != null && !progressBar.done) {
                System.out.println();
            }
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static void multipleAttemptsDownload(String url, File to, boolean deleteIfExist) throws IOException {
        DownloadUtils.multipleAttemptsDownload(url, to, null, 5, deleteIfExist);
    }

    public static void multipleAttemptsDownload(String url, File to, int times, boolean deleteIfExist) throws IOException {
        DownloadUtils.multipleAttemptsDownload(url, to, null, times, deleteIfExist);
    }

    public static void multipleAttemptsDownload(String urlString, File to, @Nullable PercentageTextProgress progressBar, int times, boolean deleteIfExist) throws IOException {
        IOException finalThrowable = null;
        FileUtils.createFile(to, deleteIfExist || to.length() == 0L);
        for (int i = 0; i < times; ++i) {
            try {
                DownloadUtils.multipleAttemptsDownloadInternal(urlString, to, progressBar, deleteIfExist);
                return;
            }
            catch (MalformedURLException e) {
                if (progressBar != null && progressBar.printed && !progressBar.done) {
                    progressBar.setValue(0);
                }
                throw e;
            }
            catch (IOException e) {
                finalThrowable = e;
                if (progressBar == null || !progressBar.printed || progressBar.done) continue;
                progressBar.setValue(0);
                continue;
            }
        }
        if (finalThrowable != null) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw finalThrowable;
        }
    }

    private static void multipleAttemptsDownloadInternal(String urlString, File to, @Nullable PercentageTextProgress progressBar, boolean deleteIfExist) throws MalformedURLException, IOException {
        try {
            int x;
            URL url = new URL(NetworkUtils.encodeURL(urlString));
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            int completeFileSize = httpConnection.getContentLength();
            if (progressBar != null) {
                progressBar.setMaximum(completeFileSize);
            }
            httpConnection.setConnectTimeout(5000);
            httpConnection.setReadTimeout(5000);
            BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
            FileOutputStream fos = new FileOutputStream(to);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            long downloadedFileSize = 0L;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                downloadedFileSize += (long)x;
                if (progressBar != null) {
                    progressBar.setValue((int)downloadedFileSize);
                }
                bout.write(data, 0, x);
            }
            if (progressBar != null) {
                progressBar.setValue(completeFileSize);
            }
            bout.close();
            fos.close();
            in.close();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            if (deleteIfExist) {
                to.delete();
            }
            throw e;
        }
    }
}

