/*
 * Decompiled with CFR 0.152.
 */
package com.mrshiehx.cmcl.utils.internet;

import com.mrshiehx.cmcl.bean.Pair;
import com.mrshiehx.cmcl.constants.Constants;
import com.mrshiehx.cmcl.utils.FileUtils;
import com.mrshiehx.cmcl.utils.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class NetworkUtils {
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String NAME_VALUE_SEPARATOR = "=";

    public static List<Pair<String, String>> parseQuery(URI uri) {
        return NetworkUtils.parseQuery(uri.getRawQuery());
    }

    public static List<Pair<String, String>> parseQuery(String queryParameterString) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        if (Utils.isEmpty(queryParameterString)) {
            return result;
        }
        try (Scanner scanner = new Scanner(queryParameterString);){
            scanner.useDelimiter(PARAMETER_SEPARATOR);
            while (scanner.hasNext()) {
                String[] nameValue = scanner.next().split(NAME_VALUE_SEPARATOR);
                if (nameValue.length == 0 || nameValue.length > 2) {
                    throw new IllegalArgumentException("bad query string");
                }
                String name = URLDecoder.decode(nameValue[0], "UTF-8");
                String value = nameValue.length == 2 ? URLDecoder.decode(nameValue[1], "UTF-8") : null;
                result.add(new Pair<String, String>(name, value));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String post(String url, String content) throws IOException {
        return NetworkUtils.post(url, content, "application/json", null);
    }

    public static String post(String url, String content, String contentType, String accept) throws IOException {
        try {
            URL connectUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)connectUrl.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", contentType);
            if (!Utils.isEmpty(accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            OutputStream wrt = connection.getOutputStream();
            if (content != null) {
                wrt.write(content.getBytes());
            }
            String s = NetworkUtils.httpURLConnection2String(connection);
            wrt.close();
            return s;
        }
        catch (MalformedURLException | ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static String getWithToken(String url, String tokenType, String token) throws IOException {
        return NetworkUtils.getWithToken(url, tokenType, token, "application/json", "application/json");
    }

    public static String getWithToken(String url, String tokenType, String token, String contentType, String accept) throws IOException {
        try {
            URL connectUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)connectUrl.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("Authorization", tokenType + " " + token);
            if (!Utils.isEmpty(accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            return NetworkUtils.httpURLConnection2String(connection);
        }
        catch (MalformedURLException | ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static String get(String url) throws IOException {
        return NetworkUtils.get(url, "application/json", "application/json");
    }

    public static String get(String url, String contentType, String accept) throws IOException {
        try {
            URL ConnectUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)ConnectUrl.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", contentType);
            if (!Utils.isEmpty(accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            return NetworkUtils.httpURLConnection2String(connection);
        }
        catch (MalformedURLException | ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static String curseForgeGet(String url) throws IOException {
        return NetworkUtils.curseForgeGet(url, "application/json", "application/json");
    }

    public static String curseForgeGet(String url, String contentType, String accept) throws IOException {
        try {
            URL ConnectUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)ConnectUrl.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("x-api-key", Constants.getCurseForgeApiKey());
            if (!Utils.isEmpty(accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            return NetworkUtils.httpURLConnection2String(connection);
        }
        catch (MalformedURLException | ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static String delete(String url, String tokenType, String token) throws IOException {
        return NetworkUtils.delete(url, tokenType, token, "application/json", "application/json");
    }

    public static String delete(String url, String tokenType, String token, String contentType, String accept) throws IOException {
        try {
            URL ConnectUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)ConnectUrl.openConnection();
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("Authorization", tokenType + " " + token);
            if (!Utils.isEmpty(accept)) {
                connection.setRequestProperty("Accept", accept);
            }
            return NetworkUtils.httpURLConnection2String(connection);
        }
        catch (MalformedURLException | ProtocolException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    public static String httpURLConnection2String(HttpURLConnection con) throws IOException {
        String string;
        Throwable throwable;
        InputStream stdout;
        block31: {
            block32: {
                stdout = con.getInputStream();
                throwable = null;
                string = Utils.inputStream2String(stdout);
                if (stdout == null) break block31;
                if (throwable == null) break block32;
                try {
                    stdout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block31;
            }
            stdout.close();
        }
        return string;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (stdout != null) {
                        if (throwable != null) {
                            try {
                                stdout.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            stdout.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (IOException e) {
                try (InputStream stderr = con.getErrorStream();){
                    if (stderr == null) {
                        throw e;
                    }
                    String string2 = Utils.inputStream2String(stderr);
                    return string2;
                }
                {
                    catch (IOException e2) {
                        if (Utils.getConfig().optBoolean("proxyEnabled")) {
                            System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
                        }
                        throw e2;
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] httpURLConnection2Bytes(HttpURLConnection con) throws IOException {
        byte[] byArray;
        Throwable throwable;
        InputStream stdout;
        block31: {
            block32: {
                stdout = con.getInputStream();
                throwable = null;
                byArray = FileUtils.inputStream2ByteArray(stdout);
                if (stdout == null) break block31;
                if (throwable == null) break block32;
                try {
                    stdout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block31;
            }
            stdout.close();
        }
        return byArray;
        catch (Throwable throwable3) {
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (stdout != null) {
                        if (throwable != null) {
                            try {
                                stdout.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            stdout.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (IOException e) {
                try (InputStream stderr = con.getErrorStream();){
                    if (stderr == null) {
                        throw e;
                    }
                    byte[] byArray2 = FileUtils.inputStream2ByteArray(stderr);
                    return byArray2;
                }
                {
                    catch (IOException e2) {
                        if (Utils.getConfig().optBoolean("proxyEnabled")) {
                            System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
                        }
                        throw e2;
                    }
                }
            }
        }
    }

    public static void setProxy(String host, String port, String userName, String password) {
        if (Utils.isEmpty(host) || Utils.isEmpty(port)) {
            return;
        }
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("https.proxyHost", host);
        System.setProperty("http.proxyHost", host);
        if (!Utils.isEmpty(port)) {
            System.setProperty("https.proxyPort", port);
            System.setProperty("http.proxyPort", port);
        }
        if (!Utils.isEmpty(userName)) {
            System.setProperty("http.proxyUserName", userName);
            System.setProperty("https.proxyUserName", userName);
            if (!Utils.isEmpty(password)) {
                System.setProperty("http.proxyPassword", password);
                System.setProperty("https.proxyPassword", password);
            }
        }
    }

    public static String getWithToken(String url) throws IOException {
        try {
            int bytesRead;
            BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                byteOutputStream.write(dataBuffer, 0, bytesRead);
            }
            byteOutputStream.close();
            in.close();
            return byteOutputStream.toString();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            if (Utils.getConfig().optBoolean("proxyEnabled")) {
                System.err.println(Utils.getString("EXCEPTION_NETWORK_WRONG_PLEASE_CHECK_PROXY"));
            }
            throw e;
        }
    }

    public static String addSlashIfMissing(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static String encodeURL(String url) {
        StringBuilder sb = new StringBuilder();
        boolean left = true;
        for (char c : url.toCharArray()) {
            if (c == ' ') {
                sb.append(left ? "%20" : Character.valueOf('+'));
                continue;
            }
            if (c == '?') {
                left = false;
            }
            try {
                sb.append(c >= '\u0080' ? URLDecoder.decode(Character.toString(c), "UTF-8") : Character.valueOf(c));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }

    public static String addHttpsIfMissing(String url) {
        String lower = url.toLowerCase();
        if (!lower.startsWith("https://") && !lower.startsWith("http://")) {
            url = "https://" + url;
        }
        return url;
    }

    public static boolean urlEqualsIgnoreSlash(String a, String b) {
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        if (!b.endsWith("/")) {
            b = b + "/";
        }
        return a.equals(b);
    }
}

